/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards.stats;

import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.rewards.stats.StatWatcher;
import com.turborilla.utils.math.Quaternion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontflipStat
extends StatWatcher<Integer, Bike> {
    private float timePerFlip = 1.0f;
    private float curTime = 0.0f;
    private int flips = 0;
    private boolean pastNegativeHalfPI = false;
    private double previousAngle = 0.0;
    private double[] angles = new double[3];
    private boolean resetPreviousAngle = false;

    public FrontflipStat(Bike bike) {
        super(bike);
    }

    public FrontflipStat(float f, Bike bike, float f2) {
        super(f, bike);
        this.timePerFlip = f2;
    }

    @Override
    protected void doUpdate(float f) {
        if (!((Bike)this.object).isCrashing()) {
            Quaternion quaternion = ((Bike)this.object).getFrame().getWorldRotation();
            double d = quaternion.toAngles(this.angles)[2];
            if (this.flips > 0) {
                this.curTime += f;
                if (this.curTime > (float)this.flips * this.timePerFlip) {
                    this.checkAndRecord();
                    this.doReset();
                }
            } else {
                this.curTime = 0.0f;
            }
            if (!((Bike)this.object).isAirborne()) {
                this.checkAndRecord();
            }
            if (!this.pastNegativeHalfPI) {
                if (d < 0.0 && Math.abs(quaternion.z) < Math.abs(quaternion.w)) {
                    this.pastNegativeHalfPI = true;
                }
            } else if (d > 0.0 && Math.abs(quaternion.z) > Math.abs(quaternion.w)) {
                ++this.flips;
                this.pastNegativeHalfPI = false;
                this.checkAndRecord();
            } else if (d > 0.0) {
                this.pastNegativeHalfPI = false;
            }
        } else {
            this.doReset();
        }
    }

    @Override
    protected void doReset() {
        this.flips = 0;
        this.curTime = 0.0f;
        this.pastNegativeHalfPI = false;
        this.resetPreviousAngle = true;
    }

    @Override
    protected void checkAndRecord() {
        if (this.getStat() == null || this.flips > (Integer)this.getStat()) {
            this.setStat(this.flips);
        }
    }
}

