/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards.stats;

import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.rewards.stats.StatWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigAirStat
extends StatWatcher<Float, Bike> {
    private double airOnGround;
    private double air;

    public BigAirStat(Bike bike) {
        super(bike);
    }

    public BigAirStat(float f, Bike bike) {
        super(f, bike);
    }

    @Override
    protected void doUpdate(float f) {
        if (!((Bike)this.object).isCrashing()) {
            double d = ((Bike)this.object).getFrame().getHandlebar().position.y;
            if (((Bike)this.object).isAirborne()) {
                if ((d -= this.airOnGround) > this.air) {
                    this.air = d;
                }
            } else {
                this.airOnGround = d;
                if (this.air > 0.0) {
                    this.checkAndRecord();
                }
                this.air = 0.0;
            }
        } else {
            this.air = 0.0;
        }
    }

    @Override
    protected void doReset() {
        this.air = 0.0;
    }

    @Override
    protected void checkAndRecord() {
        float f = (float)this.air;
        if (this.getStat() == null || f > ((Float)this.getStat()).floatValue()) {
            this.setStat(Float.valueOf(f));
        }
    }
}

