/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.profile.RewardData;
import com.turborilla.msm.rewards.CollectedReward;
import com.turborilla.msm.rewards.listeners.IStatFinalizedListener;
import com.turborilla.msm.rewards.listeners.RewardIntervalListener;
import com.turborilla.msm.rewards.stats.BackflipStat;
import com.turborilla.msm.rewards.stats.BigAirStat;
import com.turborilla.msm.rewards.stats.DoubleBackflipStat;
import com.turborilla.msm.rewards.stats.FrontflipStat;
import com.turborilla.msm.rewards.stats.StatWatcher;
import com.turborilla.msm.rewards.stats.StoppieTimeStat;
import com.turborilla.msm.rewards.stats.WheelieTimeStat;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewardComponent
extends AbstractComponent {
    private static Logger logger = Logger.getLogger(RewardComponent.class.getName());
    private static float undoTime = 2.0f;
    private Bike bike;
    private ArrayList<StatWatcher<?, ?>> watchers;
    private boolean deltWithCrash = false;
    private static final Float[] wheelieTimeIntervals = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(5.0f), Float.valueOf(8.0f)};
    private static final Float[] stoppieTimeIntervals = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)};
    private static final Float[] bigAirIntervals = new Float[]{Float.valueOf(21.0f), Float.valueOf(33.0f), Float.valueOf(67.0f), Float.valueOf(90.0f), Float.valueOf(100.0f)};
    private static final String REWARD_BACKFLIP = "Backflip";
    private static final String REWARD_DOUBLE_BACKFLIP = "Double Backflip";
    private static final String REWARD_FRONTFLIP = "Frontflip";
    private static final String REWARD_BIGAIR = "Big Air";
    private static final String REWARD_WHEELIE = "Wheelie";
    private static final String REWARD_STOPPIE = "Stoppie";

    public RewardComponent(String string, Bike bike) {
        super(string);
        this.bike = bike;
        this.watchers = new ArrayList();
        this.setPaused(true);
        this.reset();
    }

    @Override
    public void init() {
        RewardIntervalListener rewardIntervalListener = new RewardIntervalListener(this.eventManager, REWARD_WHEELIE, (Comparable[])wheelieTimeIntervals, "Wheelie ");
        RewardIntervalListener rewardIntervalListener2 = new RewardIntervalListener(this.eventManager, REWARD_STOPPIE, (Comparable[])stoppieTimeIntervals, "Stoppie ");
        RewardIntervalListener rewardIntervalListener3 = new RewardIntervalListener(this.eventManager, REWARD_BIGAIR, (Comparable[])bigAirIntervals, "Big Air ");
        RewardIntervalListener rewardIntervalListener4 = new RewardIntervalListener(this.eventManager, REWARD_BACKFLIP, (Comparable[])new Integer[]{1, 2, 3, 4, 5}, "Backflips ");
        RewardIntervalListener rewardIntervalListener5 = new RewardIntervalListener(this.eventManager, REWARD_DOUBLE_BACKFLIP, (Comparable[])new Integer[]{1, 2, 3, 4, 5}, "Double Backflips ");
        RewardIntervalListener rewardIntervalListener6 = new RewardIntervalListener(this.eventManager, REWARD_FRONTFLIP, (Comparable[])new Integer[]{1, 2, 3, 4, 5}, "Frontflips ");
        this.watchers.add(new WheelieTimeStat(undoTime, this.bike).setChangedListener(rewardIntervalListener).setUndoListener(rewardIntervalListener).setFinalizedListener(rewardIntervalListener));
        this.watchers.add(new StoppieTimeStat(undoTime, this.bike).setChangedListener(rewardIntervalListener2).setUndoListener(rewardIntervalListener2).setFinalizedListener(rewardIntervalListener2));
        this.watchers.add(new BackflipStat(undoTime, this.bike, 4.0f).setChangedListener(rewardIntervalListener4).setUndoListener(rewardIntervalListener4).setFinalizedListener(rewardIntervalListener4));
        this.watchers.add(new DoubleBackflipStat(undoTime, this.bike, 500.0f).setChangedListener(rewardIntervalListener5).setUndoListener(rewardIntervalListener5).setFinalizedListener(rewardIntervalListener5));
        this.watchers.add(new FrontflipStat(undoTime, this.bike, 4.0f).setChangedListener(rewardIntervalListener6).setUndoListener(rewardIntervalListener6).setFinalizedListener(rewardIntervalListener6));
        this.watchers.add(new BigAirStat(undoTime, this.bike).setChangedListener(rewardIntervalListener3).setUndoListener(rewardIntervalListener3).setFinalizedListener(rewardIntervalListener3));
    }

    public void startCollectingStats(RewardData rewardData) {
        this.reset();
        this.setPaused(false);
    }

    public void stopCollectingStats() {
        this.finalizeAll();
        this.setPaused(true);
    }

    private void loadFromProfile(RewardData rewardData) {
        for (int i = 0; i < this.watchers.size(); ++i) {
            IStatFinalizedListener<?> iStatFinalizedListener = this.watchers.get(i).getFinalizedListener();
            iStatFinalizedListener.setFinalizedInterval(rewardData.getNumberOfStars(iStatFinalizedListener.getRewardIdentifier()));
        }
    }

    public ArrayList<CollectedReward> saveToProfile(RewardData rewardData, ArrayList<CollectedReward> arrayList) {
        ArrayList<CollectedReward> arrayList2 = new ArrayList<CollectedReward>();
        int n = 0;
        for (int i = 0; i < this.watchers.size(); ++i) {
            IStatFinalizedListener<?> iStatFinalizedListener = this.watchers.get(i).getFinalizedListener();
            CollectedReward collectedReward = new CollectedReward();
            collectedReward.rewardIdentifier = iStatFinalizedListener.getRewardIdentifier();
            collectedReward.newNumberOfStars = iStatFinalizedListener.getFinalizedInterval();
            collectedReward.oldNumberOfStars = rewardData.getNumberOfStars(collectedReward.rewardIdentifier);
            rewardData.setNumberOfStars(collectedReward.rewardIdentifier, collectedReward.newNumberOfStars);
            if (collectedReward.newNumberOfStars > collectedReward.oldNumberOfStars) {
                arrayList2.add(collectedReward);
            } else if (collectedReward.newNumberOfStars > 0 && arrayList != null) {
                arrayList.add(collectedReward);
            }
            n += collectedReward.newNumberOfStars;
        }
        rewardData.checkAndRecordMostStars(n);
        return arrayList2;
    }

    private void finalizeAll() {
        for (int i = 0; i < this.watchers.size(); ++i) {
            this.watchers.get(i).forceApplyPendingChange();
            this.watchers.get(i).forceFinalize();
        }
    }

    @Override
    protected void componentUpdate(float f) {
        for (int i = 0; i < this.watchers.size(); ++i) {
            this.watchers.get(i).update(f);
        }
        if (this.bike.isCrashing()) {
            if (!this.deltWithCrash) {
                this.onCrash();
                this.deltWithCrash = true;
            }
        } else {
            this.deltWithCrash = false;
        }
    }

    protected void onCrash() {
        for (int i = 0; i < this.watchers.size(); ++i) {
            this.watchers.get(i).undo();
        }
    }

    protected void reset() {
        for (int i = 0; i < this.watchers.size(); ++i) {
            this.watchers.get(i).reset();
        }
    }
}

