/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.rewards;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.Label;
import com.turborilla.gui.VerticalLabelList;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.utils.Font;

public class LabelAndStarsEntry
extends VerticalLabelList.LabelEntry {
    private Stars stars;
    private static Vector3f tempVec = new Vector3f();

    public LabelAndStarsEntry(VerticalLabelList verticalLabelList, Label label, Font font, Texture texture, Texture texture2) {
        VerticalLabelList verticalLabelList2 = verticalLabelList;
        verticalLabelList2.getClass();
        super(label);
        this.stars = new Stars(texture, texture2, 0.1f);
        label.attachChild(this.stars);
        this.stars.setLocalTranslation(5.0f, (float)(-font.getLineHeight()) * 0.5f, 0.0f);
        label.setLocalScale(1.0f * ((float)DisplaySystem.getDisplaySystem().getHeight() / 1024.0f));
    }

    public Stars getStars() {
        return this.stars;
    }

    public static LabelAndStarsEntry getOrCreateLabel(String string, String string2, VerticalLabelList verticalLabelList, Font font, Texture texture, Texture texture2) {
        Label label;
        LabelAndStarsEntry labelAndStarsEntry = (LabelAndStarsEntry)verticalLabelList.findLabel(string);
        if (labelAndStarsEntry == null) {
            label = new Label(string, font, string2.length() + 5);
            label.setRightAligned(true);
            labelAndStarsEntry = new LabelAndStarsEntry(verticalLabelList, label, font, texture, texture2);
            verticalLabelList.addLabel(labelAndStarsEntry);
        }
        label = labelAndStarsEntry.getLabel();
        label.setText(string2);
        return labelAndStarsEntry;
    }

    public class Stars
    extends Node {
        private int numberOfStars = 5;
        private Quad[] starQuads;
        private TextureState[] ts;
        private float padding;
        private Texture onTexture;
        private Texture offTexture;
        private int numberOfLit = 0;

        public int getNumberOfLit() {
            return this.numberOfLit;
        }

        public Stars(Texture texture, Texture texture2, float f) {
            this.padding = f;
            this.onTexture = texture;
            this.offTexture = texture2;
            float f2 = (float)texture.getImage().getWidth() * 1.1f;
            float f3 = (float)texture.getImage().getHeight() * 1.1f;
            float f4 = f2 * this.padding;
            this.starQuads = new Quad[this.numberOfStars];
            this.ts = new TextureState[this.numberOfStars];
            for (int i = 0; i < this.numberOfStars; ++i) {
                float f5 = i;
                float f6 = f4 * 0.5f + f2 * 0.5f + (f4 + f2) * f5;
                Quad quad = new Quad("starQuad" + i, f2, f3);
                this.attachChild(quad);
                quad.setLocalTranslation(f6, 0.0f, 0.0f);
                this.ts[i] = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                this.ts[i].setTexture(texture2);
                quad.setRenderState(this.ts[i]);
                quad.updateRenderState();
                this.starQuads[i] = quad;
            }
        }

        public void setNumberOfLit(int n) {
            this.numberOfLit = n;
            for (int i = 0; i < this.numberOfStars; ++i) {
                if (i < n) {
                    this.ts[i].setTexture(this.onTexture);
                    continue;
                }
                this.ts[i].setTexture(this.offTexture);
            }
            this.updateRenderState();
        }

        public int[] setNumberOfLit(int n, ParticleFXGameObject particleFXGameObject) {
            int[] nArray = new int[this.numberOfStars];
            for (int i = 0; i < this.numberOfStars; ++i) {
                nArray[i] = -1;
                if (i < n) {
                    this.ts[i].setTexture(this.onTexture);
                    if (i + 1 <= this.numberOfLit) continue;
                    nArray[i] = particleFXGameObject.startFirstAvailable();
                    if (nArray[i] < 0) continue;
                    Node node = particleFXGameObject.getNode(nArray[i]);
                    particleFXGameObject.detachFromParent(nArray[i]);
                    particleFXGameObject.attachToNode(this, nArray[i]);
                    node.getLocalTranslation().set(this.starQuads[i].getLocalTranslation());
                    continue;
                }
                this.ts[i].setTexture(this.offTexture);
            }
            this.numberOfLit = n;
            this.updateRenderState();
            return nArray;
        }
    }
}

