/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.turborilla.sound.CompositeSFX;

public class ReplayableCompositeSFX
extends CompositeSFX {
    public ISFXListener stateChangedListener;

    public ReplayableCompositeSFX(CompositeSFX compositeSFX) {
        super(compositeSFX.getSoundSystem());
        this.setTracks(compositeSFX.getTracks(), compositeSFX.getProbabilities());
    }

    public ISFXListener getStateChangedListener() {
        return this.stateChangedListener;
    }

    public void setStateChangedListener(ISFXListener iSFXListener) {
        this.stateChangedListener = iSFXListener;
    }

    protected void play(float f, String string) {
        super.play(f, string);
        if (this.getStateChangedListener() != null) {
            this.getStateChangedListener().changedState(true, this.indexOf(string), this.volume, this.getPitch() * f);
        }
    }

    private int indexOf(String string) {
        for (int i = 0; i < this.getTracks().length; ++i) {
            if (!this.getTracks()[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public String play(int n, float f, float f2) {
        while (n >= this.getTracks().length) {
            n -= this.getTracks().length;
        }
        String string = this.getTracks()[n];
        super.play(f2, string);
        this.lastPlayed = string;
        return this.lastPlayed;
    }

    public String stopDontNotifyListener() {
        super.stop();
        return this.lastPlayed;
    }

    public void stop() {
        super.stop();
        if (this.getStateChangedListener() != null) {
            this.getStateChangedListener().changedState(false, 0, 0.0f, 0.0f);
        }
    }

    public static interface ISFXListener {
        public void changedState(boolean var1, int var2, float var3, float var4);
    }
}

