/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.replay.nioreplay.NioReplay;
import java.io.IOException;
import java.util.logging.Logger;

public class ReplayParticipant
implements Savable {
    protected String specialAbility;
    protected BikeResult bikeResult;
    protected NioReplay replayData;
    private int version = 1;

    public ReplayParticipant(String string, BikeResult bikeResult, NioReplay nioReplay) {
        this.specialAbility = string;
        this.bikeResult = bikeResult;
        this.replayData = nioReplay;
    }

    public ReplayParticipant() {
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 1);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.specialAbility = inputCapsule.readString("specialAbility", null);
                this.bikeResult = (BikeResult)inputCapsule.readSavable("bikeResult", null);
                this.replayData = (NioReplay)inputCapsule.readSavable("replayData", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 1);
        outputCapsule.write(this.specialAbility, "specialAbility", null);
        outputCapsule.write(this.bikeResult, "bikeResult", null);
        outputCapsule.write(this.replayData, "replayData", null);
    }

    public String getSpecialAbility() {
        return this.specialAbility;
    }

    public void setSpecialAbility(String string) {
        this.specialAbility = string;
    }

    public BikeResult getBikeResult() {
        return this.bikeResult;
    }

    public void setBikeResult(BikeResult bikeResult) {
        this.bikeResult = bikeResult;
    }

    public NioReplay getReplayData() {
        return this.replayData;
    }

    public void setReplayData(NioReplay nioReplay) {
        this.replayData = nioReplay;
    }
}

