/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.OutputCapsule;
import com.turborilla.TransformationProvider;
import com.turborilla.utils.math.Quaternion;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class ReplayDataTransformation
extends com.turborilla.replay.nioreplay.ReplayDataTransformation {
    private Vector3d defaultScale;
    private double defaultZ;
    private double defaultRotationX;
    private double defaultRotationY;

    public ReplayDataTransformation(double d, Vector3d vector3d) {
        this.elementSize = 16;
        this.defaultScale = new Vector3d(vector3d);
        this.defaultZ = d;
        this.defaultRotationX = 0.0;
        this.defaultRotationY = 0.0;
    }

    public ReplayDataTransformation() {
        this.elementSize = 16;
        this.defaultScale = new Vector3d(1.0, 1.0, 1.0);
        this.defaultZ = 0.0;
        this.defaultRotationX = 0.0;
        this.defaultRotationY = 0.0;
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            Logger.getLogger(ReplayDataTransformation.class.getName()).warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        for (int i = 0; i < this.providers.size(); ++i) {
            TransformationProvider transformationProvider = (TransformationProvider)this.providers.get(i);
            Vector3d vector3d = transformationProvider.getLocalTranslation();
            Quaternion quaternion = transformationProvider.getLocalRotation();
            this.tempBuffer.putFloat((float)vector3d.x);
            this.tempBuffer.putFloat((float)vector3d.y);
            this.tempBuffer.putFloat((float)quaternion.z);
            this.tempBuffer.putFloat((float)quaternion.w);
        }
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    protected void setTransformationState(Vector3d vector3d, Quaternion quaternion, Vector3d vector3d2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        double d2 = byteBuffer.getFloat();
        double d3 = byteBuffer2.getFloat();
        vector3d.x = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        vector3d.y = d2 + (d3 - d2) * d;
        vector3d.z = this.defaultZ;
        quaternion.x = this.defaultRotationX;
        quaternion.y = this.defaultRotationY;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.z = d2 + (d3 - d2) * d;
        d2 = byteBuffer.getFloat();
        d3 = byteBuffer2.getFloat();
        quaternion.w = d2 + (d3 - d2) * d;
        vector3d2.set(this.defaultScale);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.defaultZ, "defaultZ", 0.0);
        outputCapsule.write(this.scale, "scale", null);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        super.read(n, inputCapsule);
        switch (n) {
            case 1: {
                this.defaultZ = inputCapsule.readDouble("defaultZ", 0.0);
                this.scale = (Vector3d)inputCapsule.readSavable("scale", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }
}

