/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.turborilla.msm.components.EngineSoundComponent;
import com.turborilla.msm.replay.ReplayDataParticleObject;
import com.turborilla.replay.nioreplay.BaseReplayData;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class ReplayDataEngineSound
extends BaseReplayData {
    private static final Logger logger = Logger.getLogger(ReplayDataParticleObject.class.getName());
    private EngineSoundComponent engineSoundComponent;
    protected int elementSize = 1;

    public ReplayDataEngineSound() {
    }

    public ReplayDataEngineSound(EngineSoundComponent engineSoundComponent) {
        this.setEngineSoundComponent(engineSoundComponent);
    }

    public void setEngineSoundComponent(EngineSoundComponent engineSoundComponent) {
        this.engineSoundComponent = engineSoundComponent;
        this.setSize(this.elementSize);
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            logger.warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        byte by = 0;
        if (this.engineSoundComponent != null) {
            by = (byte)((this.engineSoundComponent.getCurrentPitch() - 1.0) * 127.0);
        }
        this.tempBuffer.put(by);
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    public void setCurrentState(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        if (this.engineSoundComponent != null) {
            double d2 = (double)byteBuffer.get() / 127.0 + 1.0;
            double d3 = (double)byteBuffer2.get() / 127.0 + 1.0;
            double d4 = d2 + (d3 - d2) * d;
            this.engineSoundComponent.setPitchFromReplay(d4);
        }
    }
}

