/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.turborilla.msm.replay.ReplayDataParticleObject;
import com.turborilla.msm.replay.ReplayableCompositeSFX;
import com.turborilla.replay.nioreplay.BaseReplayData;
import java.nio.ByteBuffer;
import java.util.logging.Logger;

public class ReplayDataCompositeSFX
extends BaseReplayData {
    private static final Logger logger = Logger.getLogger(ReplayDataParticleObject.class.getName());
    private ReplayableCompositeSFX sfx;
    protected int elementSize = 3;
    boolean triggeredStop = false;
    boolean triggeredPlay = false;
    int trackIndex;
    float volume;
    float pitch;
    private double previousInterpolant = Double.MAX_VALUE;

    public ReplayDataCompositeSFX() {
    }

    public ReplayDataCompositeSFX(ReplayableCompositeSFX replayableCompositeSFX) {
        this.setCompositeSFX(replayableCompositeSFX);
    }

    public void setCompositeSFX(ReplayableCompositeSFX replayableCompositeSFX) {
        this.sfx = replayableCompositeSFX;
        if (replayableCompositeSFX != null) {
            this.sfx.setStateChangedListener(new ReplayableCompositeSFX.ISFXListener(){

                public void changedState(boolean bl, int n, float f, float f2) {
                    if (bl) {
                        ReplayDataCompositeSFX.this.triggeredPlay(n, f, f2);
                    } else {
                        ReplayDataCompositeSFX.this.triggeredStop();
                    }
                }
            });
        }
        this.setSize(this.elementSize);
    }

    private void triggeredStop() {
        this.triggeredStop = true;
    }

    private void triggeredPlay(int n, float f, float f2) {
        this.triggeredPlay = true;
        this.trackIndex = n;
        this.volume = f;
        this.pitch = f2;
    }

    public ByteBuffer getCurrentState() {
        if (!this.isLocked()) {
            logger.warning("Cannot get current state for replay when not locked for recording");
            return null;
        }
        this.tempBuffer.clear();
        byte by = -1;
        byte by2 = 0;
        byte by3 = 0;
        if (this.triggeredStop) {
            this.triggeredStop = false;
            by = -2;
        } else if (this.triggeredPlay) {
            this.triggeredPlay = false;
            by = (byte)this.trackIndex;
            by2 = (byte)((this.volume - 0.5f) * 255.0f);
            by3 = (byte)((this.pitch - 1.0f) * 127.0f);
        }
        this.tempBuffer.put(by);
        this.tempBuffer.put(by2);
        this.tempBuffer.put(by3);
        this.tempBuffer.flip();
        return this.tempBuffer;
    }

    public void setCurrentState(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, double d) {
        if (this.sfx != null && d < this.previousInterpolant) {
            byte by = byteBuffer2.get();
            byte by2 = byteBuffer2.get();
            byte by3 = byteBuffer2.get();
            if (by == -2) {
                this.sfx.stopDontNotifyListener();
            } else if (by >= 0) {
                this.sfx.play(by, (float)by2 / 255.0f + 0.5f, (float)by3 / 127.0f + 1.0f);
            }
        }
        this.previousInterpolant = d;
    }
}

