/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.replay;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.turborilla.msm.replay.ReplayParticipant;
import com.turborilla.msm.rewards.CollectedReward;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.track.Track1D;
import com.turborilla.replay.nioreplay.NioReplay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayAI
implements Savable {
    private String trackName;
    private String trackHash;
    private ReplayParticipant opponentReplay;
    private int version = 1;

    public ReplayAI() {
    }

    public ReplayAI(Track1D track1D, ReplayParticipant replayParticipant) {
        this(track1D.getName(), track1D.getHash(), replayParticipant);
    }

    public ReplayAI(String string, String string2, ReplayParticipant replayParticipant) {
        this.trackName = string;
        this.trackHash = string2;
        this.opponentReplay = replayParticipant;
    }

    public float getRaceTime() {
        return this.getOpponentReplay().getBikeResult().getPassedFinishlineAtTime();
    }

    public ArrayList<CollectedReward> getCollectedRewards() {
        return this.getOpponentReplay().getBikeResult().getImprovedRewards();
    }

    @Override
    public Class getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 1);
        if (n != this.version) {
            Logger.getLogger(this.getClassTag().getName()).warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    protected void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.trackName = inputCapsule.readString("trackName", null);
                this.trackHash = inputCapsule.readString("trackHash", null);
                this.opponentReplay = (ReplayParticipant)inputCapsule.readSavable("opponentReplay", null);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 1);
        outputCapsule.write(this.trackName, "trackName", null);
        outputCapsule.write(this.trackHash, "trackHash", null);
        outputCapsule.write(this.opponentReplay, "opponentReplay", null);
    }

    public String getTrackName() {
        return this.trackName;
    }

    public String getTrackHash() {
        return this.trackHash;
    }

    public ReplayParticipant getOpponentReplay() {
        return this.opponentReplay;
    }

    public BikeResult getBikeResult() {
        return this.opponentReplay.getBikeResult();
    }

    public NioReplay getReplayData() {
        return this.opponentReplay.getReplayData();
    }

    public String getSpecialAbility() {
        return this.opponentReplay.getSpecialAbility();
    }
}

