/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RewardData
implements Serializable,
Savable {
    private static final long serialVersionUID = -4534053450897417640L;
    private static final Logger logger = Logger.getLogger(RewardData.class.getCanonicalName());
    private ArrayList<Reward> rewards;
    private int mostStarsInOneRace = 0;
    private String[] availableRewardIdentifiers = new String[]{"Backflip", "Double Backflip", "Frontflip", "Big Air", "Wheelie", "Stoppie"};
    private int version = 1;

    public RewardData() {
        this.rewards = new ArrayList();
    }

    public int getNumberOfStars(String string) {
        Reward reward = this.findReward(string);
        if (reward != null) {
            return reward.getNumberOfStars();
        }
        return 0;
    }

    public int setNumberOfStars(String string, int n) {
        int n2 = 0;
        Reward reward = this.findReward(string);
        if (reward != null) {
            n2 = reward.getNumberOfStars();
        } else {
            reward = new Reward(string);
            this.rewards.add(reward);
        }
        if (n > n2) {
            reward.setNumberOfStars(n);
        }
        return n2;
    }

    public void reset() {
        this.rewards.clear();
        this.mostStarsInOneRace = 0;
    }

    private Reward findReward(String string) {
        Reward reward = null;
        for (int i = 0; i < this.rewards.size(); ++i) {
            if (!this.rewards.get(i).getRewardIdentifier().equals(string)) continue;
            reward = this.rewards.get(i);
            break;
        }
        return reward;
    }

    public String[] getAvailableRewardsIdentifiers() {
        return this.availableRewardIdentifiers;
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.rewards = inputCapsule.readSavableArrayList("rewards", null);
                this.mostStarsInOneRace = inputCapsule.readInt("mostStars", 0);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        if (this.rewards != null) {
            outputCapsule.writeSavableArrayList(this.rewards, "rewards", null);
        }
        outputCapsule.write(this.mostStarsInOneRace, "mostStars", 0);
    }

    public int checkAndRecordMostStars(int n) {
        int n2 = n - this.mostStarsInOneRace;
        if (n2 > 0) {
            this.mostStarsInOneRace = n;
        }
        return n2;
    }

    public int getMostStarsInOneRace() {
        return this.mostStarsInOneRace;
    }

    public static class Reward
    implements Serializable,
    Savable {
        private static final long serialVersionUID = -9054231316742222790L;
        private String rewardIdentifier;
        private int numberOfStars = 0;
        private int version = 1;

        public Reward() {
        }

        public Reward(String string) {
            this.rewardIdentifier = string;
        }

        public int getNumberOfStars() {
            return this.numberOfStars;
        }

        public void setNumberOfStars(int n) {
            this.numberOfStars = n;
        }

        public String getRewardIdentifier() {
            return this.rewardIdentifier;
        }

        public Class getClassTag() {
            return this.getClass();
        }

        public void read(JMEImporter jMEImporter) throws IOException {
            InputCapsule inputCapsule = jMEImporter.getCapsule(this);
            int n = inputCapsule.readInt("version", 0);
            if (n != this.version) {
                logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
            }
            this.read(n, inputCapsule);
        }

        private void read(int n, InputCapsule inputCapsule) throws IOException {
            switch (n) {
                case 1: {
                    this.rewardIdentifier = inputCapsule.readString("rewardIdentifier", "");
                    this.numberOfStars = inputCapsule.readInt("numberOfStars", 0);
                    break;
                }
                default: {
                    throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
                }
            }
        }

        public void write(JMEExporter jMEExporter) throws IOException {
            OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
            outputCapsule.write(this.version, "version", 0);
            outputCapsule.write(this.rewardIdentifier, "rewardIdentifier", "");
            outputCapsule.write(this.numberOfStars, "numberOfStars", 0);
        }
    }
}

