/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.profile;

import com.jme.system.GameSettings;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.JoystickData;
import com.turborilla.msm.profile.ProfileData;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Profile
implements Serializable,
Savable {
    private static final long serialVersionUID = -371508447204843131L;
    private String name = "";
    private Difficulty difficulty = Difficulty.Arcade;
    private boolean demoVersionProfile = true;
    public static final String defaultName = "Kermit";
    private ArrayList<ProfileData> datalist = new ArrayList();
    private static boolean simulationModeAvailable = false;
    private static String suffix = ".msmprof";
    private static final Logger logger = Logger.getLogger(Profile.class.getCanonicalName());
    private static Profile cacheProfile = null;
    private int version = 1;
    private static final String backupSuffix = ".bak";

    public Profile() {
    }

    public Profile(String string) {
        this();
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (!string.equals(this.name)) {
            File file = new File(SystemFolder.getSavegameFolder(null));
            File file2 = new File(file, this.name + suffix);
            File file3 = new File(file, this.name + suffix + backupSuffix);
            File file4 = new File(file, string + suffix);
            File file5 = new File(file, string + suffix + backupSuffix);
            if (file4.exists()) {
                return;
            }
            if (file2.exists()) {
                file2.renameTo(file4);
                if (file5.exists()) {
                    file5.delete();
                }
                if (file3.exists()) {
                    file3.renameTo(file5);
                }
            }
            this.name = string;
        }
        this.save();
    }

    void forceSave(String string) {
        this.name = string;
        this.save();
    }

    public void save() {
        File file = new File(SystemFolder.getSavegameFolder(null));
        File file2 = new File(file, this.name + suffix);
        File file3 = new File(file, this.name + suffix + backupSuffix);
        if (file2.exists()) {
            if (file3.exists()) {
                file3.delete();
            }
            file2.renameTo(file3);
        }
        BinaryExporter binaryExporter = BinaryExporter.getInstance();
        try {
            binaryExporter.save((Savable)this, new File(file, this.name + suffix));
        }
        catch (RuntimeException runtimeException) {
            logger.severe("Could not save profile \"" + this.name + "\". Exception: " + runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            logger.severe("Could not save profile \"" + this.name + "\". Exception: " + exception);
            throw new RuntimeException(exception);
        }
    }

    public static Profile findProfile(String string) {
        return Profile.findProfile(string, suffix, suffix + backupSuffix);
    }

    private static Profile findProfile(String string, String string2, String string3) {
        if (string == null || "".equals(string)) {
            return null;
        }
        final String string4 = string + string2;
        File file = new File(SystemFolder.getSavegameFolder(null));
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.equals(string4);
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            Profile profile;
            File file2 = fileArray[i];
            String string5 = file2.getName();
            if (string2 != null && string5 != null) {
                string5 = string5.substring(0, string5.lastIndexOf(string2));
            }
            if (string5 == null || !string5.equals(string) || (profile = Profile.loadProfile(file2, string5)) == null) continue;
            return profile;
        }
        if (string3 != null) {
            logger.warning("Could not find profile \"" + string + "\", trying with suffix \"" + string3 + "\"");
            return Profile.findProfile(string, string3, null);
        }
        logger.warning("Could not find profile \"" + string + "\"");
        return null;
    }

    private static Profile loadProfile(File file, String string) {
        Profile profile = null;
        try {
            profile = (Profile)BinaryImporter.getInstance().load(file);
            if (profile != null) {
                profile.setName(string);
            }
        }
        catch (Exception exception) {
            logger.severe("Could not load profile \"" + string + "\". Exception: " + exception);
        }
        return profile;
    }

    public static void setCurrentProfile(GameSettings gameSettings, String string) {
        gameSettings.set("currentProfile", string);
    }

    public static String getCurrentProfileName(GameSettings gameSettings) {
        return Profile.getCurrentProfile(gameSettings).getName();
    }

    public static Profile getCurrentProfile(GameSettings gameSettings) {
        Object object;
        boolean bl = true;
        String string = gameSettings.get("currentProfile", null);
        Profile profile = null;
        profile = cacheProfile != null && string != null && string.equals(cacheProfile.getName()) ? cacheProfile : Profile.findProfile(string);
        if (profile == null) {
            FilenameFilter filenameFilter;
            object = new File(SystemFolder.getSavegameFolder(null));
            File[] fileArray = ((File)object).listFiles(filenameFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(suffix);
                }
            });
            if (fileArray != null && fileArray.length > 0) {
                String string2 = fileArray[0].getName();
                if (suffix != null && string2 != null) {
                    string2 = string2.substring(0, string2.lastIndexOf(suffix));
                }
                if (string2 != null) {
                    Profile.setCurrentProfile(gameSettings, string2);
                    Profile profile2 = null;
                    profile2 = Profile.findProfile(string2);
                    if (profile2 != null) {
                        Profile.setCurrentProfile(gameSettings, profile2.getName());
                        profile = profile2;
                        bl = false;
                    }
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        object = "";
        if (profile != null && !profile.demoVersionProfile && "Demo".equals(gameSettings.get("version", "Demo"))) {
            bl = true;
            object = "Demo";
        }
        if (bl) {
            profile = new Profile();
            profile.forceSave(defaultName + (String)object);
            Profile.setCurrentProfile(gameSettings, profile.getName());
        }
        if (profile != null && profile.demoVersionProfile && !"Demo".equals(gameSettings.get("version", "Demo"))) {
            profile.demoVersionProfile = false;
            profile.save();
        }
        cacheProfile = profile;
        return profile;
    }

    public static String[] getAllProfiles() {
        FilenameFilter filenameFilter;
        File file = new File(SystemFolder.getSavegameFolder(null));
        File[] fileArray = file.listFiles(filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(suffix);
            }
        });
        if (fileArray == null || fileArray.length <= 0) {
            return new String[0];
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName().substring(0, fileArray[i].getName().lastIndexOf(suffix));
        }
        return stringArray;
    }

    public Difficulty getDifficulty() {
        if (this.difficulty == null) {
            this.difficulty = Difficulty.Arcade;
        }
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
        this.save();
    }

    public Difficulty[] getAvailableDifficulties() {
        return Difficulty.values();
    }

    public ProfileData getData() {
        return this.getData(this.difficulty);
    }

    public ProfileData getData(Difficulty difficulty) {
        ProfileData profileData = null;
        ProfileData profileData2 = null;
        Difficulty difficulty2 = Difficulty.Arcade;
        if (difficulty == Difficulty.Simulation) {
            difficulty2 = Difficulty.Arcade;
        }
        if (difficulty == Difficulty.Arcade) {
            difficulty2 = Difficulty.Simulation;
        }
        for (ProfileData profileData3 : this.datalist) {
            if (profileData3.getDifficulty() == difficulty) {
                profileData = profileData3;
                continue;
            }
            if (profileData3.getDifficulty() != difficulty2) continue;
            profileData2 = profileData3;
        }
        if (profileData == null) {
            profileData = new ProfileData();
            profileData.setDifficulty(difficulty);
            this.datalist.add(profileData);
        }
        if (profileData2 != null && !profileData.getInputData().getJoystickData().isConfigured() && profileData2.getInputData().getJoystickData().isConfigured()) {
            try {
                profileData.getInputData().setJoystickData((JoystickData)profileData2.getInputData().getJoystickData().clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return profileData;
    }

    public float getCompletionPercentage(Difficulty difficulty) {
        return this.getData(difficulty).getPercentageDone();
    }

    public String toString() {
        return this.getName() + "\n" + this.getData();
    }

    public void reset() {
        for (Difficulty difficulty : Difficulty.values()) {
            this.getData(difficulty).reset();
        }
        this.save();
    }

    public Class getClassTag() {
        return this.getClass();
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        int n = inputCapsule.readInt("version", 0);
        if (n != this.version) {
            logger.warning("Loading a different version of " + this.getClassTag() + ". Version on file: " + n + " current version: " + this.version);
        }
        this.read(n, inputCapsule);
    }

    private void read(int n, InputCapsule inputCapsule) throws IOException {
        switch (n) {
            case 1: {
                this.difficulty = Difficulty.valueOf(inputCapsule.readString("difficulty", Difficulty.Arcade.name()));
                this.datalist = inputCapsule.readSavableArrayList("datalist", null);
                this.name = inputCapsule.readString("name", defaultName);
                this.demoVersionProfile = inputCapsule.readBoolean("demoVersionProfile", true);
                break;
            }
            default: {
                throw new IOException("Do not know how to load version " + n + " of " + this.getClassTag());
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.version, "version", 0);
        outputCapsule.write(this.getName(), "name", defaultName);
        outputCapsule.write(this.difficulty.name(), "difficulty", Difficulty.Arcade.name());
        if (this.datalist != null) {
            outputCapsule.writeSavableArrayList(this.datalist, "datalist", null);
        }
        outputCapsule.write(this.demoVersionProfile, "demoVersionProfile", true);
    }
}

