/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.objects;

import com.turborilla.physics.particle.ConstraintDamper;
import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.ForceTorqueVector;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;

public class BikeWheel
extends ParticleObject {
    private Particle wheelCenter;
    private Particle[] stokes;
    private Vector3d planeNormal = new Vector3d(0.0, 0.0, 1.0);
    private double angularVelocity = 0.0;
    private int numStokes = 14;
    private int reinforcement = 2;
    private int numParticles = this.numStokes + 1;
    private double centerWeight = 0.5;
    private double radius = 0.5;
    private double stokeStiffness = 560.0;
    private double rimStiffness = 120.0;
    private double rimDamp = 1.0;
    private double mass = 0.0;
    private ForceTorqueVector[] brakingForces;
    private ForceTorqueVector[] throttlingForces;
    private double initialDamp;
    private Particle throttleParticle;
    private ConstraintSpring[] throttleSprings;
    private double throttleAmount = 0.0;
    private double brakeAmount = 0.0;
    private boolean chaindrive = true;
    private boolean permaBrake = false;
    private float permaBrakeAmount = 30.0f;
    private static final Vector3d temp1 = new Vector3d();
    private static final Vector3d temp2 = new Vector3d();
    private static final Vector3d temp3 = new Vector3d();
    private double largestVelocity = 0.0;
    private Vector3d tempAngularVelocity = new Vector3d();
    private Vector3d yAxis = new Vector3d();
    private Vector3d yAxisPrev = new Vector3d();
    private Vector3d dir = new Vector3d();

    public BikeWheel(String string) {
        super(string);
        this.initialDamp = this.getDamp();
    }

    public void init(Vector3d vector3d, boolean bl, double d, double d2) {
        this.radius = d2;
        this.init(vector3d, bl, d);
    }

    public void init(Vector3d vector3d, boolean bl, double d) {
        ConstraintDamper constraintDamper;
        ConstraintStick constraintStick;
        int n;
        this.stokes = new Particle[this.numStokes];
        this.brakingForces = new ForceTorqueVector[this.numStokes];
        this.throttlingForces = new ForceTorqueVector[this.numStokes];
        this.originParticle = this.wheelCenter = this.addParticle(vector3d, this.centerWeight);
        if ((d -= this.centerWeight) < 0.0) {
            d = 0.1;
        }
        this.mass = d + this.centerWeight;
        for (n = 0; n < this.numStokes; ++n) {
            double d2 = Math.PI * 2 / (double)this.numStokes * (double)n;
            double d3 = this.radius * Math.cos(d2) + this.wheelCenter.getPosition().x;
            double d4 = this.radius * Math.sin(d2) + this.wheelCenter.getPosition().y;
            double d5 = this.wheelCenter.getPosition().z;
            this.stokes[n] = this.addParticle(d3, d4, d5, d / (double)this.numStokes);
            if (n == 0) {
                this.stokes[0] = this.stokes[n];
            } else {
                constraintStick = new ConstraintStick(this.stokes[n - 1], this.stokes[n]);
                this.addConstraint(constraintStick);
                constraintDamper = new ConstraintDamper(this.stokes[n - 1], this.stokes[n]);
                constraintDamper.setStiffness(this.rimDamp);
                this.addConstraint(constraintDamper);
                if (n == this.numStokes - 1) {
                    constraintStick = new ConstraintStick(this.stokes[n], this.stokes[0]);
                    this.addConstraint(constraintStick);
                    constraintDamper = new ConstraintDamper(this.stokes[n], this.stokes[0]);
                    constraintDamper.setStiffness(this.rimDamp);
                    this.addConstraint(constraintDamper);
                }
            }
            ConstraintSpring constraintSpring = this.addConstraint(this.wheelCenter, this.stokes[n], this.stokeStiffness);
            if (bl) {
                this.throttlingForces[n] = new ForceTorqueVector();
                this.throttlingForces[n].init(this.stokes[n], this.wheelCenter, this.planeNormal, 0.0);
                this.addForce(this.throttlingForces[n]);
            }
            this.brakingForces[n] = new ForceTorqueVector();
            this.brakingForces[n].init(this.stokes[n], this.wheelCenter, this.planeNormal, 0.0);
            this.addForce(this.brakingForces[n]);
        }
        for (int i = 0; i < this.numStokes; ++i) {
            n = i + this.reinforcement;
            if (n >= this.numStokes) {
                n -= this.numStokes;
            }
            constraintStick = new ConstraintStick(this.stokes[i], this.stokes[n]);
            this.addConstraint(constraintStick);
            constraintDamper = new ConstraintDamper(this.stokes[i], this.stokes[n]);
            constraintDamper.setStiffness(this.rimDamp);
            this.addConstraint(constraintDamper);
        }
        this.frameParticles[0] = this.stokes[10];
        this.frameParticles[1] = this.wheelCenter;
        this.frameParticles[2] = this.stokes[0];
    }

    public void crash(double d) {
        this.setDamp(d);
    }

    public void reset() {
        this.setDamp(this.initialDamp);
    }

    public void setThrottleAmount(double d) {
        if (this.chaindrive) {
            this.throttleAmount = d;
            for (ForceTorqueVector forceTorqueVector : this.throttlingForces) {
                forceTorqueVector.setMagnitude(d * (double)0.4f);
            }
        } else {
            this.throttleAmount = 0.0;
            for (ForceTorqueVector forceTorqueVector : this.throttlingForces) {
                forceTorqueVector.setMagnitude(d * (double)0.53f);
            }
        }
    }

    private void applyThrottling() {
        temp1.set(this.wheelCenter.position).subtractLocal(this.throttleParticle.position);
        double d = temp1.length();
        for (int i = 0; i < this.throttleSprings.length; ++i) {
            temp1.set(this.stokes[i].position).subtractLocal(this.throttleParticle.position);
            temp2.set(this.wheelCenter.position).subtractLocal(this.throttleParticle.position);
            temp1.crossLocal(temp2);
            if (BikeWheel.temp1.z < 0.0) {
                this.throttleSprings[i].setRestLength(d * 0.5);
            } else {
                this.throttleSprings[i].setRestLength(d * 2.0);
            }
            this.throttleSprings[i].setStiffness(this.throttleAmount / 380.0 * BikeWheel.temp1.z * BikeWheel.temp1.z);
            this.throttleSprings[i].setActive(true);
        }
    }

    private void applyBraking() {
        for (int i = 0; i < this.throttleSprings.length; ++i) {
            temp1.set(this.stokes[i].position).subtractLocal(this.throttleParticle.position);
            this.throttleSprings[i].setRestLength(temp1.length());
            this.throttleSprings[i].setStiffness(Math.abs(this.brakeAmount) * 1.5);
            this.throttleSprings[i].setActive(true);
        }
    }

    public void applyForces() {
        super.applyForces();
        if (this.throttleSprings != null) {
            if (this.throttleAmount < -0.01 || this.throttleAmount > 0.01) {
                this.applyThrottling();
            } else if (this.brakeAmount < -0.01 || this.brakeAmount > 0.01) {
                this.applyBraking();
            } else {
                int n = 0;
                while (n < this.throttleSprings.length) {
                    this.throttleSprings[n++].setActive(false);
                }
            }
        }
        this.setThrottleAmount(0.0);
        if (!this.isPermaBrake()) {
            this.setBrakeAmount(0.0);
        }
    }

    public void setBrakeAmount(double d) {
        this.brakeAmount = d;
        this.setPermaBreak(false);
    }

    public Matrix4d updateCoordinateFrame() {
        Matrix4d matrix4d = super.updateCoordinateFrame();
        this.angularVelocity = this.updateAngularVelocity();
        return matrix4d;
    }

    public double updateAngularVelocity() {
        this.yAxis.set(this.frame.m10, this.frame.m11, 0.0);
        this.yAxisPrev.set(this.previousFrame.m10, this.previousFrame.m11, 0.0);
        this.yAxis.subtract(this.yAxisPrev, this.tempAngularVelocity);
        this.yAxis.cross(this.yAxisPrev, this.dir);
        return Math.signum(this.dir.z) * this.tempAngularVelocity.length();
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public double getAngularVelocity(double d) {
        return this.angularVelocity / d;
    }

    public Particle getWheelCenter() {
        return this.wheelCenter;
    }

    public void setWheelCenter(Particle particle) {
        this.wheelCenter = particle;
    }

    public ForceTorqueVector[] getBreakingForces() {
        return this.brakingForces;
    }

    public ForceTorqueVector[] getThrottlingForces() {
        return this.throttlingForces;
    }

    public Vector3d getCenterOfMass(Vector3d vector3d) {
        return vector3d != null ? vector3d.set(this.wheelCenter.position) : new Vector3d(this.wheelCenter.position);
    }

    public double getMass() {
        return this.mass;
    }

    public void setThrottleParticle(Particle particle) {
        this.throttleParticle = particle;
        this.throttleSprings = new ConstraintSpring[this.numStokes];
        for (int i = 0; i < this.stokes.length; ++i) {
            this.throttleSprings[i] = new ConstraintSpring(this.stokes[i], particle, 0.0);
            this.addConstraint(this.throttleSprings[i]);
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isChaindrive() {
        return this.chaindrive;
    }

    public void setChaindrive(boolean bl) {
        this.chaindrive = bl;
    }

    public boolean isPermaBrake() {
        return this.permaBrake;
    }

    public void setPermaBreak(boolean bl) {
        if (bl) {
            this.setBrakeAmount(this.permaBrakeAmount);
        }
        this.permaBrake = bl;
    }
}

