/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.objects;

import com.jme.renderer.ColorRGBA;
import com.turborilla.msm.physics.ConstraintDetectWrongBend;
import com.turborilla.msm.physics.objects.BikeFrame;
import com.turborilla.physics.particle.Constraint180;
import com.turborilla.physics.particle.ConstraintDamper;
import com.turborilla.physics.particle.ConstraintPushingSpring;
import com.turborilla.physics.particle.ConstraintPushingSpringDamped;
import com.turborilla.physics.particle.ConstraintPushingStick;
import com.turborilla.physics.particle.ConstraintSpring;
import com.turborilla.physics.particle.ConstraintSpringDamped;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.utils.math.Vector3d;
import java.util.ArrayList;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BikeRider
extends ParticleObject {
    protected Particle rightHand;
    protected Particle leftHand;
    protected Particle rightElbow;
    protected Particle leftElbow;
    protected Particle shoulder;
    protected Particle ass;
    protected Particle rightKnee;
    protected Particle leftKnee;
    protected Particle rightFoot;
    protected Particle leftFoot;
    protected double[] relativeWeights = new double[]{0.5, 0.5, 1.5, 1.5, 21.0, 10.0, 3.0, 3.0, 1.0, 1.0};
    protected BikeFrame frame;
    protected ArrayList<IConstraint> deactivateOnCrash;
    protected IConstraint keepActiveOnViolentSpinning;
    protected ArrayList<IConstraint> activateOnCrash;
    protected ArrayList<ConstraintStick> footRestHolders;
    protected ArrayList<ConstraintStick> handHolders;
    protected ArrayList<ConstraintDetectWrongBend> boneBreakTriggers;
    protected ConstraintPushingSpringDamped bailOutPusher;
    private Vector3d centerOfMass;
    private double mass;
    private double initialDamp;
    private boolean crashing = false;
    private boolean violentSpinning = false;
    private double[][][] benderKeyFrames = new double[][][]{new double[][]{{1.85f, 1.18f, 2.37f, 2.5, 2.5, 2.63f}, {1.85f, 3.21f, 1.96f, 2.87f, 2.5, 2.93f}}, new double[][]{{1.84f, 0.95f, 2.16f, 2.07f, 2.07f, 2.6f}, {1.84f, 0.93f, 2.16f, 2.07f, 2.07f, 3.13f}}, new double[][]{{1.69f, 1.0, 1.86f, 1.45f, 1.45f, 2.41f}, {1.97f, 1.49f, 1.57f, 2.1f, 2.1f, 3.03f}}, new double[][]{{1.37f, 0.97f, 1.29f, 1.45f, 1.45f, 2.07f}, {1.97f, 1.49f, 1.24f, 1.95f, 1.95f, 3.14f}}, new double[][]{{1.55f, 0.99f, 0.79f, 1.5, 1.25, 2.14f}, {1.92f, 1.39f, 0.59f, 1.42f, 1.42f, 2.88f}}, new double[][]{{2.73f, 1.06f, 0.47f, 1.5, 1.78f, 2.36f}, {1.96f, 1.33f, 0.3f, 1.5, 1.5, 2.64f}}};
    protected final int numberOfBenders = this.benderKeyFrames[0][0].length;
    protected ConstraintSpring[] benders = new ConstraintSpring[this.numberOfBenders];
    protected double[] centers = new double[this.numberOfBenders];
    private double[][] benderKeyPositions = new double[][]{{-0.7f, -0.5, -0.3f, 0.0, 0.15f, 0.5}, {-0.2f, 0.2f}};
    private int numberOfKeyframesX = this.benderKeyPositions[0].length;
    private int numberOfKeyframesY = this.benderKeyPositions[1].length;
    private ConstraintStick leftThigh;
    private ConstraintStick leftCalf;
    private ConstraintStick torso;
    private ConstraintStick leftUpperArm;
    private ConstraintStick leftLowerArm;
    private ConstraintStick rightThigh;
    private ConstraintStick rightCalf;
    private ConstraintStick rightUpperArm;
    private ConstraintStick rightLowerArm;
    private int curBender = 0;
    private boolean debug = false;
    private int debugKeyframeX = this.numberOfKeyframesX;
    private int debugKeyframeY = this.numberOfKeyframesY;
    private int debugKeyframeAdder = 1;

    public BikeRider(Vector3d vector3d, double d, BikeFrame bikeFrame, double d2, double d3) {
        super("Rider");
        this.deactivateOnCrash = new ArrayList();
        this.activateOnCrash = new ArrayList();
        this.footRestHolders = new ArrayList();
        this.handHolders = new ArrayList();
        this.init(vector3d, d, bikeFrame, d2, d3);
        this.centerOfMass = this.getCenterOfMass(null);
        this.initialDamp = this.getDamp();
    }

    private void init(Vector3d vector3d, double d, BikeFrame bikeFrame, double d2, double d3) {
        double d42;
        this.mass = d;
        double d5 = 0.0;
        for (double d42 : this.relativeWeights) {
            d5 += d42;
        }
        this.frame = bikeFrame;
        this.rightHand = this.addParticle(bikeFrame.getHandlebar().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[0] / d5);
        this.leftHand = this.addParticle(bikeFrame.getHandlebar().position.add((double)0.1f * d2, (double)0.1f * d3, 0.0), d * this.relativeWeights[1] / d5);
        this.rightElbow = this.addParticle(vector3d.x + 82.0 * d2, vector3d.y + 105.0 * d3, vector3d.z, d * this.relativeWeights[2] / d5);
        this.leftElbow = this.addParticle(vector3d.x + 82.0 * d2, vector3d.y + 105.0 * d3, vector3d.z, d * this.relativeWeights[3] / d5);
        this.shoulder = this.addParticle(vector3d.x + 66.0 * d2, vector3d.y + 125.0 * d3, vector3d.z, d * this.relativeWeights[4] / d5);
        this.ass = this.addParticle(vector3d.x + 37.0 * d2, vector3d.y + 86.0 * d3, vector3d.z, d * this.relativeWeights[5] / d5);
        this.rightKnee = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 66.0 * d3, vector3d.z, d * this.relativeWeights[6] / d5);
        this.leftKnee = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 66.0 * d3, vector3d.z, d * this.relativeWeights[7] / d5);
        this.rightFoot = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 38.0 * d3, vector3d.z, d * this.relativeWeights[8] / d5);
        this.leftFoot = this.addParticle(vector3d.x + 64.0 * d2, vector3d.y + 38.0 * d3, vector3d.z, d * this.relativeWeights[9] / d5);
        Callable callable = new Callable(){

            public Object call() {
                BikeRider.this.crash(BikeRider.this.getDamp());
                return null;
            }
        };
        Constraint180 constraint180 = new Constraint180(this.leftFoot, this.leftKnee, this.ass);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        constraint180 = new Constraint180(this.rightFoot, this.rightKnee, this.ass);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        constraint180 = new Constraint180(this.shoulder, this.ass, this.rightKnee);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        constraint180 = new Constraint180(this.shoulder, this.ass, this.leftKnee);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        Object object = new ConstraintSpring(this.rightHand, bikeFrame.getHandlebar());
        this.addConstraint((IConstraint)object);
        this.deactivateOnCrash.add((IConstraint)object);
        this.keepActiveOnViolentSpinning = object;
        this.handHolders.add((ConstraintStick)object);
        object = new ConstraintSpring(this.rightFoot, bikeFrame.getFootrest());
        ((ConstraintStick)object).setRestLength(0.0);
        this.addConstraint((IConstraint)object);
        this.deactivateOnCrash.add((IConstraint)object);
        this.footRestHolders.add((ConstraintStick)object);
        object = new ConstraintSpring(this.leftHand, bikeFrame.getHandlebar());
        this.addConstraint((IConstraint)object);
        this.deactivateOnCrash.add((IConstraint)object);
        this.handHolders.add((ConstraintStick)object);
        object = new ConstraintSpring(this.leftFoot, bikeFrame.getFootrest());
        ((ConstraintStick)object).setRestLength(0.0);
        this.addConstraint((IConstraint)object);
        this.deactivateOnCrash.add((IConstraint)object);
        this.footRestHolders.add((ConstraintStick)object);
        d42 = 8.75 * d;
        double d6 = 4.0 * d;
        this.bailOutPusher = new ConstraintPushingSpringDamped(this.ass, bikeFrame.getFootrest(), d6);
        this.bailOutPusher.setRestLength(this.bailOutPusher.getRestLength() * 1.5);
        this.bailOutPusher.setActive(false);
        this.bailOutPusher.setStiffness(d42 * (double)0.1f);
        this.addConstraint(this.bailOutPusher);
        object = new ConstraintStick(this.rightHand, this.rightElbow);
        this.addConstraint((IConstraint)object);
        this.rightLowerArm = object;
        ((ConstraintStick)object).setName("RightLowerArm");
        object = new ConstraintStick(this.rightElbow, this.shoulder);
        this.addConstraint((IConstraint)object);
        this.rightUpperArm = object;
        ((ConstraintStick)object).setName("RightUpperArm");
        object = new ConstraintStick(this.leftHand, this.leftElbow);
        this.addConstraint((IConstraint)object);
        this.leftLowerArm = object;
        ((ConstraintStick)object).setName("LeftLowerArm");
        object = new ConstraintStick(this.leftElbow, this.shoulder);
        this.addConstraint((IConstraint)object);
        this.leftUpperArm = object;
        ((ConstraintStick)object).setName("LeftUpperArm");
        object = new ConstraintStick(this.ass, this.shoulder);
        this.addConstraint((IConstraint)object);
        this.torso = object;
        ((ConstraintStick)object).setName("Torso");
        object = new ConstraintStick(this.rightKnee, this.ass);
        this.addConstraint((IConstraint)object);
        this.rightThigh = object;
        ((ConstraintStick)object).setName("RightThigh");
        object = new ConstraintStick(this.rightFoot, this.rightKnee);
        this.addConstraint((IConstraint)object);
        this.rightCalf = object;
        ((ConstraintStick)object).setName("RightCalf");
        object = new ConstraintStick(this.leftKnee, this.ass);
        this.addConstraint((IConstraint)object);
        this.leftThigh = object;
        ((ConstraintStick)object).setName("LeftThigh");
        object = new ConstraintStick(this.leftFoot, this.leftKnee);
        this.addConstraint((IConstraint)object);
        this.leftCalf = object;
        ((ConstraintStick)object).setName("LeftCalf");
        d42 = 8.75 * d;
        ConstraintPushingSpringDamped constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.ass, bikeFrame.getRearAxle(), d6);
        constraintPushingSpringDamped.setRestLength(51.0 * d2 * (double)0.6f);
        constraintPushingSpringDamped.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpringDamped);
        this.deactivateOnCrash.add(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setDebugColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, bikeFrame.getFootrest(), d6);
        constraintPushingSpringDamped.setRestLength(constraintPushingSpringDamped.getRestLength() * (double)0.7f);
        constraintPushingSpringDamped.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpringDamped);
        this.deactivateOnCrash.add(constraintPushingSpringDamped);
        ConstraintPushingSpring constraintPushingSpring = new ConstraintPushingSpring(this.ass, bikeFrame.getFork());
        constraintPushingSpring.setRestLength(56.66666793823242 * d2);
        constraintPushingSpring.setStiffness(10.0 * d);
        this.addConstraint(constraintPushingSpring);
        this.deactivateOnCrash.add(constraintPushingSpring);
        constraintPushingSpring.setDebugColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        constraint180 = new Constraint180(this.shoulder, this.rightElbow, this.rightHand);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        constraint180 = new Constraint180(this.shoulder, this.leftElbow, this.leftHand);
        this.addConstraint(constraint180);
        this.deactivateOnCrash.add(constraint180);
        ConstraintPushingStick constraintPushingStick = new ConstraintPushingStick(this.shoulder, this.rightHand);
        constraintPushingStick.setRestLength(constraintPushingStick.getRestLength() * (double)0.2f);
        this.addConstraint(constraintPushingStick);
        constraintPushingStick = new ConstraintPushingStick(this.shoulder, this.leftHand);
        constraintPushingStick.setRestLength(constraintPushingStick.getRestLength() * (double)0.2f);
        this.addConstraint(constraintPushingStick);
        d42 = 0.375 * d;
        ConstraintSpringDamped constraintSpringDamped = new ConstraintSpringDamped(this.rightFoot, this.ass, d6);
        constraintSpringDamped.setStiffness(d42);
        this.addConstraint(constraintSpringDamped);
        this.benders[0] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        constraintSpringDamped = new ConstraintSpringDamped(this.rightHand, this.shoulder, d6);
        constraintSpringDamped.setStiffness(d42);
        this.addConstraint(constraintSpringDamped);
        this.benders[1] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintSpringDamped(this.rightHand, this.ass, d6);
        constraintSpringDamped.setStiffness(d42);
        this.addConstraint(constraintSpringDamped);
        this.benders[2] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintSpringDamped(this.rightKnee, bikeFrame.getFork(), d6);
        constraintSpringDamped.setStiffness(d42 * (double)0.1f);
        this.addConstraint(constraintSpringDamped);
        this.benders[3] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintSpringDamped(this.leftKnee, bikeFrame.getFork(), d6);
        constraintSpringDamped.setStiffness(d42 * (double)0.1f);
        this.addConstraint(constraintSpringDamped);
        this.benders[4] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, bikeFrame.getFork(), d6 * 1.5);
        constraintSpringDamped.setStiffness(d42 * (double)0.15f);
        this.addConstraint(constraintSpringDamped);
        this.benders[5] = constraintSpringDamped;
        this.deactivateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped.setDebugColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        int n = 0;
        for (ConstraintSpring constraintSpring : this.benders) {
            this.centers[n] = constraintSpring != null ? constraintSpring.getRestLength() : -1.0;
            ++n;
        }
        for (ConstraintSpring constraintSpring : (Object)this.benderKeyFrames) {
            for (int i = 0; i < ((ConstraintSpring)constraintSpring).length; ++i) {
                int n2 = 0;
                while (n2 < ((ConstraintSpring)constraintSpring[i]).length) {
                    ConstraintSpring constraintSpring2 = constraintSpring[i];
                    int n3 = n2++;
                    constraintSpring2[n3] = constraintSpring2[n3] * (d2 / (double)0.03f);
                }
            }
        }
        d42 = (double)0.00125f * d;
        d6 = 2.0 * d;
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.rightKnee, d6);
        constraintSpringDamped.setStiffness(d42);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * 4.0);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, this.rightKnee, d6);
        constraintSpringDamped.setStiffness(d42 * 10.0);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * 0.5);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintSpringDamped(this.ass, this.rightFoot, d6);
        constraintSpringDamped.setStiffness(d42);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)2.2f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, this.rightHand, d6 * (double)0.3f);
        constraintPushingSpringDamped.setStiffness(d42 * 5.0);
        constraintPushingSpringDamped.setRestLength(this.rightLowerArm.getRestLength() * 2.0);
        this.addConstraint(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintPushingSpringDamped);
        Object object2 = new ConstraintDamper(this.ass, this.rightElbow);
        ((ConstraintDamper)object2).setStiffness((double)0.09f * d);
        this.addConstraint((IConstraint)object2);
        ((ConstraintDamper)object2).setActive(false);
        this.activateOnCrash.add((IConstraint)object2);
        object2 = new ConstraintDamper(this.shoulder, this.rightHand);
        ((ConstraintDamper)object2).setStiffness((double)0.04f * d);
        this.addConstraint((IConstraint)object2);
        ((ConstraintDamper)object2).setActive(false);
        this.activateOnCrash.add((IConstraint)object2);
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.leftKnee, d6);
        constraintSpringDamped.setStiffness(d42 * 0.5);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)3.8f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintSpringDamped(this.ass, this.leftFoot, d6);
        constraintSpringDamped.setStiffness(d42);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * (double)2.6f);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintPushingSpringDamped = new ConstraintPushingSpringDamped(this.shoulder, this.leftHand, d6 * (double)0.3f);
        constraintPushingSpringDamped.setStiffness(d42);
        constraintPushingSpringDamped.setRestLength(this.leftLowerArm.getRestLength() * 2.0);
        this.addConstraint(constraintPushingSpringDamped);
        constraintPushingSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintPushingSpringDamped);
        object2 = new ConstraintDamper(this.ass, this.leftElbow);
        ((ConstraintDamper)object2).setStiffness((double)0.02f * d);
        this.addConstraint((IConstraint)object2);
        ((ConstraintDamper)object2).setActive(false);
        this.activateOnCrash.add((IConstraint)object2);
        object2 = new ConstraintDamper(this.shoulder, this.leftHand);
        ((ConstraintDamper)object2).setStiffness((double)0.04f * d);
        this.addConstraint((IConstraint)object2);
        ((ConstraintDamper)object2).setActive(false);
        this.activateOnCrash.add((IConstraint)object2);
        this.boneBreakTriggers = new ArrayList();
        ConstraintDetectWrongBend constraintDetectWrongBend = new ConstraintDetectWrongBend(this.leftFoot, this.leftKnee, this.ass);
        this.addConstraint(constraintDetectWrongBend);
        constraintDetectWrongBend.setActive(false);
        this.activateOnCrash.add(constraintDetectWrongBend);
        this.boneBreakTriggers.add(constraintDetectWrongBend);
        constraintDetectWrongBend = new ConstraintDetectWrongBend(this.rightFoot, this.rightKnee, this.ass);
        this.addConstraint(constraintDetectWrongBend);
        constraintDetectWrongBend.setActive(false);
        this.activateOnCrash.add(constraintDetectWrongBend);
        this.boneBreakTriggers.add(constraintDetectWrongBend);
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.leftKnee, d6);
        constraintSpringDamped.setStiffness(d42 * 2.0);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * 0.5);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
        constraintSpringDamped = new ConstraintSpringDamped(this.shoulder, this.rightKnee, d6);
        constraintSpringDamped.setStiffness(d42 * 2.1);
        constraintSpringDamped.setRestLength(constraintSpringDamped.getRestLength() * 0.5);
        this.addConstraint(constraintSpringDamped);
        constraintSpringDamped.setActive(false);
        this.activateOnCrash.add(constraintSpringDamped);
    }

    public void debugPrintBenders() {
        for (int i = 0; i < this.benders.length; ++i) {
            if (this.benders[i] == null) continue;
            System.out.println("" + i + ": " + this.benders[i].getRestLength());
        }
        System.out.println(this.frame.getFork().position.x);
        System.out.println("-------------------");
    }

    public void changeBender() {
        if (this.benders[this.curBender] != null) {
            this.benders[this.curBender].getDebugColor().set(1.0f, 0.0f, 0.0f, 1.0f);
        }
        ++this.curBender;
        if (this.curBender >= this.numberOfBenders) {
            this.curBender = 0;
        }
        if (this.benders[this.curBender] != null) {
            this.benders[this.curBender].getDebugColor().set(0.0f, 0.0f, 1.0f, 1.0f);
        }
        System.out.println("curBender: " + this.curBender);
    }

    public void addBenderLength(double d) {
        ConstraintSpring constraintSpring = this.benders[this.curBender];
        if (constraintSpring != null) {
            constraintSpring.setRestLength(constraintSpring.getRestLength() + d);
        }
    }

    public void toggleDebug() {
        this.debug = !this.debug;
        System.out.println("debug is " + (this.debug ? "on" : "off"));
    }

    public void switchKeyframe() {
        if (!this.debug) {
            return;
        }
        this.debugKeyframeX += this.debugKeyframeAdder;
        if (this.debugKeyframeX >= this.numberOfKeyframesX) {
            this.debugKeyframeX = this.numberOfKeyframesX - 1;
            this.debugKeyframeAdder = -1;
            int n = this.debugKeyframeY = this.debugKeyframeY == 0 ? 1 : 0;
        }
        if (this.debugKeyframeX < 0) {
            this.debugKeyframeX = 0;
            this.debugKeyframeAdder = 1;
            this.debugKeyframeY = this.debugKeyframeY == 0 ? 1 : 0;
        }
        double[] dArray = new double[]{this.benderKeyPositions[0][this.debugKeyframeX], this.benderKeyPositions[1][this.debugKeyframeY]};
        this.debug = false;
        this.lean(dArray);
        this.debug = true;
        System.out.println("debugKeyframeX: " + this.debugKeyframeX);
        System.out.println("debugKeyframeY: " + this.debugKeyframeY);
    }

    public void crash(double d) {
        int n;
        this.crashing = true;
        for (n = 0; n < this.deactivateOnCrash.size(); ++n) {
            this.deactivateOnCrash.get(n).setActive(false);
        }
        for (n = 0; n < this.activateOnCrash.size(); ++n) {
            this.activateOnCrash.get(n).setActive(true);
        }
        this.bailOutPusher.setActive(false);
        this.setDamp(d);
        this.setLockedZ(false);
    }

    public void releaseFeet() {
        int n;
        for (n = 0; n < this.deactivateOnCrash.size(); ++n) {
            this.deactivateOnCrash.get(n).setActive(false);
        }
        for (n = 0; n < this.activateOnCrash.size(); ++n) {
            this.activateOnCrash.get(n).setActive(true);
        }
        this.bailOutPusher.setActive(true);
    }

    public void onViolentSpinning() {
        int n;
        this.violentSpinning = true;
        for (n = 0; n < this.deactivateOnCrash.size(); ++n) {
            if (this.deactivateOnCrash.get(n) == this.keepActiveOnViolentSpinning) continue;
            this.deactivateOnCrash.get(n).setActive(false);
        }
        for (n = 0; n < this.activateOnCrash.size(); ++n) {
            this.activateOnCrash.get(n).setActive(true);
        }
    }

    public void reset() {
        int n;
        this.crashing = false;
        for (n = 0; n < this.deactivateOnCrash.size(); ++n) {
            this.deactivateOnCrash.get(n).setActive(true);
        }
        for (n = 0; n < this.footRestHolders.size(); ++n) {
            this.footRestHolders.get(n).setRestLength(0.0);
        }
        for (n = 0; n < this.activateOnCrash.size(); ++n) {
            this.activateOnCrash.get(n).setActive(false);
        }
        this.bailOutPusher.setActive(false);
        this.setDamp(this.initialDamp);
        this.setLockedZ(true);
    }

    public void lean(double[] dArray) {
        if (this.debug) {
            return;
        }
        int[] nArray = new int[dArray.length];
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        double[] dArray4 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = 0;
            for (double d : this.benderKeyPositions[i]) {
                if (dArray[i] < d) break;
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            int n = i;
            nArray[n] = nArray[n] - 1;
            if (nArray[i] > this.benderKeyPositions[i].length - 2) {
                nArray[i] = this.benderKeyPositions[i].length - 2;
            }
            dArray2[i] = this.benderKeyPositions[i][nArray[i]];
            dArray3[i] = this.benderKeyPositions[i][nArray[i] + 1];
            dArray4[i] = (dArray[i] - dArray2[i]) / (dArray3[i] - dArray2[i]);
        }
        double[][] dArray5 = new double[dArray.length][this.numberOfBenders];
        double[][] dArray6 = new double[dArray.length][this.numberOfBenders];
        dArray5[0] = this.benderKeyFrames[nArray[0]][nArray[1]];
        dArray5[1] = this.benderKeyFrames[nArray[0]][nArray[1] + 1];
        dArray6[0] = this.benderKeyFrames[nArray[0] + 1][nArray[1]];
        dArray6[1] = this.benderKeyFrames[nArray[0] + 1][nArray[1] + 1];
        for (int i = 0; i < this.numberOfBenders; ++i) {
            ConstraintSpring constraintSpring = this.benders[i];
            double d = dArray5[0][i] + (dArray6[0][i] - dArray5[0][i]) * dArray4[0];
            double d2 = dArray5[1][i] + (dArray6[1][i] - dArray5[1][i]) * dArray4[0];
            double d3 = d + (d2 - d) * dArray4[1];
            constraintSpring.setRestLength(d3);
        }
    }

    public double lerp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public double cosLerp(double d, double d2, double d3) {
        double d4 = (1.0 - Math.cos(d3 * Math.PI)) * 0.5;
        return d * (1.0 - d4) + d2 * d4;
    }

    public void lean(double d) {
        if (this.debug) {
            return;
        }
        int n = 0;
        for (double d2 : this.benderKeyPositions[0]) {
            if (d < d2) break;
            ++n;
        }
        if (--n > this.benderKeyPositions[0].length - 2) {
            n = this.benderKeyPositions[0].length - 2;
        }
        double d3 = this.benderKeyPositions[0][n];
        double d4 = this.benderKeyPositions[0][n + 1];
        double d5 = (d - d3) / (d4 - d3);
        int n2 = 0;
        double[] dArray = this.benderKeyFrames[n][0];
        double[] dArray2 = this.benderKeyFrames[n + 1][0];
        for (ConstraintSpring constraintSpring : this.benders) {
            constraintSpring.setRestLength(dArray[n2] + (dArray2[n2] - dArray[n2]) * d5);
            ++n2;
        }
    }

    public void lean(double d, int n) {
        if (this.benders[n] == null) {
            return;
        }
        this.benders[n].setRestLength(this.centers[n] + d);
        int n2 = 0;
        System.out.println();
        for (ConstraintSpring constraintSpring : this.benders) {
            System.out.println("bender[" + n2 + "] = " + (constraintSpring == null ? "null" : Double.valueOf(constraintSpring.getCurrentLength())));
            ++n2;
        }
    }

    @Override
    public Vector3d getLocalTranslation() {
        return this.getCenterOfMass(this.centerOfMass);
    }

    @Override
    public Vector3d getWorldTranslation() {
        return this.getLocalTranslation();
    }

    public Particle getAss() {
        return this.ass;
    }

    public void setAss(Particle particle) {
        this.ass = particle;
    }

    public Particle getRightElbow() {
        return this.rightElbow;
    }

    public void setRightElbow(Particle particle) {
        this.rightElbow = particle;
    }

    public Particle getRightFoot() {
        return this.rightFoot;
    }

    public void setRightFoot(Particle particle) {
        this.rightFoot = particle;
    }

    public Particle getRightHand() {
        return this.rightHand;
    }

    public void setRightHand(Particle particle) {
        this.rightHand = particle;
    }

    public Particle getRightKnee() {
        return this.rightKnee;
    }

    public void setRightKnee(Particle particle) {
        this.rightKnee = particle;
    }

    public Particle getShoulder() {
        return this.shoulder;
    }

    public void setShoulder(Particle particle) {
        this.shoulder = particle;
    }

    public ConstraintStick getLeftCalf() {
        return this.leftCalf;
    }

    public ConstraintStick getLeftThigh() {
        return this.leftThigh;
    }

    public ConstraintStick getLeftLowerArm() {
        return this.leftLowerArm;
    }

    public ConstraintStick getTorso() {
        return this.torso;
    }

    public ConstraintStick getLeftUpperArm() {
        return this.leftUpperArm;
    }

    public ConstraintStick getRightCalf() {
        return this.rightCalf;
    }

    public ConstraintStick getRightLowerArm() {
        return this.rightLowerArm;
    }

    public ConstraintStick getRightThigh() {
        return this.rightThigh;
    }

    public ConstraintStick getRightUpperArm() {
        return this.rightUpperArm;
    }

    public Particle getLeftElbow() {
        return this.leftElbow;
    }

    public Particle getLeftFoot() {
        return this.leftFoot;
    }

    public Particle getLeftHand() {
        return this.leftHand;
    }

    public Particle getLeftKnee() {
        return this.leftKnee;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    public void addColliderCircle(Particle particle, double d) {
        double d2 = 0.01;
        Vector3d vector3d = particle.position;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.set(vector3d).addLocal(0.0, d, 0.0);
        Particle particle2 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(d, 0.0, 0.0);
        Particle particle3 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(0.0, -d, 0.0);
        Particle particle4 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(-d, 0.0, 0.0);
        Particle particle5 = new Particle(vector3d2, d2);
        this.addParticle(particle2);
        this.addParticle(particle3);
        this.addParticle(particle4);
        this.addParticle(particle5);
        this.mass += d2 * 4.0;
        ConstraintStick constraintStick = new ConstraintStick(particle, particle2);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle3);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle4);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle5);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle2, particle3);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle3, particle4);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle4, particle5);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle5, particle2);
        this.addConstraint(constraintStick);
    }

    public void addColliderCircle(Particle particle, double d, Particle particle2) {
        double d2 = 0.01;
        Vector3d vector3d = particle.position;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.set(vector3d).addLocal(0.0, d, 0.0);
        Particle particle3 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(d, 0.0, 0.0);
        Particle particle4 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(0.0, -d, 0.0);
        Particle particle5 = new Particle(vector3d2, d2);
        vector3d2.set(vector3d).addLocal(-d, 0.0, 0.0);
        Particle particle6 = new Particle(vector3d2, d2);
        this.addParticle(particle3);
        this.addParticle(particle4);
        this.addParticle(particle5);
        this.addParticle(particle6);
        this.mass += d2 * 4.0;
        ConstraintStick constraintStick = new ConstraintStick(particle, particle3);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle4);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle5);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle, particle6);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle2, particle3);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle2, particle4);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle2, particle5);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle2, particle6);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle3, particle4);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle4, particle5);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle5, particle6);
        this.addConstraint(constraintStick);
        constraintStick = new ConstraintStick(particle6, particle3);
        this.addConstraint(constraintStick);
    }

    public ArrayList<ConstraintDetectWrongBend> getBoneBreakTriggers() {
        return this.boneBreakTriggers;
    }
}

