/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics.collision;

import com.jme.image.Texture;
import com.turborilla.physics.particle.ParticleObjectEffect;
import com.turborilla.utils.math.Vector3d;

public class ParticleObjectEffectCollisionSpray
extends ParticleObjectEffect {
    double numberToEmit = 0.0;
    private int maxSavedCollisions = 10;
    private Collision[] savedCollisions = new Collision[this.maxSavedCollisions];
    private int savedThisFrame = 0;

    public ParticleObjectEffectCollisionSpray(int n, Texture texture) {
        super("CollisionSpray", n, texture);
        this.setDirectionRandomizer(1.0);
        this.setEmitting(false);
        for (int i = 0; i < this.maxSavedCollisions; ++i) {
            Collision collision = new Collision();
            collision.base = new Vector3d();
            collision.towards = new Vector3d();
            collision.speed = 0.0;
            this.savedCollisions[i] = collision;
        }
    }

    public ParticleObjectEffectCollisionSpray(int n, Texture texture, int n2) {
        this(n, texture);
        this.maxSavedCollisions = n2;
    }

    public void collided(Vector3d vector3d, Vector3d vector3d2, double d) {
        if (this.savedThisFrame < this.maxSavedCollisions) {
            Collision collision = this.savedCollisions[this.savedThisFrame];
            collision.base.set(vector3d);
            collision.towards.set(vector3d2);
            collision.speed = d * 0.5;
            ++this.savedThisFrame;
        }
    }

    public void integrate(double d) {
        for (int i = 0; i < this.savedThisFrame; ++i) {
            Collision collision = this.savedCollisions[i];
            this.setEmitterBase(collision.base);
            this.setEmitterTowards(collision.towards);
            this.setInitialSpeed(collision.speed);
            double d2 = d / 10.0;
            this.numberToEmit += d2 / this.emitInterval * collision.speed * 10.0;
            int n = (int)this.numberToEmit;
            this.numberToEmit -= (double)n;
            this.emit(n, d2);
        }
        this.savedThisFrame = 0;
        super.integrate(d);
    }

    public Collision[] getSavedCollisions() {
        return this.savedCollisions;
    }

    public int getSavedThisFrame() {
        return this.savedThisFrame;
    }

    public int getMaxSavedCollisions() {
        return this.maxSavedCollisions;
    }

    public void setSavedThisFrame(int n) {
        this.savedThisFrame = n >= this.maxSavedCollisions ? this.maxSavedCollisions : n;
    }

    public class Collision {
        public Vector3d base;
        public Vector3d towards;
        public double speed;
    }
}

