/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.physics;

import com.turborilla.physics.particle.IConstraint;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class ConstraintDetectWrongBend
implements IConstraint {
    private Particle part1;
    private Particle middle;
    private Particle part2;
    private double threshold;
    private Callable callOnViolation;
    private double violationAmount;
    private static Vector3d part1part2 = new Vector3d();
    private static Vector3d part1middle = new Vector3d();
    private static Vector3d perp = new Vector3d();
    private boolean active = true;

    public ConstraintDetectWrongBend(Particle particle, Particle particle2, Particle particle3) {
        this(particle, particle2, particle3, -1.0, null);
    }

    public ConstraintDetectWrongBend(Particle particle, Particle particle2, Particle particle3, double d, Callable callable) {
        this.part1 = particle;
        this.part2 = particle3;
        this.middle = particle2;
        this.threshold = d;
        this.callOnViolation = callable;
        this.violationAmount = 0.0;
    }

    public void satisfy(double d) {
        if (!this.active) {
            return;
        }
        part1part2.set(this.part2.position).subtractLocal(this.part1.position);
        part1part2.cross(Vector3d.UNIT_Z, perp);
        part1middle.set(this.middle.position).subtractLocal(this.part1.position);
        perp.normalizeLocal();
        double d2 = part1middle.dot(perp);
        this.violationAmount = 0.0;
        if (this.callOnViolation != null) {
            if (d2 < -this.threshold) {
                try {
                    this.callOnViolation.call();
                    this.setActive(false);
                }
                catch (Exception exception) {
                    Logger.getLogger(ConstraintDetectWrongBend.class.getName()).severe("callOnViolation threw an exception: " + exception);
                }
                this.violationAmount = -d2 - this.threshold;
            }
        } else if (d2 < 0.0) {
            this.violationAmount = -d2;
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
        if (!bl) {
            this.violationAmount = 0.0;
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public double getViolationAmount() {
        return this.violationAmount;
    }
}

