/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.tobbes.xbike.track.Track1D;
import com.turborilla.msm.gameobjects.TrackGameObject;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Material;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Track1DLoader
extends AbstractLoader<com.turborilla.msm.track.Track1D> {
    private static final Logger logger = Logger.getLogger(Track1DLoader.class.getName());
    private String[] loads = new String[]{"track1D"};

    @Override
    public String[] loads() {
        return this.loads;
    }

    @Override
    public com.turborilla.msm.track.Track1D load(URL uRL, Properties properties) throws IOException {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        com.turborilla.msm.track.Track1D track1D = null;
        Material material = null;
        if (!ResourceManager.expect("environment", properties)) {
            Logger.getLogger(TrackGameObject.class.getName()).severe("No material given through the \"environment\" property. Defaulting to \"tiki\"");
        }
        if (properties == null) {
            properties = new Properties();
        }
        try {
            material = (Material)ResourceManager.getInstance().load("material", properties.getProperty("environment", "tiki"), null);
        }
        catch (IOException iOException) {
            Logger.getLogger(TrackGameObject.class.getName()).severe("Could not load material \"" + properties.getProperty("environment", "tiki") + "\". Exception: " + iOException);
        }
        BinaryImporter binaryImporter = BinaryImporter.getInstance();
        try {
            track1D = (com.turborilla.msm.track.Track1D)binaryImporter.load(uRL.openStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.severe("Could not load track due to " + exception + ". Trying old format loader.");
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            try {
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                track1D = object instanceof Track1D ? ((Track1D)object).convert() : (com.turborilla.msm.track.Track1D)object;
                BinaryExporter binaryExporter = BinaryExporter.getInstance();
                FileOutputStream fileOutputStream = new FileOutputStream(new File(uRL.getPath()), false);
                binaryExporter.save((Savable)track1D, fileOutputStream);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                logger.severe("Could not load track from file \"" + uRL + "\". Exception: " + exception2);
            }
        }
        if (track1D != null) {
            track1D.setName(this.getFileName(uRL));
            track1D.unlock();
            TextureState textureState = displaySystem.getRenderer().createTextureState();
            Texture texture = null;
            if (material != null && material.getTexture() != null) {
                texture = material.getTexture();
                texture.setWrap(3);
                texture.setScale(new Vector3f(material.getScaleU(), material.getScaleV(), 1.0f));
                textureState.setTexture(texture);
            }
            textureState.setEnabled(true);
            track1D.setRenderState(textureState);
            MaterialState materialState = displaySystem.getRenderer().createMaterialState();
            material.applyLightingToMaterialState(materialState);
            Material material2 = material;
            material2.getClass();
            material.setMaterialChangedListener(new Material.UpdateSpatialOnMaterialChange(material2, track1D, textureState, materialState));
            materialState.setEnabled(true);
            track1D.setRenderState(materialState);
            track1D.updateRenderState();
            track1D.lock();
        }
        return track1D;
    }

    private String getFileName(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getPath();
        if (string.endsWith("/") || string.equals("")) {
            return null;
        }
        return string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf(".msmtrack"));
    }
}

