/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Texture;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.skin.Skin;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinLoader
extends AbstractLoader<Skin> {
    private static final Logger logger = Logger.getLogger(SkinLoader.class.getName());
    private static final String[] loads = new String[]{"skin", "bikeskin", "riderskin"};

    public SkinLoader() {
        this.addSuffix(".xml");
    }

    @Override
    public Skin load(URL uRL, Properties properties) throws IOException {
        Skin skin = new Skin();
        try {
            new skinXMLParser(skin, uRL);
        }
        catch (Exception exception) {
            throw new IOException("Could not load skin: \"" + uRL.toString() + "\" : " + exception);
        }
        return skin;
    }

    @Override
    public String[] loads() {
        return loads;
    }

    @Override
    public boolean canReload() {
        return true;
    }

    @Override
    public void reload(Skin skin, URL uRL, Properties properties) throws IOException {
        Skin skin2 = skin;
        skin2.clear();
        try {
            new skinXMLParser(skin2, uRL);
        }
        catch (Exception exception) {
            throw new IOException("Could not load skin: \"" + uRL.toString() + "\" : " + exception);
        }
        skin2.reApply();
        logger.info("Reloaded skin: \"" + uRL.toString() + "\"");
    }

    private class skinXMLParser
    extends DefaultHandler {
        protected Skin skin;
        protected URL file;
        protected float zOffset = 0.0f;
        protected float deltaZ = 0.1f;
        public boolean inSkin = false;
        public boolean inSkinObject = false;

        public skinXMLParser(Skin skin, URL uRL) throws ParserConfigurationException, SAXException, IOException {
            if (skin == null) {
                return;
            }
            this.skin = skin;
            this.file = uRL;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(uRL.openStream(), (DefaultHandler)this);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AttributesDebug attributesDebug = new AttributesDebug(attributes);
            if ("SKIN".equals(string3)) {
                if (this.inSkin) {
                    throw new SAXException("Cannot define SKIN within SKIN, i.e. no nesting");
                }
                this.inSkin = true;
                this.skin.setName(attributesDebug.getValueChecked("name"));
                this.skin.setType(attributesDebug.getValue("type"));
            } else if ("SKINOBJECT".equals(string3)) {
                Texture texture;
                Object object;
                if (this.inSkinObject) {
                    throw new SAXException("Cannot define SKINOBJECT within SKINOBJECT, i.e. no nesting");
                }
                if (!this.inSkin) {
                    throw new SAXException("SKINOBJECT must be defined within SKIN");
                }
                this.inSkinObject = true;
                String string4 = attributesDebug.getValueChecked("name");
                String string5 = attributesDebug.getValue("flipImage");
                try {
                    object = null;
                    object = new Properties();
                    if (string5 != null) {
                        ((Properties)object).setProperty("textureFlip", string5);
                    }
                    ((Properties)object).setProperty("textureMinFilter", "MM_LINEAR");
                    ((Properties)object).setProperty("textureMagFilter", "MM_LINEAR");
                    texture = (Texture)ResourceManager.getInstance().load("texture", attributesDebug.getValueChecked("image"), (Properties)object);
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
                if (texture == null) {
                    throw new SAXException("Could not find image: \"" + attributesDebug.getValue("image") + "\" defined in skin \"" + this.skin.getName() + "\"");
                }
                object = this.skin.newSkinObject(string4, texture);
                String string6 = attributesDebug.getValue("width");
                String string7 = attributesDebug.getValue("length");
                String string8 = attributesDebug.getValue("degRotation");
                String string9 = attributesDebug.getValue("translationX");
                String string10 = attributesDebug.getValue("translationY");
                String string11 = attributesDebug.getValue("translationZ");
                String string12 = attributesDebug.getValue("nwU");
                String string13 = attributesDebug.getValue("nwV");
                String string14 = attributesDebug.getValue("neU");
                String string15 = attributesDebug.getValue("neV");
                String string16 = attributesDebug.getValue("seU");
                String string17 = attributesDebug.getValue("seV");
                String string18 = attributesDebug.getValue("swU");
                String string19 = attributesDebug.getValue("swV");
                if (string6 != null) {
                    ((Skin.SkinObject)object).setWidth(Float.parseFloat(string6));
                }
                if (string7 != null) {
                    ((Skin.SkinObject)object).setLength(Float.parseFloat(string7));
                }
                if (string8 != null) {
                    ((Skin.SkinObject)object).setDegRotation(Float.parseFloat(string8));
                }
                if (string9 != null) {
                    ((Skin.SkinObject)object).getTranslation().x = Float.parseFloat(string9);
                }
                if (string10 != null) {
                    ((Skin.SkinObject)object).getTranslation().y = Float.parseFloat(string10);
                }
                if (string11 != null) {
                    ((Skin.SkinObject)object).getTranslation().z = Float.parseFloat(string11);
                } else {
                    ((Skin.SkinObject)object).getTranslation().z = this.zOffset;
                    this.zOffset += this.deltaZ;
                }
                if (string12 != null) {
                    ((Skin.SkinObject)object).setNwU(Float.parseFloat(string12));
                }
                if (string13 != null) {
                    ((Skin.SkinObject)object).setNwV(1.0f - Float.parseFloat(string19));
                }
                if (string14 != null) {
                    ((Skin.SkinObject)object).setNeU(Float.parseFloat(string14));
                }
                if (string15 != null) {
                    ((Skin.SkinObject)object).setNeV(1.0f - Float.parseFloat(string17));
                }
                if (string16 != null) {
                    ((Skin.SkinObject)object).setSeU(Float.parseFloat(string16));
                }
                if (string17 != null) {
                    ((Skin.SkinObject)object).setSeV(1.0f - Float.parseFloat(string15));
                }
                if (string18 != null) {
                    ((Skin.SkinObject)object).setSwU(Float.parseFloat(string18));
                }
                if (string19 != null) {
                    ((Skin.SkinObject)object).setSwV(1.0f - Float.parseFloat(string13));
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("SKIN".equals(string3)) {
                this.inSkin = false;
            } else if ("SKINOBJECT".equals(string3)) {
                this.inSkinObject = false;
            }
        }

        private class AttributesDebug
        extends AttributesImpl {
            public AttributesDebug(Attributes attributes) {
                super(attributes);
            }

            public String getValueChecked(String string) {
                String string2 = super.getValue(string);
                if (string2 == null) {
                    throw new RuntimeException("Could not find attribute \"" + string + "\"");
                }
                return string2;
            }
        }
    }
}

