/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Image;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.scrolling.Layer;
import com.turborilla.scrolling.Parallax;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallaxLoader
extends AbstractLoader<Parallax> {
    private static final String[] loads = new String[]{"parallax", "background"};

    public ParallaxLoader() {
        this.addSuffix(".xml");
    }

    @Override
    public Parallax load(URL uRL, Properties properties) throws IOException {
        Parallax parallax = new Parallax("");
        try {
            new parallaxXMLParser(parallax, uRL, properties, false);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Could not load parallax: \"" + uRL.toString() + "\" : " + classCastException + " \n ");
        }
        catch (IOException iOException) {
            throw new IOException("Could not load parallax: \"" + uRL.toString() + "\" : " + iOException + " \n ");
        }
        catch (SAXException sAXException) {
            throw new IOException("Could not load parallax: \"" + uRL.toString() + "\" : " + sAXException + " \n ");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Could not load parallax: \"" + uRL.toString() + "\" : " + parserConfigurationException + " \n ");
        }
        return parallax;
    }

    @Override
    public boolean canReload() {
        return true;
    }

    @Override
    public void reload(Parallax parallax, URL uRL, Properties properties) throws IOException {
        try {
            new parallaxXMLParser(parallax, uRL, properties, true);
        }
        catch (Exception exception) {
            throw new IOException("Could not reload parallax: \"" + uRL.toString() + "\" : " + exception);
        }
    }

    @Override
    public String[] loads() {
        return loads;
    }

    private class parallaxXMLParser
    extends DefaultHandler {
        protected Parallax parallax;
        protected float parallaxSpeed = 1.0f;
        protected Properties props;
        protected int zOrder = 0;
        protected URL file;
        protected boolean reload;
        public boolean inParallax = false;
        public boolean inLayer = false;

        public parallaxXMLParser(Parallax parallax, URL uRL, Properties properties, boolean bl) throws ParserConfigurationException, SAXException, IOException {
            if (parallax == null) {
                return;
            }
            this.parallax = parallax;
            this.file = uRL;
            this.props = (Properties)properties.clone();
            this.reload = bl;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(uRL.openStream(), (DefaultHandler)this);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AttributesDebug attributesDebug = new AttributesDebug(attributes);
            if ("PARALLAX".equals(string3)) {
                if (this.inParallax) {
                    throw new SAXException("Cannot define PARALLAX within PARALLAX, i.e. no nesting");
                }
                this.inParallax = true;
                this.parallax.setName(attributesDebug.getValueChecked("name"));
                String string4 = attributesDebug.getValue("speed");
                if (string4 != null) {
                    this.parallaxSpeed = Float.parseFloat(string4);
                }
            } else if ("LAYER".equals(string3)) {
                Object object;
                if (this.inLayer) {
                    throw new SAXException("Cannot define LAYER within LAYER, i.e. no nesting");
                }
                if (!this.inParallax) {
                    throw new SAXException("LAYER must be defined within PARALLAX");
                }
                this.inLayer = true;
                String string5 = attributesDebug.getValueChecked("name");
                float f = Float.parseFloat(attributesDebug.getValueChecked("yPos"));
                float f2 = Float.parseFloat(attributesDebug.getValueChecked("speed"));
                float f3 = 0.0f;
                String string6 = attributesDebug.getValue("ySpeed");
                if (string6 != null) {
                    f3 = Float.parseFloat(string6);
                }
                String string7 = attributesDebug.getValue("flipVert");
                String string8 = attributesDebug.getValue("wrapMode");
                String string9 = attributesDebug.getValue("alphaBlend");
                String string10 = attributesDebug.getValue("wholePixels");
                String string11 = attributesDebug.getValue("stretch");
                boolean bl = false;
                Layer.Wrap wrap = Layer.Wrap.NORMAL;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if (string7 != null) {
                    bl = Boolean.parseBoolean(string7);
                }
                if (string8 != null) {
                    for (Layer.Wrap wrap2 : Layer.Wrap.values()) {
                        if (wrap2.toString().compareToIgnoreCase(string8) != 0) continue;
                        wrap = wrap2;
                        break;
                    }
                }
                if (string9 != null) {
                    bl2 = Boolean.parseBoolean(string9);
                }
                if (string10 != null) {
                    bl3 = Boolean.parseBoolean(string10);
                }
                if (string11 != null) {
                    bl4 = Boolean.parseBoolean(string11);
                }
                if (this.props != null) {
                    float f4 = 1.25f;
                    float f5 = Float.parseFloat(this.props.getProperty("GameWidth", "1280")) / Float.parseFloat(this.props.getProperty("GameHeight", "1024"));
                    float f6 = Float.parseFloat(this.props.getProperty("GameWidth", "1280")) / 1280.0f;
                    f2 *= f4 / f5 * f6;
                }
                if (bl) {
                    if (Boolean.parseBoolean(this.props.getProperty("textureFlip", "false"))) {
                        this.props.setProperty("textureFlip", "false");
                    } else {
                        this.props.setProperty("textureFlip", "true");
                    }
                }
                if (!this.reload) {
                    object = null;
                    String string12 = this.props.getProperty("putInCache", "true");
                    this.props.setProperty("putInCache", "false");
                    try {
                        object = (Image)ResourceManager.getInstance().load("image", attributesDebug.getValueChecked("image"), this.props);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXException(classCastException);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                    if (object == null) {
                        throw new SAXException("Could not find image: \"" + attributesDebug.getValue("image") + "\" defined in parallax \"" + this.parallax.getName() + "\"");
                    }
                    this.props.setProperty("putInCache", string12);
                    this.parallax.addLayer(string5, (Image)object, f, this.zOrder--, f2, bl2, wrap, bl3, bl4).setYTransformationFactor(f3);
                } else {
                    object = this.parallax.getLayer(string5);
                    ((Layer)object).setTransformationFactor(f2);
                    ((Layer)object).setZOrder(this.zOrder);
                    ((Layer)object).setVerticalPos(f);
                    ((Layer)object).setYTransformationFactor(f3);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("PARALLAX".equals(string3)) {
                this.inParallax = false;
                this.parallax.changeSpeed(this.parallaxSpeed);
            } else if ("LAYER".equals(string3)) {
                this.inLayer = false;
            }
        }

        private class AttributesDebug
        extends AttributesImpl {
            public AttributesDebug(Attributes attributes) {
                super(attributes);
            }

            public String getValueChecked(String string) {
                String string2 = super.getValue(string);
                if (string2 == null) {
                    throw new RuntimeException("Could not find attribute \"" + string + "\"");
                }
                return string2;
            }
        }
    }
}

