/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Material;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialLoader
extends AbstractLoader<Material> {
    private String[] loads = new String[]{"material"};

    public MaterialLoader() {
        this.addSuffix(".txt");
    }

    @Override
    public Material load(URL uRL, Properties properties) throws IOException {
        Material material = new Material();
        Properties properties2 = ResourceManager.loadProps(uRL);
        this.loadMaterial(material, properties2);
        return material;
    }

    @Override
    public boolean canReload() {
        return true;
    }

    @Override
    public void reload(Material material, URL uRL, Properties properties) throws IOException {
        Properties properties2 = ResourceManager.loadProps(uRL);
        this.loadMaterial(material, properties2);
    }

    private void loadMaterial(Material material, Properties properties) throws IOException {
        ColorRGBA colorRGBA = new ColorRGBA();
        this.fillColor(colorRGBA, properties, "diffuse");
        ColorRGBA colorRGBA2 = new ColorRGBA();
        this.fillColor(colorRGBA2, properties, "ambient");
        ColorRGBA colorRGBA3 = new ColorRGBA();
        this.fillColor(colorRGBA3, properties, "emissive");
        material.setLighting(colorRGBA, colorRGBA2, colorRGBA3);
        if (ResourceManager.expect("texture", properties)) {
            if (properties.getProperty("textureMinFilter") == null) {
                properties.setProperty("textureMinFilter", "MM_LINEAR_NEAREST");
            }
            if (properties.getProperty("textureMagFilter") == null) {
                properties.setProperty("textureMagFilter", "FM_LINEAR");
            }
            Texture texture = (Texture)ResourceManager.getInstance().load("texture", properties.getProperty("texture"), properties);
            float f = Float.parseFloat(properties.getProperty("scaleU"));
            float f2 = Float.parseFloat(properties.getProperty("scaleV"));
            material.setTexture(texture, f, f2);
        } else {
            material.setTexture(null, 1.0f, 1.0f);
        }
        material.update();
    }

    private void fillColor(ColorRGBA colorRGBA, Properties properties, String string) {
        String[] stringArray = new String[]{"R", "G", "B", "A"};
        float[] fArray = new float[4];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = properties.getProperty(string + string2);
            fArray[i] = string3 != null ? Float.parseFloat(string3) : 0.0f;
        }
        colorRGBA.set(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    @Override
    public String[] loads() {
        return this.loads;
    }
}

