/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jme.image.Image;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLoader
extends AbstractLoader<Image> {
    private static final Logger logger = Logger.getLogger(ImageLoader.class.getName());
    String[] loads = new String[]{"image"};

    public ImageLoader() {
        this.addSuffix("tga");
        this.addSuffix("dds");
        this.addSuffix("jpg");
        this.addSuffix("png");
    }

    @Override
    public Image load(URL uRL, Properties properties) throws IOException {
        boolean bl = false;
        boolean bl2 = true;
        String string = null;
        if (properties != null) {
            if (properties.getProperty("textureFlip") != null) {
                bl = Boolean.parseBoolean(properties.getProperty("textureFlip"));
            }
            if (properties.getProperty("separateChannels") != null && properties.getProperty("loadFile") != null) {
                bl2 = Boolean.parseBoolean(properties.getProperty("separateChannels"));
                string = properties.getProperty("loadFile");
            }
        }
        Image image = null;
        if (!bl2) {
            image = TextureManager.loadImage(uRL, bl);
        } else {
            String string2 = string + "_RGB";
            String string3 = string + "_A";
            logger.info("Looking for: " + string2 + " and " + string3);
            URL uRL2 = ResourceManager.findUrl(string2, this.getPaths(), this.getSuffices());
            URL uRL3 = ResourceManager.findUrl(string3, this.getPaths(), this.getSuffices());
            if (uRL2 == null || uRL3 == null) {
                logger.warning("Could not find seperate channel image files for \"" + string + "\". Loading regular image.");
                float f = Timer.getTimer().getTimeInSeconds();
                image = TextureManager.loadImage(uRL, bl);
                if (image != null) {
                    logger.info("Loaded regular image \"" + uRL + "\" in: " + (Timer.getTimer().getTimeInSeconds() - f));
                } else {
                    logger.severe("Could not load regular image \"" + uRL + "\". Aborting.");
                }
            } else {
                Properties properties2 = new Properties(properties);
                properties2.setProperty("separateChannels", "false");
                Image image2 = this.load(uRL2, properties2);
                BufferedImage bufferedImage = ImageIO.read(uRL3);
                image = ImageUtils.composeImage(image2, bufferedImage, false);
            }
        }
        return image;
    }

    @Override
    public String[] loads() {
        return this.loads;
    }
}

