/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.turborilla.msm.loaders.AbstractLoader;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.sound.CompositeSFX;
import com.turborilla.sound.TurboSoundSystem;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class CompositeSFXLoader
extends AbstractLoader {
    private TurboSoundSystem soundSystem;
    String[] loads = new String[]{"compositeSFX", "CompositeSFX", "compositeSfx", "compositesfx"};

    public CompositeSFXLoader(TurboSoundSystem turboSoundSystem) {
        this.soundSystem = turboSoundSystem;
        this.addSuffix("sfx");
    }

    public Object load(URL uRL, Properties properties) throws IOException {
        if (this.soundSystem == null) {
            throw new IOException("Could not load sfx: \"" + uRL.toString() + "\" : The SoundSystem is not initialised.");
        }
        CompositeSFX compositeSFX = new CompositeSFX(this.soundSystem);
        try {
            new sfxXMLParser(compositeSFX, uRL, properties);
        }
        catch (Exception exception) {
            throw new IOException("Could not load sfx: \"" + uRL.toString() + "\" : " + exception);
        }
        return compositeSFX;
    }

    public String[] loads() {
        return this.loads;
    }

    private class sfxXMLParser
    extends DefaultHandler {
        protected CompositeSFX sfx;
        protected ArrayList<String> tracks;
        protected double[] probabilities = new double[20];
        protected URL file;
        protected Properties props;
        private boolean useProbabilities = true;

        public sfxXMLParser(CompositeSFX compositeSFX, URL uRL, Properties properties) throws ParserConfigurationException, SAXException, IOException {
            if (compositeSFX == null) {
                return;
            }
            this.sfx = compositeSFX;
            this.file = uRL;
            this.props = properties;
            this.tracks = new ArrayList();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(uRL.openStream(), (DefaultHandler)this);
            double[] dArray = null;
            if (this.useProbabilities) {
                dArray = new double[this.tracks.size()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.probabilities[i];
                }
            }
            compositeSFX.setTracks(this.tracks.toArray(new String[0]), dArray);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AttributesDebug attributesDebug = new AttributesDebug(attributes);
            if ("SFX".equals(string3)) {
                String string4 = attributesDebug.getValue("audio");
                if (string4 == null) {
                    throw new SAXException("No audio filename given");
                }
                String string5 = null;
                URL uRL = ResourceManager.findUrl(string4, new String[]{"sounds/data"}, new String[]{"ogg", "wav"});
                if (uRL == null) {
                    throw new SAXException("Audio file \"" + string4 + "\" not found. ");
                }
                string5 = string4 + uRL.getPath().substring(uRL.getPath().lastIndexOf("."));
                if (string5 != null) {
                    this.tracks.add(string5);
                    CompositeSFXLoader.this.soundSystem.loadSound(string5);
                    double d = 0.0;
                    if (this.useProbabilities) {
                        try {
                            d = Double.parseDouble(attributesDebug.getValue("probability"));
                        }
                        catch (Exception exception) {
                            this.useProbabilities = false;
                            this.probabilities = null;
                        }
                        if (this.useProbabilities) {
                            this.probabilities[this.tracks.size() - 1] = d;
                        }
                    }
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("SFX".equals(string3)) {
                // empty if block
            }
        }

        private class AttributesDebug
        extends AttributesImpl {
            public AttributesDebug(Attributes attributes) {
                super(attributes);
            }

            public String getValue(String string) {
                String string2 = super.getValue(string);
                if (string2 == null) {
                    throw new RuntimeException("Could not find attribute \"" + string + "\"");
                }
                return string2;
            }
        }
    }
}

