/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.loaders;

import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.turborilla.msm.loaders.AbstractLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioTrackLoader
extends AbstractLoader<AudioTrack> {
    private float defaultReferenceDistance = 1.0f;
    private float defaultMaxDistance = 10.0f;
    private float defaultRolloff = -1.0f;
    private float defaultVolume = 1.0f;
    private AudioTrack.TrackType defaultType = AudioTrack.TrackType.POSITIONAL;
    private boolean defaultRelative = false;
    String[] loads = new String[]{"AudioTrack", "audiotrack"};

    public AudioTrackLoader() {
        this.addSuffix("ogg");
        this.addSuffix("wav");
    }

    @Override
    public AudioTrack load(URL uRL, Properties properties) throws IOException {
        if (!AudioSystem.isCreated()) {
            throw new IOException("Could not load AudioTrack: \"" + uRL.toString() + "\" : The AudioSystem is not initialised.");
        }
        boolean bl = false;
        if (properties != null && "true".equals(properties.getProperty("stream"))) {
            bl = true;
        }
        AudioTrack audioTrack = AudioSystem.getSystem().createAudioTrack(uRL, bl);
        audioTrack.setEnabled(true);
        audioTrack.setType(this.defaultType);
        audioTrack.setReferenceDistance(this.defaultReferenceDistance);
        audioTrack.setMaxAudibleDistance(this.defaultMaxDistance);
        if (this.defaultRolloff < 0.0f) {
            audioTrack.autosetRolloff();
        } else {
            audioTrack.setRolloff(this.defaultRolloff);
        }
        audioTrack.setRelative(this.defaultRelative);
        audioTrack.setVolume(this.defaultVolume);
        return audioTrack;
    }

    @Override
    public String[] loads() {
        return this.loads;
    }

    public float getDefaultReferenceDistance() {
        return this.defaultReferenceDistance;
    }

    public void setDefaultReferenceDistance(float f) {
        this.defaultReferenceDistance = f;
    }

    public boolean isDefaultRelative() {
        return this.defaultRelative;
    }

    public void setDefaultRelative(boolean bl) {
        this.defaultRelative = bl;
    }

    public float getDefaultRolloff() {
        return this.defaultRolloff;
    }

    public void setDefaultRolloff(float f) {
        this.defaultRolloff = f;
    }

    public AudioTrack.TrackType getDefaultType() {
        return this.defaultType;
    }

    public void setDefaultType(AudioTrack.TrackType trackType) {
        this.defaultType = trackType;
    }

    public float getDefaultVolume() {
        return this.defaultVolume;
    }

    public void setDefaultVolume(float f) {
        this.defaultVolume = f;
    }

    public float getDefaultMaxDistance() {
        return this.defaultMaxDistance;
    }

    public void setDefaultMaxDistance(float f) {
        this.defaultMaxDistance = f;
    }
}

