/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.input;

import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.math.Vector2f;
import com.turborilla.msm.components.GyroComponent;
import com.turborilla.msm.components.LeaningComponent;

public class LeaningAction
extends InputAction {
    LeaningComponent leaningComponent;
    GyroComponent gyroComponent;
    private Vector2f leanInputMin = new Vector2f(-1.0f, -1.0f);
    private Vector2f leanInputMax = new Vector2f(1.0f, 1.0f);
    private boolean accumulative = false;
    int xAxisIndex = 0;
    int yAxisIndex = 1;
    private static Vector2f delta = new Vector2f();
    private float invrangeX;
    private float invrangeY;
    private boolean relative = false;
    private Vector2f pos = new Vector2f(0.5f, 0.5f);

    public LeaningAction(LeaningComponent leaningComponent) {
        this.leaningComponent = leaningComponent;
        this.gyroComponent = null;
        this.setLeanInputRanges(-1.0f, -1.0f, 1.0f, 1.0f);
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void performAction(InputActionEvent inputActionEvent) {
        if (!this.relative) {
            float f = inputActionEvent.getTriggerPosition();
            if (inputActionEvent.getTriggerIndex() == this.xAxisIndex) {
                delta.set(inputActionEvent.getTriggerDelta(), 0.0f);
                f = Math.min(f, this.leanInputMax.x);
                f = Math.max(f, this.leanInputMin.x);
                f = (f - this.leanInputMin.x) * this.invrangeX * 2.0f - 1.0f;
                this.leaningComponent.setLeanX(f);
            } else if (inputActionEvent.getTriggerIndex() == this.yAxisIndex) {
                delta.set(0.0f, inputActionEvent.getTriggerDelta());
                f = Math.min(f, this.leanInputMax.y);
                f = Math.max(f, this.leanInputMin.y);
                f = (f - this.leanInputMin.y) * this.invrangeY * 2.0f - 1.0f;
                this.leaningComponent.setLeanY(f);
            }
            this.gyroComponent.addTilt(LeaningAction.delta.x);
        } else {
            if (inputActionEvent.getTriggerIndex() == this.xAxisIndex) {
                delta.set(inputActionEvent.getTriggerDelta(), 0.0f);
                this.pos.x += LeaningAction.delta.x;
                this.pos.x = Math.min(this.pos.x, this.leanInputMax.x);
                this.pos.x = Math.max(this.pos.x, this.leanInputMin.x);
                float f = (this.pos.x - this.leanInputMin.x) * this.invrangeX * 2.0f - 1.0f;
                if (!this.accumulative) {
                    this.leaningComponent.setLeanX(f);
                } else {
                    this.leaningComponent.addLean(f, 0.0f);
                    if (this.gyroComponent != null && f > 0.25f || f < -0.25f) {
                        if (f > 0.0f) {
                            this.gyroComponent.addPermanentTilt((f - 0.25f) / 10.0f);
                        } else {
                            this.gyroComponent.addPermanentTilt((f + 0.25f) / 10.0f);
                        }
                    } else {
                        this.gyroComponent.addPermanentTilt(0.0);
                    }
                }
            } else if (inputActionEvent.getTriggerIndex() == this.yAxisIndex) {
                delta.set(0.0f, inputActionEvent.getTriggerDelta());
                this.pos.y += LeaningAction.delta.y;
                this.pos.y = Math.min(this.pos.y, this.leanInputMax.y);
                this.pos.y = Math.max(this.pos.y, this.leanInputMin.y);
                float f = (this.pos.y - this.leanInputMin.y) * this.invrangeY * 2.0f - 1.0f;
                this.leaningComponent.setLeanY(f);
            }
            if (this.gyroComponent != null && inputActionEvent.getTriggerIndex() == this.xAxisIndex && !this.accumulative) {
                this.gyroComponent.addTilt(LeaningAction.delta.x);
            }
        }
    }

    public void setGyroComponent(GyroComponent gyroComponent) {
        this.gyroComponent = gyroComponent;
    }

    public int getXAxisIndex() {
        return this.xAxisIndex;
    }

    public void setXAxisIndex(int n) {
        this.xAxisIndex = n;
    }

    public int getYAxisIndex() {
        return this.yAxisIndex;
    }

    public void setYAxisIndex(int n) {
        this.yAxisIndex = n;
    }

    public void setLeanInputRanges(float f, float f2, float f3, float f4) {
        this.leanInputMax.set(f3, f4);
        this.leanInputMin.set(f, f2);
        this.invrangeX = 1.0f / (this.leanInputMax.x - this.leanInputMin.x);
        this.invrangeY = 1.0f / (this.leanInputMax.y - this.leanInputMin.y);
    }

    public boolean isAccumulative() {
        return this.accumulative;
    }

    public void setAccumulative(boolean bl) {
        this.accumulative = bl;
    }
}

