/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.textfield;

import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.ITextChangedListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.textfield.Caret;

public class TextField
extends BaseWidget
implements IResizableWidget {
    private static float caretFadeTime = 0.2f;
    private static float caretVisibleTime = 1.0f;
    private static float caretInvisibleTime = 0.3f;
    private Label defaultLabel;
    private Label focusedLabel;
    private Label preLabel = null;
    private String text = "";
    private String preText = null;
    private float width;
    private float height;
    private int positionInText = 0;
    private Caret caret;
    private int maxLength;
    private boolean displayingPreText = false;
    private IWidget enterPassedOnToWidget = null;
    private ITextChangedListener textChangedListener;
    private String validChars = null;
    private static Vector3f tempVec = new Vector3f();

    public TextField(String string, String string2, float f, float f2, int n, String string3, String string4) {
        this(string, string2, f, f2, n, string3, string4, (float)DisplaySystem.getDisplaySystem().getHeight() / 1024.0f);
    }

    public TextField(String string, String string2, float f, float f2, int n, String string3, String string4, float f3) {
        super(string);
        this.width = f;
        this.height = f2;
        this.setFocusable(true);
        this.setActivatable(true);
        this.maxLength = n;
        this.defaultLabel = new Label(string + ":Label", "", f, f2, string3, "corner", "edge", "combobox", 0.2f * f3);
        this.addLayer(this.defaultLabel);
        this.defaultLabel.setHorisontalAlignment(HorisontalAlignment.LEFT);
        this.defaultLabel.setFocusable(false);
        if (string4 != null) {
            this.focusedLabel = new Label(string + ":Label", "", f, f2, string4, "corner", "edge", "combobox", 0.3f * f3);
            this.addLayer(this.focusedLabel);
            this.focusedLabel.setHorisontalAlignment(HorisontalAlignment.LEFT);
            this.focusedLabel.setFocusable(false);
            this.focusedLabel.getFader().setColor(MenuButton.noAlpha);
        }
        if (string2 != null) {
            this.preText = string2;
            this.preLabel = new Label(string + ":preTextLabel", this.preText, f, f2, string3, "corner", "edge", "combobox", 0.2f * f3);
            this.displayingPreText = true;
            this.addLayer(this.preLabel);
            this.preLabel.setHorisontalAlignment(HorisontalAlignment.LEFT);
        }
        this.caret = new Caret(string + ":caret", "caret", f2 * 0.8f);
        this.addLayer(this.caret);
        this.caret.getFader().setColor(MenuButton.noAlpha);
        this.caret.getScaler().setDamping(0.4f);
        this.updateCaret(true);
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.defaultLabel.setSize(f, f2);
        if (this.focusedLabel != null) {
            this.focusedLabel.setSize(f, f2);
        }
        if (this.preLabel != null) {
            this.preLabel.setSize(f, f2);
        }
        this.caret.setSize(f, f2 * 0.8f);
        this.updateCaret(true);
        this.updateModelBound();
    }

    public void setCaretPosition(int n) {
        this.positionInText = n;
        this.updateCaret(true);
    }

    public boolean onKeyTyped(int n, char c) {
        boolean bl = false;
        if (c != '\u0000' && this.defaultLabel.getFont().isValidChar(c) && this.isValidChar(c)) {
            String string = this.positionInText < this.getText().length() ? this.getText().substring(0, this.positionInText) + c + this.getText().substring(this.positionInText, this.getText().length()) : this.getText() + c;
            ++this.positionInText;
            if (this.defaultLabel.getWidth(string) * this.defaultLabel.getLocalScale().x > this.width * 0.97f) {
                string = string.substring(0, string.length() - 1);
            }
            if (this.maxLength > 0 && string.length() > this.maxLength) {
                string = string.substring(0, this.maxLength);
            }
            this.setText(string);
            bl = true;
        }
        this.updateLook();
        return bl;
    }

    private boolean isValidChar(char c) {
        return this.validChars == null || this.validChars.indexOf(c) >= 0;
    }

    public boolean onKeyUp(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 28: 
            case 156: {
                if (this.enterPassedOnToWidget != null) {
                    this.enterPassedOnToWidget.onLeftMouseClicked(new Vector3f());
                }
                bl = true;
                break;
            }
            case 57: {
                bl = true;
            }
        }
        return bl;
    }

    public void onLeftMouseClicked(Vector3f vector3f) {
        float f = 2.0f - this.width * 0.5f + this.getLocalTranslation().x;
        String string = this.getText();
        this.positionInText = string.length();
        for (int i = 0; i < string.length(); ++i) {
            float f2 = this.defaultLabel.getWidth(this.getText().substring(0, i + 1)) * this.defaultLabel.getLocalScale().x;
            if (!(f + f2 > vector3f.x)) continue;
            this.positionInText = i;
            break;
        }
        this.updateCaret();
    }

    public boolean onKeyDown(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 203: {
                --this.positionInText;
                bl = true;
                break;
            }
            case 205: {
                ++this.positionInText;
                bl = true;
                break;
            }
            case 199: {
                this.positionInText = 0;
                bl = true;
                break;
            }
            case 207: {
                this.positionInText = this.getText().length();
                bl = true;
                break;
            }
            case 14: {
                if (this.positionInText > 0) {
                    if (this.positionInText < this.getText().length()) {
                        this.setText(this.getText().substring(0, this.positionInText - 1) + this.getText().substring(this.positionInText, this.getText().length()));
                    } else {
                        this.setText(this.getText().substring(0, this.positionInText - 1));
                    }
                    --this.positionInText;
                }
                bl = true;
                break;
            }
            case 211: {
                if (this.positionInText < this.getText().length()) {
                    if (this.positionInText > 0) {
                        this.setText(this.getText().substring(0, this.positionInText) + this.getText().substring(this.positionInText + 1, this.getText().length()));
                    } else {
                        this.setText(this.getText().substring(1, this.getText().length()));
                    }
                }
                bl = true;
            }
        }
        this.updateLook();
        return bl;
    }

    private void updateLook() {
        this.updateCaret();
    }

    public void onBlur() {
        if (this.preLabel != null && ("".equals(this.getText()) || this.getText() == null)) {
            this.preLabel.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            this.displayingPreText = true;
        }
        this.caret.getFader().setRepeatType(0);
        this.caret.getFader().fadeTo(MenuButton.noAlpha, caretFadeTime);
        if (this.focusedLabel != null) {
            this.focusedLabel.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        }
    }

    public void onFocus() {
        if (this.preLabel != null && this.displayingPreText) {
            this.preLabel.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            this.displayingPreText = false;
        }
        this.caret.getFader().setRepeatType(1);
        this.caret.getFader().fade(MenuButton.noAlpha, MenuButton.fullAlpha, caretFadeTime);
        this.caret.getFader().addFadeToQueue(MenuButton.fullAlpha, MenuButton.fullAlpha, caretVisibleTime);
        this.caret.getFader().addFadeToQueue(MenuButton.fullAlpha, MenuButton.noAlpha, caretFadeTime);
        this.caret.getFader().addFadeToQueue(MenuButton.noAlpha, MenuButton.noAlpha, caretInvisibleTime);
        if (this.focusedLabel != null) {
            this.focusedLabel.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.defaultLabel.setText(string);
        if (this.focusedLabel != null) {
            this.focusedLabel.setText(string);
        }
        if (this.preLabel != null && this.displayingPreText) {
            this.preLabel.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            this.displayingPreText = false;
        }
        if (this.textChangedListener != null) {
            this.textChangedListener.onTextChanged(this, string);
        }
    }

    private void updateCaret() {
        this.updateCaret(false);
    }

    private void updateCaret(boolean bl) {
        tempVec.set(this.caret.getLocalTranslation());
        if (this.positionInText < 0) {
            this.positionInText = 0;
        }
        if (this.positionInText > this.getText().length()) {
            this.positionInText = this.getText().length();
        }
        TextField.tempVec.x = this.positionInText <= 0 ? 5.0f - this.width * 0.5f : 5.0f - this.width * 0.5f + this.defaultLabel.getWidth(this.getText().substring(0, this.positionInText)) * this.defaultLabel.getLocalScale().x;
        if (!bl) {
            this.caret.getMover().translateTo(tempVec, 1.2f, 1.2f);
        } else {
            this.caret.getMover().setPosition(tempVec);
        }
    }

    public void setTextChangedListener(ITextChangedListener iTextChangedListener) {
        this.textChangedListener = iTextChangedListener;
    }

    public IWidget getEnterPassedOnToWidget() {
        return this.enterPassedOnToWidget;
    }

    public void setEnterPassedOnToWidget(IWidget iWidget) {
        this.enterPassedOnToWidget = iWidget;
    }

    public String getValidChars() {
        return this.validChars;
    }

    public void setValidChars(String string) {
        this.validChars = string;
    }
}

