/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.scrollbar;

import com.jme.image.Texture;
import com.jme.renderer.ColorRGBA;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollArea;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollArrow;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBarBar;
import com.turborilla.msm.loaders.ResourceManager;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class ScrollBar
extends BaseWidget
implements IResizableWidget {
    Logger logger = Logger.getLogger(ScrollBar.class.getCanonicalName());
    static ColorRGBA normal = new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f);
    static ColorRGBA over = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    static ColorRGBA active = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    private boolean disappearWhenNotNeeded = true;
    private String textureName = "scrollbar";
    private int[][] texCoordPixels = new int[][]{{1, 1, 14, 15}, {1, 16, 14, 30}, {15, 1, 28, 5}, {15, 6, 28, 9}, {15, 11, 28, 21}, {15, 22, 28, 26}, {15, 28, 28, 28}};
    private int numberOfElements = 0;
    private int numberOfVisibleElements = 0;
    private int position = 0;
    private Texture texture;
    private ScrollArea scrollArea;
    private ScrollArrow upArrow;
    private ScrollArrow downArrow;
    private ScrollBarBar bar;
    private float width;
    private float height;
    boolean shouldUpdateEnabled = false;
    private IElementPositionChangedListener elementPositionChangedListener;

    public ScrollBar(String string, String string2, int[][] nArray) {
        super(string);
        this.textureName = string2;
        this.texCoordPixels = nArray;
        this.init();
    }

    public ScrollBar(String string, String string2) {
        super(string);
        this.textureName = string2;
        this.init();
    }

    public ScrollBar(String string) {
        super(string);
        this.init();
    }

    protected void init() {
        try {
            Properties properties = new Properties();
            this.texture = (Texture)ResourceManager.getInstance().load("texture", this.textureName, null);
        }
        catch (IOException iOException) {
            this.logger.severe("Could not load scrollbar texture \"" + this.textureName + "\" due to " + iOException);
        }
        if (this.texture != null) {
            float f = this.texture.getImage().getWidth();
            float f2 = this.texture.getImage().getHeight();
            this.upArrow = new ScrollArrow(this.getName() + ":upArrow", this.texture, this.getTexCoords(0, f, f2));
            this.downArrow = new ScrollArrow(this.getName() + ":downArrow", this.texture, this.getTexCoords(1, f, f2));
            this.bar = new ScrollBarBar(this.getName() + ":bar", this, this.texture, this.getTexCoords(2, f, f2), this.getTexCoords(3, f, f2), this.getTexCoords(4, f, f2), this.getTexCoords(5, f, f2));
            this.scrollArea = new ScrollArea(this.getName() + ":scrollArea", this.texture, this.getTexCoords(6, f, f2));
            this.addLayer(this.scrollArea);
            this.addLayer(this.upArrow);
            this.addLayer(this.downArrow);
            this.addLayer(this.bar);
            this.upArrow.setClickListener(new Runnable(){

                public void run() {
                    ScrollBar.this.setElementPosition(ScrollBar.this.getElementPosition() - 1);
                }
            });
            this.downArrow.setClickListener(new Runnable(){

                public void run() {
                    ScrollBar.this.setElementPosition(ScrollBar.this.getElementPosition() + 1);
                }
            });
            this.bar.setPositionChangedListener(new Runnable(){

                public void run() {
                    ScrollBar.this.updateElementPositionFromBar();
                }
            });
            this.scrollArea.setClickListener(new ScrollArea.IMouseDownListener(){

                public void onMouseDown(float f) {
                    if (f > ScrollBar.this.bar.getBarPosition()) {
                        ScrollBar.this.setElementPosition(ScrollBar.this.getElementPosition() - ScrollBar.this.getNumberOfVisibleElements());
                    } else {
                        ScrollBar.this.setElementPosition(ScrollBar.this.getElementPosition() + ScrollBar.this.getNumberOfVisibleElements());
                    }
                }
            });
        }
        this.setEnabled(true, true);
        this.setNumberOfElements(0);
        this.setNumberOfVisibleElements(0);
        this.setElementPosition(0, false);
    }

    public void updateLook() {
        this.setSize(this.getWidth(), this.getHeight());
        this.updateEnabled();
    }

    private void updateEnabled() {
        if (this.getNumberOfElements() > this.getNumberOfVisibleElements() || !this.disappearWhenNotNeeded) {
            if (!this.isEnabled()) {
                this.setEnabled(true, true);
            }
        } else if (this.isEnabled()) {
            this.setEnabled(false, true);
        }
        this.shouldUpdateEnabled = false;
    }

    public void onEnable() {
        super.onEnable();
        this.shouldUpdateEnabled = true;
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        if (this.shouldUpdateEnabled) {
            this.updateEnabled();
        }
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.upArrow.setSize((int)f, (int)f2);
        this.downArrow.setSize((int)f, (int)f2);
        float f3 = f2 - this.downArrow.getHeight() - this.upArrow.getHeight();
        float f4 = 1.0f;
        if (this.numberOfElements > this.numberOfVisibleElements) {
            f4 = (float)this.numberOfVisibleElements / (float)this.numberOfElements;
        }
        float f5 = f3 * f4;
        this.bar.setSize((int)f, (int)f5);
        this.upArrow.getLocalTranslation().y = (int)(f2 / 2.0f - this.upArrow.getHeight() / 2.0f);
        this.downArrow.getLocalTranslation().y = (int)(-f2 / 2.0f + this.downArrow.getHeight() / 2.0f);
        float f6 = f3 * 0.5f;
        float f7 = -f3 * 0.5f;
        if (this.numberOfElements > this.numberOfVisibleElements) {
            this.bar.setBarPosition((float)this.position / (float)(this.numberOfElements - this.numberOfVisibleElements));
        } else {
            this.bar.setBarPosition(f6);
        }
        this.bar.setBounds(f7, f6);
        this.scrollArea.setSize(f, f6 - f7);
    }

    private float[] getTexCoords(int n, float f, float f2) {
        float[] fArray = new float[]{(float)this.texCoordPixels[n][0] / f, 1.0f - (float)this.texCoordPixels[n][1] / f2, (float)this.texCoordPixels[n][0] / f, 1.0f - (float)this.texCoordPixels[n][3] / f2, (float)this.texCoordPixels[n][2] / f, 1.0f - (float)this.texCoordPixels[n][3] / f2, (float)this.texCoordPixels[n][2] / f, 1.0f - (float)this.texCoordPixels[n][1] / f2};
        return fArray;
    }

    private void updateElementPositionFromBar() {
        int n = Math.round((float)(this.getNumberOfElements() - this.getNumberOfVisibleElements()) * this.bar.getRelativeBarPosition());
        this.setElementPosition(n);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int n) {
        this.numberOfElements = n;
        this.updateLook();
    }

    public int getElementPosition() {
        return this.position;
    }

    public void setElementPosition(int n) {
        this.setElementPosition(n, true);
    }

    public void setElementPosition(int n, boolean bl) {
        this.position = n;
        if (this.position < 0) {
            this.position = 0;
        }
        if (this.position > this.numberOfElements - this.numberOfVisibleElements) {
            this.position = this.numberOfElements - this.numberOfVisibleElements;
        }
        this.updateLook();
        if (bl) {
            this.notifyElementPositionChangedListener();
        }
    }

    public int getNumberOfVisibleElements() {
        return this.numberOfVisibleElements;
    }

    public void setNumberOfVisibleElements(int n) {
        this.numberOfVisibleElements = n;
        this.updateLook();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setBackgroundColor(ColorRGBA colorRGBA) {
        this.scrollArea.getFader().setColor(colorRGBA);
    }

    public IElementPositionChangedListener getElementPositionChangedListener() {
        return this.elementPositionChangedListener;
    }

    public void setElementPositionChangedListener(IElementPositionChangedListener iElementPositionChangedListener) {
        this.elementPositionChangedListener = iElementPositionChangedListener;
    }

    private void notifyElementPositionChangedListener() {
        if (this.getElementPositionChangedListener() != null) {
            this.getElementPositionChangedListener().onElementPositionChanged(this, this.getElementPosition());
        }
    }

    public static interface IElementPositionChangedListener {
        public void onElementPositionChanged(ScrollBar var1, int var2);
    }
}

