/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.scrollbar;

import com.jme.image.Texture;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBar;
import java.nio.FloatBuffer;

public class ScrollArrow
extends BaseWidget
implements IResizableWidget {
    private static float fadeTime = 0.1f;
    private Quad quad;
    private Texture texture;
    private float texWidth = 1.0f;
    private float texHeight = 1.0f;
    private float activatedForTime = 0.0f;
    private float repeatTime = 0.1f;
    private float initialRepeatTime = 0.4f;
    private Runnable clickListener;

    public ScrollArrow(String string, Texture texture, float[] fArray) {
        super(string);
        this.setFocusable(true);
        this.setActivatable(true);
        this.quad = null;
        this.texture = texture;
        float f = 1.0f;
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(texture);
        this.texWidth = (float)texture.getImage().getWidth() * (fArray[1] - fArray[3]);
        this.texHeight = (float)texture.getImage().getHeight() * (fArray[4] - fArray[2]);
        float f2 = 1.0f;
        this.quad = new Quad(this.getName() + ":quad", f2, f);
        this.quad.setRenderState(textureState);
        FloatBuffer floatBuffer = this.quad.getTextureBuffer(0, 0);
        floatBuffer.clear();
        floatBuffer.put(fArray);
        floatBuffer.flip();
        this.attachChild(this.quad);
    }

    public void setSize(float f, float f2) {
        f2 = this.texHeight * (f / this.texWidth);
        this.quad.resize(f, f2);
        this.updateLook();
    }

    void updateLook() {
        if (this.isEnabled()) {
            if (this.isActive()) {
                this.fader.fadeTo(ScrollBar.active, fadeTime);
            } else if (this.isMouseOver()) {
                this.fader.fadeTo(ScrollBar.over, fadeTime);
            } else {
                this.fader.fadeTo(ScrollBar.normal, fadeTime);
            }
        } else {
            this.fader.fadeTo(noAlpha, fadeTime);
        }
    }

    public void updateGeometricState(float f, boolean bl) {
        super.updateGeometricState(f, bl);
        if (this.isActive()) {
            this.activatedForTime += f;
            if (this.activatedForTime > this.initialRepeatTime) {
                this.notifyClickListener();
                this.activatedForTime -= this.repeatTime;
            }
        } else {
            this.activatedForTime = 0.0f;
        }
    }

    public void onActivate() {
        super.onActivate();
        this.updateLook();
        this.notifyClickListener();
    }

    public void onDeactivate() {
        super.onDeactivate();
        this.updateLook();
        this.activatedForTime = 0.0f;
    }

    public void onMouseOut() {
        super.onMouseOut();
        this.updateLook();
    }

    public void onMouseOver(boolean bl) {
        super.onMouseOver(bl);
        this.updateLook();
    }

    public Runnable getClickListener() {
        return this.clickListener;
    }

    public void setClickListener(Runnable runnable) {
        this.clickListener = runnable;
    }

    public void notifyClickListener() {
        if (this.getClickListener() != null) {
            this.getClickListener().run();
        }
    }

    public void onDisable() {
        super.onDisable();
        this.updateLook();
    }

    public void onEnable() {
        super.onEnable();
        this.updateLook();
    }
}

