/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.scrollbar;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import java.nio.FloatBuffer;

public class ScrollArea
extends BaseWidget
implements IResizableWidget {
    private Quad quad;
    private Texture texture;
    private float texWidth = 1.0f;
    private float texHeight = 1.0f;
    private IMouseDownListener clickListener;
    private Vector3f tempVec = new Vector3f();

    public ScrollArea(String string, Texture texture, float[] fArray) {
        super(string);
        this.setFocusable(false);
        this.setActivatable(true);
        this.quad = null;
        this.texture = texture;
        float f = 1.0f;
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(texture);
        this.texWidth = (float)texture.getImage().getWidth() * (fArray[1] - fArray[3]);
        this.texHeight = (float)texture.getImage().getHeight() * (fArray[4] - fArray[2]);
        float f2 = 1.0f;
        this.quad = new Quad(this.getName() + ":quad", f2, f);
        this.quad.setRenderState(textureState);
        FloatBuffer floatBuffer = this.quad.getTextureBuffer(0, 0);
        floatBuffer.clear();
        floatBuffer.put(fArray);
        floatBuffer.flip();
        this.attachChild(this.quad);
    }

    public void setSize(float f, float f2) {
        this.quad.resize(f, f2);
    }

    public IMouseDownListener getClickListener() {
        return this.clickListener;
    }

    public void setClickListener(IMouseDownListener iMouseDownListener) {
        this.clickListener = iMouseDownListener;
    }

    private void notifyClickListener(Vector3f vector3f) {
        if (this.getClickListener() != null) {
            this.getClickListener().onMouseDown(vector3f.y);
        }
    }

    public void onLeftMouseDown(Vector3f vector3f) {
        super.onLeftMouseDown(vector3f);
        this.notifyClickListener(this.worldToLocal(vector3f, this.tempVec));
    }

    public void onDisable() {
        super.onDisable();
        this.getFader().fadeTo(noAlpha, 0.2f);
    }

    public void onEnable() {
        super.onEnable();
        this.getFader().fadeTo(defaultColor, 0.2f);
    }

    public static interface IMouseDownListener {
        public void onMouseDown(float var1);
    }
}

