/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.panel;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.turborilla.gui.GuiHandler;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.IWidget;
import com.turborilla.msm.gui.turbogui.Rectangle;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.IListSelectionChangedListener;
import com.turborilla.msm.gui.turbogui.listeners.IMouseOverListener;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;
import com.turborilla.msm.gui.turbogui.panel.BorderPanel;
import com.turborilla.msm.gui.turbogui.scrollbar.ScrollBar;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Font;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollableLabelList<E>
extends BorderPanel {
    private ArrayList<Item<E>> items;
    private float padding = -5.0f;
    private float topMargin = 5.0f;
    private float bottomMargin = 0.0f;
    private int position = 0;
    private float scrollTime = 0.8f;
    private float highlightMoveTime = 0.15f;
    private float fadeTime = 0.2f;
    private float scrollDamping = 0.5f;
    private float arrowScrollSpeed = 9.999999f;
    private float scrolling = 0.0f;
    private float accScroll = 0.0f;
    private boolean smoothScrolling = false;
    private ScrollBar scrollBar;
    private static ColorRGBA noAlpha = new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f);
    private float keyRepeatInterval = 0.08f;
    private float keyRepeatStartInterval = 0.3f;
    private Rectangle mouseOverImage;
    private IMouseOverListener mouseOverLabelListener;
    private ColorRGBA mouseOverImageColor = new ColorRGBA(0.9f, 0.3f, 0.3f, 0.5f);
    private Label labelMouseIsOver = null;
    private Rectangle selectedImage;
    private ColorRGBA selectedImageColor = new ColorRGBA(0.8f, 0.2f, 0.2f, 1.0f);
    private Item<E> selectedItem = null;
    private float lineHeight = 20.0f;
    private HorisontalAlignment horisontalAligment = HorisontalAlignment.LEFT;
    private String fontFile;
    private IListSelectionChangedListener<E> selectionChangedListener;
    private Font font;
    private float upKeyTime = 0.0f;
    private float downKeyTime = 0.0f;
    private Vector3f tempVec = new Vector3f();
    private ColorRGBA tempColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private DetachWhenDoneFadingListener detachWhenDone = new DetachWhenDoneFadingListener();
    private IWidget simulateClickWidgetOnDoubleClick;

    public ScrollableLabelList(String string, float f, float f2, GuiHandler guiHandler, String string2, String string3, String string4, String string5, float f3, float f4) {
        super(string, f, f2, guiHandler, string3, string4, string5, f3);
        this.lineHeight = f4;
        this.padding = 0.0f;
        this.bottomMargin += f4;
        this.fontFile = string2;
        this.init();
        this.setFocusable(true);
    }

    private void init() {
        this.items = new ArrayList();
        this.mouseOverImage = new Rectangle(this.getName() + ":mouseOverRectangle", 1.0f, 1.0f);
        this.addWidget(this.mouseOverImage, new Vector2f(0.5f, 0.5f), true, true);
        this.mouseOverImage.getFader().setColor(MenuButton.noAlpha);
        this.mouseOverImage.getMover().setDamping(this.scrollDamping * 3.0f);
        this.mouseOverLabelListener = new IMouseOverListener<Label>(){

            @Override
            public void onMouseOver(Label label) {
                ScrollableLabelList.this.onMouseOverLabel(label);
            }

            @Override
            public void onMouseOut(Label label) {
                if (ScrollableLabelList.this.labelMouseIsOver == label) {
                    ScrollableLabelList.this.onMouseOverLabel(null);
                }
            }
        };
        this.selectedImage = new Rectangle(this.getName() + ":selectedRectangle", 1.0f, 1.0f);
        this.addWidget(this.selectedImage, new Vector2f(0.5f, 0.5f), true, true);
        this.selectedImage.getFader().setColor(MenuButton.noAlpha);
        this.selectedImage.getMover().setDamping(this.scrollDamping * 3.0f);
        try {
            Properties properties = new Properties();
            properties.setProperty("textureFlip", "false");
            this.font = (Font)ResourceManager.getInstance().load("font", this.fontFile, properties);
        }
        catch (IOException iOException) {
            Logger.getLogger(Label.class.getName()).severe("Could not create ScrollableLabelList. Exception: " + iOException);
        }
        this.scrollBar = new ScrollBar(this.getName() + ":scrollBar");
        this.addWidget(this.scrollBar, new Vector2f(0.5f, 0.5f), true, true);
        this.scrollBar.setElementPositionChangedListener(new ScrollBar.IElementPositionChangedListener(){

            public void onElementPositionChanged(ScrollBar scrollBar, int n) {
                ScrollableLabelList.this.setViewPosition(n);
            }
        });
        this.setSize(this.getWidth(), this.getHeight());
    }

    private void updateScrollBar(int n) {
        if (this.scrollBar != null) {
            this.scrollBar.setNumberOfElements(this.getItemCount());
            this.scrollBar.setNumberOfVisibleElements(n);
            this.scrollBar.setElementPosition(this.position, false);
        }
    }

    public void positionLabels() {
        if (this.items.size() <= 0) {
            return;
        }
        this.calculatePositions(true);
    }

    private void update() {
        if (this.items.size() <= 0) {
            return;
        }
        this.calculatePositions();
    }

    public void checkKeyboard(float f) {
        if (this.getGuiHandler() != null) {
            if (this.getGuiHandler().isKeyDown(200)) {
                this.upKeyTime += f;
                if (this.upKeyTime >= this.keyRepeatStartInterval + this.keyRepeatInterval) {
                    this.upKeyTime -= this.keyRepeatInterval;
                    if (this.selectedItem != null) {
                        this.selectPrevious();
                    } else {
                        this.setSelectedIndex(this.position);
                    }
                }
            } else {
                this.upKeyTime = 0.0f;
            }
            if (this.getGuiHandler().isKeyDown(208)) {
                this.downKeyTime += f;
                if (this.downKeyTime >= this.keyRepeatStartInterval + this.keyRepeatInterval) {
                    this.downKeyTime -= this.keyRepeatInterval;
                    if (this.selectedItem != null) {
                        this.selectNext();
                    } else {
                        this.setSelectedIndex(this.position);
                    }
                }
            } else {
                this.downKeyTime = 0.0f;
            }
        }
    }

    private void calculatePositions() {
        this.calculatePositions(!this.smoothScrolling);
    }

    private int indexOf(Label label) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get((int)i).label != label) continue;
            return i;
        }
        return -1;
    }

    private Vector3f getPositionInPanel(Label label, Vector3f vector3f) {
        return this.getPositionInPanel(this.indexOf(label), vector3f);
    }

    private Vector3f getPositionInPanel(Item item, Vector3f vector3f) {
        return this.getPositionInPanel(this.items.indexOf(item), vector3f);
    }

    private Vector3f getPositionInPanel(int n, Vector3f vector3f) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        if (n <= this.position - 1) {
            return null;
        }
        Vector3f vector3f2 = vector3f;
        if (vector3f2 == null) {
            vector3f2 = new Vector3f();
        }
        float f = this.getHeight() - this.topMargin + this.padding;
        for (int i = this.position; i <= n && i >= 0; ++i) {
            if (f <= this.bottomMargin) {
                return null;
            }
            Label label = this.items.get((int)i).label;
            float f2 = label.getLocalTranslation().x;
            float f3 = label.getLocalTranslation().z;
            vector3f2.set(f2, (f -= this.lineHeight + this.padding) - this.getHeight() * 0.5f, f3);
        }
        return vector3f2;
    }

    public void setViewPosition(int n) {
        this.position = n;
        this.calculatePositions(!this.smoothScrolling);
    }

    private int getViewportSize() {
        return (int)((this.getHeight() - this.topMargin - this.bottomMargin) / (this.lineHeight + this.padding));
    }

    private void calculatePositions(boolean bl) {
        float f;
        float f2 = this.getHeight() - this.topMargin + this.padding;
        if (this.position < 0) {
            this.position = 0;
        }
        if (this.position > 0) {
            for (int i = this.position - 1; i >= 0; --i) {
                Label label = this.items.get((int)i).label;
                float f3 = label.getLocalTranslation().x;
                f = label.getLocalTranslation().z;
                this.tempVec.set(f3, f2 - this.getHeight() * 0.5f, f);
                this.moveWidget(label, this.tempVec, bl);
                this.fadeWidget(label, MenuButton.noAlpha, bl);
                f2 += this.lineHeight;
                f2 += this.padding;
                this.items.get((int)i).visible = false;
                this.setMouseOverImageVisibility(this.items.get(i));
                this.updateSelectedImage(this.items.get(i));
            }
        }
        ColorRGBA colorRGBA = MenuButton.fullAlpha;
        f2 = this.getHeight() - this.topMargin;
        for (int i = this.position; i < this.items.size(); ++i) {
            Label label = this.items.get((int)i).label;
            f = label.getLocalTranslation().x;
            float f4 = label.getLocalTranslation().z;
            if (f2 <= this.bottomMargin) {
                colorRGBA = MenuButton.noAlpha;
            }
            this.tempVec.set(f, (f2 -= this.lineHeight + this.padding) - this.getHeight() * 0.5f, f4);
            this.moveWidget(label, this.tempVec, bl);
            this.fadeWidget(label, colorRGBA, bl);
            this.items.get((int)i).visible = colorRGBA != MenuButton.noAlpha;
            this.setMouseOverImageVisibility(this.items.get(i));
            this.updateSelectedImage(this.items.get(i));
        }
        this.updateScrollBar(this.getViewportSize());
    }

    private void setMouseOverImageVisibility(Item<E> item) {
        if (this.labelMouseIsOver == item.label) {
            if (item.visible) {
                this.mouseOverImage.getFader().fadeTo(this.mouseOverImageColor, this.fadeTime);
            } else {
                this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
            }
        }
    }

    private void updateSelectedImage(Item<E> item) {
        if (this.selectedItem == item) {
            this.onChangeSelectedItem(item);
        }
    }

    private void moveWidget(BaseWidget baseWidget, Vector3f vector3f, boolean bl) {
        if (!bl) {
            baseWidget.getMover().translateTo(vector3f, this.scrollTime, this.scrollTime);
        } else {
            baseWidget.getMover().setPosition(vector3f);
        }
    }

    private void fadeWidget(BaseWidget baseWidget, ColorRGBA colorRGBA, boolean bl) {
        if (!bl) {
            baseWidget.getFader().fadeTo(colorRGBA, this.fadeTime);
        } else if (colorRGBA == MenuButton.noAlpha) {
            this.detachChild(baseWidget.getSpatial());
        } else {
            this.attachChild(baseWidget.getSpatial());
        }
    }

    private ColorRGBA getColor(float f) {
        return this.tempColor;
    }

    public void addItem(E e) {
        this.addItem(e, this.items.size());
        this.positionLabels();
        this.setOrder(this.getOrder(), true);
    }

    public void addItems(E[] EArray) {
        for (E e : EArray) {
            this.addItem(e, this.items.size());
        }
        this.positionLabels();
        this.setOrder(this.getOrder(), true);
    }

    public void addItem(E e, int n) {
        String string = e.toString();
        Label label = new Label("ScrollableListLabel", string, this.getWidth() * 0.8f, this.lineHeight, this.fontFile, null);
        label.setTrimToWidth(true);
        this.addLabel(label, e, n);
        label.setHorisontalAlignment(this.horisontalAligment);
        label.getBoundingBox();
    }

    public void addLabel(Label label, E e) {
        this.addLabel(label, e, this.items.size());
    }

    public void addLabel(Label label, E e, int n) {
        Item item = new Item();
        item.label = label;
        item.visible = false;
        item.value = e;
        this.items.add(n, item);
        label.getMover().setDamping(this.scrollDamping);
        this.addWidget(label, new Vector2f(0.5f, 0.5f), true, true);
        label.setMouseOverListener(this.mouseOverLabelListener);
        this.update();
    }

    public boolean removeItem(E e) {
        Item<E> item = null;
        for (int i = 0; i < this.items.size(); ++i) {
            Item<E> item2 = this.items.get(i);
            if (item2.value == null || item2.value != e) continue;
            item = item2;
            break;
        }
        if (item != null) {
            this.remove(item);
            return true;
        }
        return false;
    }

    private void remove(Item<E> item) {
        this.removeWidget(item.label);
        item.label.setMouseOverListener(null);
        this.items.remove(item);
        if (this.selectedItem != null && this.selectedItem == item) {
            this.selectedItem = null;
            this.selectedImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
        }
        if (this.labelMouseIsOver != null && this.labelMouseIsOver == item.label) {
            this.labelMouseIsOver = null;
            this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
        }
        this.update();
    }

    public void addPosition(int n) {
        this.addPositionNoUpdate(n);
        this.update();
    }

    private void addPositionNoUpdate(int n) {
        this.position += n;
        if (this.position < 0) {
            this.position = 0;
        } else if (this.position >= this.items.size()) {
            this.position = this.items.size() - 1;
        }
    }

    public void onMouseOverLabel(Label label) {
        if (this.scrolling > Float.MIN_VALUE) {
            return;
        }
        if (label == null) {
            this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        } else {
            if (!this.items.get((int)this.indexOf((Label)label)).visible) {
                return;
            }
            label.getWorldBound().getCenter(this.tempVec);
            this.worldToLocal(this.tempVec, this.tempVec);
            float f = this.tempVec.y;
            Vector3f vector3f = this.getPositionInPanel(label, this.tempVec);
            if (vector3f != null) {
                vector3f.y = f;
                this.mouseOverImage.getMover().setPosition(vector3f);
                this.mouseOverImage.getFader().fadeTo(this.mouseOverImageColor, this.fadeTime);
            } else {
                this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
            }
            this.mouseOverImage.setSize(label.getWantedWidth(), label.getWantedHeight());
        }
        this.labelMouseIsOver = label;
    }

    private void onChangeSelectedItem(Item<E> item) {
        if (item == null) {
            this.selectedImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
        } else {
            Label label = item.label;
            label.getWorldBound().getCenter(this.tempVec);
            this.worldToLocal(this.tempVec, this.tempVec);
            float f = this.tempVec.y;
            Vector3f vector3f = this.getPositionInPanel(label, this.tempVec);
            if (vector3f != null) {
                vector3f.y = f;
                this.selectedImage.getMover().setPosition(vector3f);
                this.selectedImage.getFader().fadeTo(this.selectedImageColor, this.fadeTime);
            } else {
                this.selectedImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
            }
            this.selectedImage.setSize(label.getWantedWidth(), label.getWantedHeight());
        }
        if (this.getSelectionChangedListener() != null) {
            if (item != null) {
                this.getSelectionChangedListener().onSelectionChanged(this, item.getValue());
            } else {
                this.getSelectionChangedListener().onSelectionChanged(this, null);
            }
        }
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(float f) {
        this.bottomMargin = f;
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float f) {
        this.fadeTime = f;
    }

    public float getPadding() {
        return this.padding;
    }

    public void setPadding(float f) {
        this.padding = f;
    }

    public float getScrollTime() {
        return this.scrollTime;
    }

    public void setScrollTime(float f) {
        this.scrollTime = f;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(float f) {
        this.topMargin = f;
    }

    @Override
    public void updateWorldData(float f) {
        this.accScroll += this.scrolling * f;
        this.updateScrolling();
        this.checkKeyboard(f);
        super.updateWorldData(f);
    }

    private void updateScrolling() {
        if (this.accScroll <= -1.0f || this.accScroll >= 1.0f) {
            if (this.accScroll >= 1.0f) {
                this.accScroll = 0.0f;
                this.addPositionNoUpdate(1);
            } else if (this.accScroll <= 1.0f) {
                this.accScroll = 0.0f;
                this.addPositionNoUpdate(-1);
            }
            this.update();
        }
    }

    public HorisontalAlignment getHorisontalAligment() {
        return this.horisontalAligment;
    }

    public void setHorisontalAlignment(HorisontalAlignment horisontalAlignment) {
        if (!this.horisontalAligment.equals((Object)horisontalAlignment)) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get((int)i).label.setHorisontalAlignment(horisontalAlignment);
            }
        }
        this.horisontalAligment = this.horisontalAligment;
    }

    @Override
    public void onLeftMouseClicked(Vector3f vector3f) {
        Item<E> item = null;
        if (this.labelMouseIsOver != null && this.labelMouseIsOver.isInside(vector3f)) {
            item = this.items.get(this.indexOf(this.labelMouseIsOver));
            if (!item.visible) {
                item = null;
            }
        }
        if (item == null) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item<E> item2 = this.items.get(i);
                if (!item2.visible || !item2.label.isInside(vector3f)) continue;
                item = item2;
                break;
            }
        }
        this.selectedItem = item;
        this.onChangeSelectedItem(this.selectedItem);
    }

    @Override
    public void onLeftMouseDoubleClicked(Vector3f vector3f) {
        Item<E> item = null;
        if (this.labelMouseIsOver != null && this.labelMouseIsOver.isInside(vector3f)) {
            item = this.items.get(this.indexOf(this.labelMouseIsOver));
            if (!item.visible) {
                item = null;
            }
        }
        if (item == null) {
            for (int i = 0; i < this.items.size(); ++i) {
                Item<E> item2 = this.items.get(i);
                if (!item2.visible || !item2.label.isInside(vector3f)) continue;
                item = item2;
                break;
            }
        }
        if (this.selectedItem != item) {
            this.selectedItem = item;
            this.onChangeSelectedItem(this.selectedItem);
        } else if (this.selectedItem != null && this.simulateClickWidgetOnDoubleClick != null) {
            this.simulateClickWidgetOnDoubleClick.onLeftMouseClicked(vector3f);
        }
    }

    public IListSelectionChangedListener<E> getSelectionChangedListener() {
        return this.selectionChangedListener;
    }

    public void setSelectionChangedListener(IListSelectionChangedListener iListSelectionChangedListener) {
        this.selectionChangedListener = iListSelectionChangedListener;
    }

    private int getSelectedIndex() {
        return this.items.indexOf(this.selectedItem);
    }

    private void setSelectedIndex(int n) {
        if (this.items.size() <= 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.items.size()) {
            n = this.items.size() - 1;
        }
        this.selectedItem = this.items.get(n);
    }

    public void setSelectedItem(E e) {
        if (e == null) {
            this.selectedItem = null;
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            Item<E> item = this.items.get(i);
            if (!item.value.equals(e)) continue;
            this.selectedItem = item;
            this.scrollWithSelection(this.getSelectedIndex(), false);
            return;
        }
    }

    public void scrollToSelection() {
        this.scrollWithSelection(this.getSelectedIndex(), false);
    }

    private void scrollWithSelection(int n, boolean bl) {
        int n2 = bl ? -1 : 1;
        int n3 = this.position;
        Vector3f vector3f = this.getPositionInPanel(n, this.tempVec);
        while (vector3f == null && this.position >= 0 && this.position < this.items.size()) {
            this.position += n2;
            vector3f = this.getPositionInPanel(n, this.tempVec);
        }
        if (vector3f == null) {
            n2 = -n2;
            while (vector3f == null && this.position >= 0 && this.position < this.items.size()) {
                this.position += n2;
                vector3f = this.getPositionInPanel(n, this.tempVec);
            }
        }
        if (vector3f == null) {
            this.position = n3;
        }
        this.update();
    }

    private void selectPrevious() {
        this.setSelectedIndex(this.getSelectedIndex() - 1);
        this.scrollWithSelection(this.getSelectedIndex(), true);
    }

    private void selectNext() {
        this.setSelectedIndex(this.getSelectedIndex() + 1);
        this.scrollWithSelection(this.getSelectedIndex(), false);
    }

    @Override
    public boolean onKeyDown(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 200: {
                if (this.selectedItem != null) {
                    this.selectPrevious();
                } else {
                    this.setSelectedIndex(this.position);
                }
                bl = true;
                break;
            }
            case 208: {
                if (this.selectedItem != null) {
                    this.selectNext();
                } else {
                    this.setSelectedIndex(this.position);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean onKeyTyped(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 28: 
            case 57: 
            case 156: {
                if (this.selectedItem != null && this.simulateClickWidgetOnDoubleClick != null) {
                    this.simulateClickWidgetOnDoubleClick.onLeftMouseClicked(this.simulateClickWidgetOnDoubleClick.getSpatial().getWorldTranslation().clone());
                }
                bl = true;
            }
        }
        return bl;
    }

    public void clear() {
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get((int)i).label.setMouseOverListener(null);
            this.removeWidget(this.items.get((int)i).label);
        }
        this.items.clear();
        this.selectedItem = null;
        this.labelMouseIsOver = null;
        this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
        this.selectedImage.getFader().fadeTo(MenuButton.noAlpha, this.fadeTime);
        this.position = 0;
        this.scrolling = 0.0f;
        this.accScroll = 0.0f;
    }

    public E getSelected() {
        if (this.selectedItem != null) {
            return (E)this.selectedItem.value;
        }
        return null;
    }

    @Override
    public void setSize(float f, float f2) {
        this.bottomMargin -= this.lineHeight;
        this.lineHeight *= f2 / this.getHeight();
        this.bottomMargin += this.lineHeight;
        super.setSize(f, f2);
        for (int i = 0; i < this.items.size(); ++i) {
            Item<E> item = this.items.get(i);
            item.label.setSize(this.getWidth() * 0.8f, this.lineHeight);
        }
        if (this.scrollBar != null) {
            this.scrollBar.setSize(14.0f, f2);
            this.scrollBar.setPosition(new Vector2f(f * 0.5f * 0.9f, 0.0f));
        }
        this.calculatePositions(true);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean bl) {
        this.smoothScrolling = bl;
    }

    public float getKeyRepeatInterval() {
        return this.keyRepeatInterval;
    }

    public void setKeyRepeatInterval(float f) {
        this.keyRepeatInterval = f;
    }

    public float getKeyRepeatStartInterval() {
        return this.keyRepeatStartInterval;
    }

    public void setKeyRepeatStartInterval(float f) {
        this.keyRepeatStartInterval = f;
    }

    public E[] getItems(E[] objectArray) {
        if (objectArray.length < this.items.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.items.size());
        }
        for (int i = 0; i < this.items.size(); ++i) {
            objectArray[i] = this.items.get((int)i).value;
        }
        if (objectArray.length > this.items.size()) {
            objectArray[this.items.size()] = null;
        }
        return objectArray;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setSimulateClickWidgetOnDoubleClick(IWidget iWidget) {
        this.simulateClickWidgetOnDoubleClick = iWidget;
    }

    public class DetachWhenDoneFadingListener
    implements IControllerListener {
        public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
            ScrollableLabelList.this.detachChild(abstractSpatialController.getSpatial());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Item<T> {
        Label label;
        T value;
        boolean visible;

        private Item() {
        }

        public Label getLabel() {
            return this.label;
        }

        public void setLabel(Label label) {
            this.label = label;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T t) {
            this.value = t;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public String toString() {
            return this.label.getText() + " : " + this.value.toString();
        }
    }
}

