/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.minimap;

import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.geom.BufferUtils;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.Border;
import com.turborilla.msm.gui.turbogui.listeners.ILeftMouseDownListener;
import com.turborilla.msm.gui.turbogui.listeners.IRightMouseDownListener;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.ImageUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class MiniMap
extends BaseWidget
implements IResizableWidget {
    private int maxTextureWidth = 512;
    private float width;
    private float height;
    private int sections = 0;
    private Node node;
    private Quad[] quads;
    private TextureState[] textureStates;
    private ColorRGBA groundColor = new ColorRGBA(0.68235296f, 0.48235294f, 0.15294118f, 1.0f);
    private ColorRGBA skyColor = new ColorRGBA(0.59607846f, 0.8117647f, 0.9529412f, 1.0f);
    protected ILeftMouseDownListener leftMouseDownListener;
    protected IRightMouseDownListener rightMouseDownListener;
    private ByteBuffer tempData;
    private Image[] tempImages;

    public MiniMap(String string, float f, float f2, int n) {
        super(string);
        this.maxTextureWidth = n;
        this.width = f;
        this.height = f2;
        this.node = new Node();
        this.attachChild(this.node);
        this.init(f, f2, n);
        this.setActivatable(true);
        this.setFocusable(false);
    }

    private void init(float f, float f2, int n) {
        this.sections = (int)(f / (float)n);
        if (f / (float)n - (float)this.sections > 0.0f) {
            ++this.sections;
        }
        this.node.detachAllChildren();
        Border border = new Border("corner", "edge", "combobox");
        border.construct(f + 8.0f, f2 + 8.0f, 0.1f);
        this.node.attachChild(border);
        this.quads = new Quad[this.sections];
        this.textureStates = new TextureState[this.sections];
        for (int i = 0; i < this.sections; ++i) {
            float f3 = i != this.sections - 1 ? (float)n : f % (float)n;
            Quad quad = new Quad(this.getName() + ":Quad" + i, f3, f2);
            TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
            textureState.setEnabled(false);
            quad.setRenderState(textureState);
            quad.setLocalTranslation(-f * 0.5f + (float)(i * n) + f3 * 0.5f, 0.0f, 0.0f);
            this.node.attachChild(quad);
            this.quads[i] = quad;
            this.textureStates[i] = textureState;
        }
    }

    public void update(ImageHeightMap imageHeightMap, int n, int n2) {
        int n3 = imageHeightMap.getXsize();
        int n4 = (int)this.width;
        int n5 = (int)this.height;
        double d = (double)n3 / (double)this.width;
        boolean[] blArray = new boolean[n4];
        for (int i = 0; i < n4; ++i) {
            blArray[i] = true;
        }
        double d2 = 1.0 / ((double)(n - n2) / (double)this.height);
        byte[] byArray = new byte[]{ImageUtils.floatToUnsignedByte(this.groundColor.r * 255.0f), ImageUtils.floatToUnsignedByte(this.groundColor.g * 255.0f), ImageUtils.floatToUnsignedByte(this.groundColor.b * 255.0f), ImageUtils.floatToUnsignedByte(this.groundColor.a * 255.0f)};
        byte[] byArray2 = new byte[]{ImageUtils.floatToUnsignedByte(this.skyColor.r * 255.0f), ImageUtils.floatToUnsignedByte(this.skyColor.g * 255.0f), ImageUtils.floatToUnsignedByte(this.skyColor.b * 255.0f), ImageUtils.floatToUnsignedByte(this.skyColor.a * 255.0f)};
        byte[] byArray3 = new byte[4];
        this.tempData = BufferUtils.createByteBuffer(this.tempData, 4 * n4 * n5);
        this.tempData.clear();
        double d3 = this.height;
        for (int i = 0; i < n5; ++i) {
            double d4 = i;
            double d5 = (double)n2 + d4 / d3 * (double)(n - n2);
            for (int j = 0; j < n4; ++j) {
                int n6;
                double d6;
                double d7;
                if (!blArray[j]) {
                    this.tempData.put(byArray2);
                    continue;
                }
                if (d >= 1.0) {
                    d7 = (double)imageHeightMap.getTrueHeightAtPoint((int)((double)j * d), 0) - d5;
                } else {
                    d6 = (double)j * d;
                    n6 = (int)d6;
                    double d8 = d6 - (double)n6;
                    double d9 = imageHeightMap.getTrueHeightAtPoint(n6, 0);
                    if (n6 >= imageHeightMap.getXsize() - 1) {
                        d7 = d9 - d5;
                    } else {
                        double d10 = imageHeightMap.getTrueHeightAtPoint(n6 + 1, 0);
                        d7 = d9 + (d10 - d9) * d8 - d5;
                    }
                }
                if (d7 > 0.0) {
                    this.tempData.put(byArray);
                    continue;
                }
                blArray[j] = false;
                d6 = -d7 * d2;
                if (d6 > 1.0) {
                    d6 = 1.0;
                }
                for (n6 = 0; n6 < 3; ++n6) {
                    float f = (float)(d6 * (double)ImageUtils.unsignedByteToInt(byArray2[n6]) + (1.0 - d6) * (double)ImageUtils.unsignedByteToInt(byArray[n6]));
                    if (f > 255.0f) {
                        f = 255.0f;
                    }
                    byArray3[n6] = ImageUtils.floatToUnsignedByte(f);
                }
                byArray3[3] = ImageUtils.floatToUnsignedByte(255.0f);
                this.tempData.put(byArray3);
            }
        }
        this.tempData.flip();
        Image image = new Image(3, n4, n5, this.tempData);
        this.tempImages = ImageUtils.split(image, this.maxTextureWidth, ImageUtils.getNextPowerOfTwo(n5), true, this.tempImages);
        for (int i = 0; i < this.tempImages.length; ++i) {
            this.textureStates[i].deleteAll(true);
            Texture texture = ImageUtils.loadTexture(this.tempImages[i], 0, 0, false);
            this.textureStates[i].setEnabled(true);
            this.textureStates[i].setTexture(texture);
            this.textureStates[i].needsRefresh();
            this.quads[i].updateRenderState();
            FloatBuffer floatBuffer = this.quads[i].getTextureBuffer(0, 0);
            float f = (float)n5 / (float)ImageUtils.getNextPowerOfTwo(n5);
            floatBuffer.clear();
            floatBuffer.put(0.0f).put(f);
            floatBuffer.put(0.0f).put(0.0f);
            floatBuffer.put(1.0f).put(0.0f);
            floatBuffer.put(1.0f).put(f);
            floatBuffer.flip();
            if (i != this.tempImages.length - 1) continue;
            float f2 = (float)(n4 - this.maxTextureWidth * i) / (float)this.maxTextureWidth;
            floatBuffer.put(4, f2);
            floatBuffer.put(6, f2);
        }
        this.updateRenderState();
        this.updateGeometricState(0.0f, true);
    }

    public ILeftMouseDownListener getLeftMouseDownListener() {
        return this.leftMouseDownListener;
    }

    public void setLeftMouseDownListener(ILeftMouseDownListener iLeftMouseDownListener) {
        this.leftMouseDownListener = iLeftMouseDownListener;
    }

    public IRightMouseDownListener getRightMouseDownListener() {
        return this.rightMouseDownListener;
    }

    public void setRightMouseDownListener(IRightMouseDownListener iRightMouseDownListener) {
        this.rightMouseDownListener = iRightMouseDownListener;
    }

    public void onLeftMouseDown(Vector3f vector3f) {
        if (this.leftMouseDownListener != null) {
            this.leftMouseDownListener.onLeftMouseDown(this, vector3f);
        }
    }

    public void onRightMouseClicked(Vector3f vector3f) {
        if (this.rightMouseDownListener != null) {
            this.rightMouseDownListener.onRightMouseDown(this, vector3f);
        }
    }

    public void onMouseMove(Vector3f vector3f, boolean bl) {
        if (this.isActive()) {
            this.onLeftMouseDown(vector3f);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.init(f, f2, this.maxTextureWidth);
    }
}

