/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui.checkbox;

import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.turborilla.gui.HorisontalAlignment;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.Image;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.gui.turbogui.listeners.ICheckBoxChanged;
import com.turborilla.msm.gui.turbogui.menubutton.MenuButton;

public class CheckBox
extends BaseWidget
implements IResizableWidget {
    private float height;
    private float width;
    private String text;
    private Label label;
    private Image normalImage;
    private Image mouseOverImage;
    private Image checkedImage;
    private boolean textOnTheRight = true;
    private float labelMargin = 0.3f;
    private boolean checked = false;
    private boolean uncheckable = true;
    private static ColorRGBA disabled = new ColorRGBA(0.3f, 0.3f, 0.3f, 1.0f);
    private ICheckBoxChanged checkedListener;

    public CheckBox(String string, float f, float f2, String string2, boolean bl) {
        this(string, f, f2, string2, bl, 0.3f);
    }

    public CheckBox(String string, float f, float f2, String string2, boolean bl, float f3) {
        super(string);
        this.width = f;
        this.height = f2;
        this.text = string2;
        this.textOnTheRight = bl;
        this.labelMargin = f3;
        this.setActivatable(true);
        this.setFocusable(true);
        this.normalImage = new Image("CheckBoxNormalImage", "checkbuttonnormal", f2);
        this.normalImage.getFader().initRenderStates();
        this.normalImage.getFader().setColor(MenuButton.fullAlpha);
        this.mouseOverImage = new Image("CheckBoxMouseOverImage", "checkbuttonover", f2);
        this.mouseOverImage.getFader().initRenderStates();
        this.mouseOverImage.getFader().setColor(MenuButton.noAlpha);
        this.checkedImage = new Image("CheckBoxCheckedImage", "checkbuttonchecked", f2);
        this.checkedImage.getFader().initRenderStates();
        this.checkedImage.getFader().setColor(MenuButton.noAlpha);
        this.label = new Label("CheckBoxLabel", string2, f - f2, f2, "menufont", null);
        this.addLayer(this.normalImage);
        this.addLayer(this.mouseOverImage);
        this.addLayer(this.checkedImage);
        this.addLayer(this.label);
        this.layout();
    }

    private void layout() {
        this.normalImage.setSize(this.height, this.height);
        this.mouseOverImage.setSize(this.height, this.height);
        this.checkedImage.setSize(this.height, this.height);
        this.label.setSize(this.width - this.height, this.height);
        Vector2f vector2f = new Vector2f();
        if (this.textOnTheRight) {
            vector2f.set(-(this.width * 0.5f) + this.height * 0.5f, 0.5f);
            this.normalImage.setPosition(vector2f);
            this.mouseOverImage.setPosition(vector2f);
            this.checkedImage.setPosition(vector2f);
            vector2f.set(-(this.width * 0.5f) + (this.width - this.height) * 0.5f + this.height + this.height * this.labelMargin, 0.5f);
            this.label.setPosition(vector2f);
            this.label.setHorisontalAlignment(HorisontalAlignment.LEFT);
        } else {
            vector2f.set(this.width * 0.5f - this.height * 0.5f, 0.5f);
            this.normalImage.setPosition(vector2f);
            this.mouseOverImage.setPosition(vector2f);
            this.checkedImage.setPosition(vector2f);
            vector2f.set(this.width * 0.5f - (this.width - this.height) * 0.5f - this.height - this.height * this.labelMargin, 0.5f);
            this.label.setPosition(vector2f);
            this.label.setHorisontalAlignment(HorisontalAlignment.RIGHT);
        }
    }

    public void setSize(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.layout();
        this.updateLook();
    }

    private void updateLook() {
        if (this.isEnabled()) {
            this.label.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            if (this.isMouseOver() || this.isFocused()) {
                this.mouseOverImage.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            } else {
                this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            }
            if (this.isChecked()) {
                this.checkedImage.getFader().fadeTo(MenuButton.fullAlpha, MenuButton.fadeTime);
            } else {
                this.checkedImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            }
        } else {
            this.label.getFader().fadeTo(disabled, MenuButton.fadeTime);
            this.normalImage.getFader().fadeTo(disabled, MenuButton.fadeTime);
            this.mouseOverImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            if (this.isChecked()) {
                this.checkedImage.getFader().fadeTo(disabled, MenuButton.fadeTime);
            } else {
                this.checkedImage.getFader().fadeTo(MenuButton.noAlpha, MenuButton.fadeTime);
            }
        }
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
        this.updateLook();
    }

    public void toggleChecked() {
        if (this.checked && !this.isUncheckable()) {
            return;
        }
        this.checked = !this.checked;
        this.updateLook();
        this.fireCheckBoxChanged();
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void onBlur() {
        this.updateLook();
    }

    public void onFocus() {
        this.updateLook();
    }

    public boolean onKeyTyped(int n, char c) {
        boolean bl = false;
        switch (n) {
            case 28: 
            case 57: 
            case 156: {
                this.toggleChecked();
                bl = true;
            }
        }
        return bl;
    }

    public void onLeftMouseClicked(Vector3f vector3f) {
        this.toggleChecked();
    }

    public void onMouseOut() {
        this.updateLook();
    }

    public void onMouseOver(boolean bl) {
        this.updateLook();
    }

    public ICheckBoxChanged getCheckedListener() {
        return this.checkedListener;
    }

    public void setCheckedListener(ICheckBoxChanged iCheckBoxChanged) {
        this.checkedListener = iCheckBoxChanged;
    }

    public boolean isUncheckable() {
        return this.uncheckable;
    }

    public void fireCheckBoxChanged() {
        if (this.checkedListener != null) {
            this.checkedListener.onCheckBoxChanged(this, this.checked);
        }
    }

    public void setUncheckable(boolean bl) {
        this.uncheckable = bl;
    }
}

