/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui;

import com.jme.bounding.BoundingBox;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.components.ManySpatialsComponent;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.skin.Skin;
import com.turborilla.utils.math.Vector3d;

public class SkinWidget
extends BaseWidget
implements IResizableWidget {
    private Bike bikeParticleSystem;
    private ManySpatialsComponent bikeComp;
    private ManySpatialsComponent riderComp;
    private Node skinNode;
    private Vector3f temp = new Vector3f();

    public SkinWidget(String string) {
        super(string);
        this.skinNode = new Node(string + ":skinNode");
        this.attachChild(this.skinNode);
        this.bikeParticleSystem = new Bike(null, new Vector3d(-2.0, -2.0, 0.0), 0.03f, 0.03f, 0.03f, null, 0, null, null);
        this.bikeParticleSystem.reset(new Vector3d());
        this.bikeParticleSystem.updateParticleSystemOnly(0.016667f);
        this.bikeComp = new ManySpatialsComponent("BikeSkinSpatialComponent");
        this.skinNode.attachChild(this.bikeComp.getNode());
        this.riderComp = new ManySpatialsComponent("RiderSkinSpatialComponent");
        this.skinNode.attachChild(this.riderComp.getNode());
        this.skinNode.setModelBound(new BoundingBox());
        this.skinNode.updateModelBound();
        this.skinNode.updateWorldBound();
    }

    public void setSkin(Skin skin, Skin skin2) {
        skin.apply(this.bikeParticleSystem, this.bikeComp);
        skin2.apply(this.bikeParticleSystem, this.riderComp);
        this.bikeComp.update(0.016667f);
        this.riderComp.update(0.016667f);
    }

    public void setSize(float f, float f2) {
        this.skinNode.setLocalScale(1.0f);
        this.skinNode.updateWorldBound();
        this.skinNode.updateGeometricState(0.0f, true);
        BoundingBox boundingBox = (BoundingBox)this.skinNode.getWorldBound();
        float f3 = f2 / (boundingBox.yExtent * 2.0f);
        this.temp.set(f3, f3, 0.001f);
        this.skinNode.getLocalScale().set(this.temp);
        this.skinNode.setLocalTranslation(-boundingBox.xExtent, 0.0f, this.skinNode.getLocalTranslation().z);
    }

    public Node getSkinNode() {
        return this.skinNode;
    }
}

