/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui;

import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.export.Savable;
import com.turborilla.gui.Label;
import com.turborilla.msm.gui.turbogui.Border;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.utils.Font;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialTranslationController;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class InRaceLabel
extends Label {
    private Border background;
    private Node backgroundImage;
    private float height;
    private boolean onLeft = true;
    private float slideTime = 1.2f;
    private float slideDamping = 0.3f;
    private SpatialTranslationController mover;
    private boolean showing = false;
    private float yPosition;
    private Vector3f to = new Vector3f();
    private float backgroundWidth;
    private IControllerListener notShowingWhenDone;
    private float showForSeconds;
    private Node attachToParent;

    public InRaceLabel(Font font, int n, float f, float f2, String string) {
        super(font, n);
        String string2 = "";
        for (int i = 0; i < n + 2; ++i) {
            string2 = string2 + "W";
        }
        this.init(f, f2, string2, string);
    }

    public InRaceLabel(String string, Font font, int n, float f, float f2, String string2) {
        super(string, font, n);
        String string3 = "";
        for (int i = 0; i < n + 2; ++i) {
            string3 = string3 + "W";
        }
        this.init(f, f2, string3, string2);
    }

    public InRaceLabel(String string, Font font, int n, float f, float f2, String string2, String string3) {
        super(string, font, n);
        this.init(f, f2, string2, string3);
    }

    private void init(float f, float f2, String string, String string2) {
        Savable savable;
        this.height = f;
        this.yPosition = f2;
        this.backgroundWidth = this.font.getWidth(string);
        if (string2 == null) {
            this.background = new Border("transparent_corner", "transparent_edge", "transparent_fill");
            this.attachChild(this.background);
            this.background.setLocalTranslation(0.0f, (float)this.font.getBase() * 0.5f, 0.0f);
        } else {
            savable = null;
            try {
                Properties properties = new Properties();
                properties.setProperty("textureMinFilter", "5");
                properties.setProperty("textureMagFilter", "1");
                savable = (Texture)ResourceManager.getInstance().load("texture", string2, properties);
                Quad quad = new Quad("inracelabelbackground", (float)((Texture)savable).getImage().getWidth() / (float)((Texture)savable).getImage().getHeight(), 1.0f);
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setEnabled(true);
                textureState.setTexture((Texture)savable);
                quad.setRenderState(textureState);
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setEnabled(true);
                alphaState.setBlendEnabled(true);
                alphaState.setSrcFunction(4);
                alphaState.setDstFunction(5);
                quad.setRenderState(alphaState);
                quad.updateRenderState();
                this.backgroundImage = new Node("inracelabelbackgroundnode");
                this.backgroundImage.attachChild(quad);
                this.attachChild(this.backgroundImage);
                this.backgroundImage.setLocalTranslation(0.0f, (float)this.font.getBase() * 0.5f, 0.0f);
                this.backgroundImage.setLocalScale((float)this.font.getLineHeight() * 1.4f);
            }
            catch (IOException iOException) {
                Logger.getLogger(Border.class.getCanonicalName()).severe("" + iOException);
            }
        }
        this.newDisplaySize();
        this.mover = new SpatialTranslationController(this);
        this.to.set(-this.backgroundWidth * this.getLocalScale().x * 0.8f, this.getLocalTranslation().y, this.getLocalTranslation().z);
        this.mover.setPosition(this.to);
        this.mover.setDamping(this.slideDamping);
        this.notShowingWhenDone = new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                InRaceLabel.this.showing = false;
                if (abstractSpatialController.getSpatial().getParent() != null) {
                    InRaceLabel.this.attachToParent = abstractSpatialController.getSpatial().getParent();
                    InRaceLabel.this.attachToParent.detachChild(abstractSpatialController.getSpatial());
                }
            }
        };
        this.setLightCombineMode(0);
        savable = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        ((AlphaState)savable).setBlendEnabled(true);
        ((AlphaState)savable).setSrcFunction(4);
        ((AlphaState)savable).setDstFunction(5);
        this.setRenderState((RenderState)savable);
        this.updateRenderState();
    }

    public void show(float f) {
        this.showing = true;
        if (this.getParent() == null && this.attachToParent != null) {
            this.attachToParent.attachChild(this);
            this.attachToParent.updateRenderState();
        }
        this.to.x = this.backgroundWidth / 2.0f * this.getLocalScale().x;
        this.to.y = this.getLocalTranslation().y;
        this.mover.clearListeners();
        this.mover.translateTo(this.to, this.slideTime, this.slideTime);
        this.updateAtInterval(0.16f);
        this.showForSeconds = f;
    }

    public void hide() {
        if (!this.showing) {
            return;
        }
        this.to.x = -this.backgroundWidth * this.getLocalScale().x;
        this.to.y = this.getLocalTranslation().y;
        this.mover.clearListeners();
        this.mover.translateTo(this.to, this.slideTime, this.slideTime);
        this.mover.add(this.notShowingWhenDone);
    }

    protected void update(float f) {
        if (this.showing) {
            super.update(f);
            this.showForSeconds -= f;
            if (this.showForSeconds < 0.0f) {
                this.showForSeconds = Float.MAX_VALUE;
                this.hide();
            }
        }
    }

    public void setZOrder(int n, boolean bl) {
        super.setZOrder(n, bl);
        if (bl && this.background != null) {
            this.background.setZOrder(this.getZOrder() + 1, true);
        }
        if (bl && this.backgroundImage != null) {
            this.backgroundImage.setZOrder(this.getZOrder() + 1, true);
        }
    }

    public void newDisplaySize() {
        float f = this.height * (float)DisplaySystem.getDisplaySystem().getHeight() / (float)this.font.getLineHeight();
        float f2 = (float)DisplaySystem.getDisplaySystem().getHeight() / 1024.0f;
        this.setLocalScale(f);
        if (this.background != null) {
            this.background.construct(this.backgroundWidth * f, (float)this.font.getLineHeight() * 1.2f * f, f2);
            this.background.setLocalScale(1.0f / f);
            this.background.setZOrder(this.getZOrder() + 1, true);
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.setZOrder(this.getZOrder() + 1, true);
        }
        if (!this.showing) {
            this.getLocalTranslation().y = this.yPosition * (float)DisplaySystem.getDisplaySystem().getHeight();
        } else {
            this.to.y = this.yPosition * (float)DisplaySystem.getDisplaySystem().getHeight();
            this.mover.addTranslationToQueue(this.to, this.slideTime * 0.1f, this.slideTime);
        }
    }

    private void align() {
        if (this.onLeft) {
            this.rightAlign(this.backgroundWidth * this.getLocalScale().x);
        } else {
            this.leftAlign(this.backgroundWidth * this.getLocalScale().x);
        }
    }

    public void setText(char c) {
        super.setText(c);
        this.align();
    }

    public void setText(double d) {
        super.setText(d);
        this.align();
    }

    public void setText(float f) {
        super.setText(f);
        this.align();
    }

    public void setText(int n) {
        super.setText(n);
        this.align();
    }

    public void setText(long l) {
        super.setText(l);
        this.align();
    }

    public void setText(short s) {
        super.setText(s);
        this.align();
    }

    public void setText(String string) {
        super.setText(string);
        this.align();
    }

    public Node getAttachToParent() {
        return this.attachToParent;
    }

    public void setAttachToParent(Node node) {
        this.attachToParent = node;
    }

    public Node getBackgroundImage() {
        return this.backgroundImage;
    }
}

