/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gui.turbogui;

import com.jme.image.Texture;
import com.jme.scene.Geometry;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.turborilla.gui.widget.BaseWidget;
import com.turborilla.gui.widget.utils.IResizableWidget;
import com.turborilla.msm.gui.turbogui.label.Label;
import com.turborilla.msm.loaders.ResourceManager;
import java.io.IOException;
import java.util.logging.Logger;

public class Image
extends BaseWidget
implements IResizableWidget {
    private String backgroundFile = null;
    private float wantedSize = -1.0f;
    private Geometry imageGeom = null;
    private Texture texture;
    private float texWidth;
    private float texHeight;
    private Quad quad;
    private boolean restrictHeight = false;

    public Image(String string) {
        super(string);
    }

    public Image(String string, String string2, float f) {
        this(string, string2, f, false);
    }

    public Image(String string, String string2, float f, boolean bl) {
        super(string);
        this.wantedSize = f;
        this.setImage(string2);
        this.restrictHeight = bl;
    }

    public void setImage(String string) {
        this.backgroundFile = string;
        if (this.imageGeom != null) {
            this.detachChild(this.imageGeom);
        }
        if (this.backgroundFile != null) {
            try {
                float f;
                float f2;
                this.texture = (Texture)ResourceManager.getInstance().load("texture", this.backgroundFile, this.getLoaderProperties());
                this.texWidth = this.texture.getImage().getWidth();
                this.texHeight = this.texture.getImage().getHeight();
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                textureState.setTexture(this.texture);
                if (this.restrictHeight) {
                    if (this.wantedSize <= 0.0f) {
                        this.wantedSize = this.texWidth;
                        f2 = this.texHeight;
                    } else {
                        f2 = this.wantedSize * this.texHeight / this.texWidth;
                    }
                    f = this.wantedSize;
                } else {
                    if (this.wantedSize <= 0.0f) {
                        this.wantedSize = this.texHeight;
                        f = this.texWidth;
                    } else {
                        f = this.wantedSize * this.texWidth / this.texHeight;
                    }
                    f2 = this.wantedSize;
                }
                this.quad = new Quad(this.getName() + ":quad", f, f2);
                this.quad.setRenderState(textureState);
                this.attachChild(this.quad);
                this.imageGeom = this.quad;
                this.updateRenderState();
            }
            catch (IOException iOException) {
                Logger.getLogger(Label.class.getName()).severe("Could not create Image. Exception: " + iOException);
            }
        }
    }

    public void setSize(float f, float f2) {
        if (this.restrictHeight) {
            this.wantedSize = f2;
            if (this.texture != null) {
                f = this.wantedSize * this.texWidth / this.texHeight;
            }
            if (this.quad != null) {
                this.quad.resize(f, this.wantedSize);
            }
        } else {
            this.wantedSize = f;
            if (this.texture != null) {
                f2 = this.wantedSize * this.texHeight / this.texWidth;
            }
            if (this.quad != null) {
                this.quad.resize(this.wantedSize, f2);
            }
        }
    }

    public boolean isRestrictHeight() {
        return this.restrictHeight;
    }

    public void setRestrictHeight(boolean bl) {
        this.restrictHeight = bl;
        this.setSize(this.getWidth(), this.getHeight());
    }
}

