/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.image.Texture;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.track.Track1D;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.terrain.ImageHeightMap;
import com.turborilla.utils.Material;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class TrackGameObject
extends GameObject {
    protected Track1D track;
    protected Node node;
    protected Node parentNode;
    protected CollisionStructure collisionStructure;
    protected TriMesh grass;

    public TrackGameObject() {
        super("trackGameObject");
    }

    public boolean init(Node node, Properties properties) {
        Object object;
        if (this.node != null) {
            this.node.unlock();
            this.parentNode.detachChild(this.node);
            this.node.detachAllChildren();
        }
        this.node = new Node("trackGameObject:node");
        this.parentNode = node;
        Track1D track1D = null;
        try {
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("putInCache", "false");
            properties.put("lookInCache", "false");
            track1D = (Track1D)ResourceManager.getInstance().load("track1D", properties.getProperty("track", "empty"), properties);
            if (this.track != null && track1D != null) {
                this.track.getStepScale().set(track1D.getStepScale());
                this.track.setName(track1D.getName());
                this.track.setRenderState(track1D.getRenderState(6));
                this.track.setRenderState(track1D.getRenderState(4));
                this.track.setChallenges(track1D.getChallenges());
            } else {
                this.track = track1D;
            }
            this.track.reconstruct(track1D.getOriginalHeightMap(), track1D.getOriginalFeatureMap(), Integer.parseInt(properties.getProperty("numberOfLaps", "1")));
        }
        catch (IOException iOException) {
            Logger.getLogger(TrackGameObject.class.getName()).severe("Could not load track: " + properties.getProperty("track", "empty"));
        }
        if (track1D == null) {
            try {
                object = (Material)ResourceManager.getInstance().load("material", properties.getProperty("environment", "tiki"), properties);
                ImageHeightMap imageHeightMap = new ImageHeightMap();
                ImageHeightMap imageHeightMap2 = new ImageHeightMap();
                int[] nArray = new int[120];
                int[] nArray2 = new int[nArray.length];
                imageHeightMap.setHeightData(nArray, nArray.length, 1);
                imageHeightMap2.setHeightData(nArray2, nArray2.length, 1);
                Vector3f vector3f = new Vector3f(1.8f, 0.025f, 1.0f);
                if (this.track != null) {
                    this.track.reconstruct(imageHeightMap, imageHeightMap2);
                } else {
                    this.track = new Track1D("empty", imageHeightMap, imageHeightMap2, vector3f, new Vector2f(), 0, new Vector2f(1.0f, 1.0f));
                }
                this.track.setName("empty");
                TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
                Texture texture = null;
                if (object != null && ((Material)object).getTexture() != null) {
                    texture = ((Material)object).getTexture();
                    texture.setWrap(3);
                    textureState.setTexture(texture);
                }
                textureState.setEnabled(true);
                this.track.setRenderState(textureState);
            }
            catch (IOException iOException) {
                Logger.getLogger(TrackGameObject.class.getName()).severe("Could not create default track. Exception: " + iOException);
                throw new MsmGameStateException(iOException);
            }
        }
        object = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        ((RenderState)object).setEnabled(true);
        ((ZBufferState)object).setFunction(7);
        ((ZBufferState)object).setWritable(false);
        this.track.setRenderState((RenderState)object);
        this.node.attachChild(this.track);
        this.node.attachChild(this.track.getNotShadowedNode());
        this.node.attachChild(this.track.getOtherMeshes());
        node.attachChild(this.node);
        this.node.updateRenderState();
        this.collisionStructure = this.track.reconstructCollisionStructure(this.collisionStructure);
        this.collisionStructure.setTransformationProvider(null);
        this.node.lock();
        this.track.lock();
        return true;
    }

    public CollisionStructure getCollisionStructure() {
        return this.collisionStructure;
    }

    public Track1D getTrack() {
        return this.track;
    }

    public TriMesh getGrass() {
        return this.grass;
    }
}

