/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Disk;
import com.jme.scene.shape.Quad;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryImporter;
import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.GameObject;
import com.turborilla.msm.components.ManySpatialsComponent;
import com.turborilla.msm.components.ParticleSystemComponent;
import com.turborilla.msm.components.ReplayComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.models.BikeWheelShadowMesh;
import com.turborilla.msm.physics.collision.ParticleObjectEffectCollisionSpray;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.replay.ReplayDataCollisionSpray;
import com.turborilla.msm.replay.ReplayDataTransformation;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.ParticleEffectsSystem;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.replay.nioreplay.NioReplay;
import com.turborilla.utils.math.Vector3d;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReplayBikeGameObject
extends GameObject {
    private static final Logger logger = Logger.getLogger(ReplayBikeGameObject.class.getName());
    private Node parentNode;
    private Node shadowOccluders;
    private Node effectsNode;
    private NioReplay replay;
    private ReplayDataCollisionSpray replayDataSpray = null;
    private ReplayComponent replayComp;
    private ManySpatialsComponent mspComp;
    private ArrayList<TransformationProvider> providers = null;
    private ParticleSystemComponent effectsComp;
    private ParticleEffectsSystem effectsSystem;

    public ReplayBikeGameObject(String string, Node node, Node node2, Node node3) {
        super(string);
        this.parentNode = node;
        this.shadowOccluders = node2;
        this.effectsNode = node3;
        this.replay = null;
        this.mspComp = new ManySpatialsComponent(this.getName() + ":ManySpatialsComponent");
        this.addComponent(this.mspComp);
        this.effectsSystem = new ParticleEffectsSystem(this.getName() + ":effectsSystem");
        node3.attachChild(this.effectsSystem.getNode());
        this.effectsComp = new ParticleSystemComponent(this.getName() + ":effectsComp", this.effectsSystem);
        this.addComponent(this.effectsComp);
        node2.attachChild(this.mspComp.getNode());
        this.replayComp = new ReplayComponent(this.getName() + ":replayComponent");
        this.addComponent(this.replayComp);
    }

    public void startReplay(String string, String string2) throws FileNotFoundException, IOException {
        if (this.providers == null) {
            logger.severe("Cannot start the replay before calling initSpatials");
            return;
        }
        File file = null;
        try {
            file = new File(ReplayBikeGameObject.class.getClassLoader().getResource(string).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsmGameStateException(uRISyntaxException);
        }
        File file2 = new File(file, string2);
        RandomAccessFile randomAccessFile = null;
        randomAccessFile = new RandomAccessFile(file2, "rw");
        this.replay = new NioReplay(randomAccessFile.getChannel(), 5);
        ReplayDataTransformation replayDataTransformation = new ReplayDataTransformation(10.0, new Vector3d(1.0, 1.0, 1.0));
        for (int i = 0; i < this.providers.size(); ++i) {
            replayDataTransformation.addTransformationProvider(this.providers.get(i));
        }
        this.replay.addReplayElement(replayDataTransformation);
        if (this.replayDataSpray != null) {
            this.replay.addReplayElement(this.replayDataSpray);
        }
        this.replay.startReplaying();
        this.replayComp.setReplay(this.replay);
    }

    public void initCollisionSpray(ParticleEffectsSystem particleEffectsSystem) {
        this.replayDataSpray = new ReplayDataCollisionSpray(10.0);
        for (ParticleObject particleObject : particleEffectsSystem.getParticleObjects()) {
            if (!(particleObject instanceof ParticleObjectEffectCollisionSpray)) continue;
            ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray = (ParticleObjectEffectCollisionSpray)particleObject;
            ParticleObjectEffectCollisionSpray particleObjectEffectCollisionSpray2 = new ParticleObjectEffectCollisionSpray(particleObjectEffectCollisionSpray.getNumParticles(), particleObjectEffectCollisionSpray.getTexture());
            particleObjectEffectCollisionSpray2.setEmitInterval(particleObjectEffectCollisionSpray.getEmitInterval());
            particleObjectEffectCollisionSpray2.setLifeTime(particleObjectEffectCollisionSpray.getLifeTime());
            particleObjectEffectCollisionSpray2.setGravity((Vector3d)particleObjectEffectCollisionSpray.getGravity().clone());
            this.replayDataSpray.addCollisionSpray(particleObjectEffectCollisionSpray2);
            this.effectsSystem.addParticleObject(particleObjectEffectCollisionSpray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSpatials(Bike bike) {
        Savable savable;
        ConstraintStick constraintStick = null;
        float f = 0.4f;
        TransformationCoupler transformationCoupler = new TransformationCoupler();
        String string = "leftThigh";
        constraintStick = bike.getRider().getLeftThigh();
        Quad quad = new Quad(string + "ShadowOccluderQuad", 0.5f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, -0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "rightThigh";
        constraintStick = bike.getRider().getRightThigh();
        quad = new Quad(string + "ShadowOccluderQuad", 0.5f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "leftCalf";
        constraintStick = bike.getRider().getLeftCalf();
        quad = new Quad(string + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, -0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "rightCalf";
        constraintStick = bike.getRider().getRightCalf();
        quad = new Quad(string + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "torso";
        constraintStick = bike.getRider().getTorso();
        quad = new Quad(string + "ShadowOccluderQuad", 0.55f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "leftUpperArm";
        constraintStick = bike.getRider().getLeftUpperArm();
        quad = new Quad(string + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, -0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "rightUpperArm";
        constraintStick = bike.getRider().getRightUpperArm();
        quad = new Quad(string + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "leftLowerArm";
        constraintStick = bike.getRider().getLeftLowerArm();
        quad = new Quad(string + "ShadowOccluderQuad", 0.3f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, -0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "rightLowerArm";
        constraintStick = bike.getRider().getRightLowerArm();
        quad = new Quad(string + "ShadowOccluderQuad", 0.3f, (float)constraintStick.getRestLength() + f);
        quad.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.3f));
        this.mspComp.put(quad, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "head";
        constraintStick = bike.getRider().getTorso();
        Disk disk = new Disk(string + "ShadowOccluderQuad", 2, 7, 0.5f);
        disk.setLocalTranslation(new Vector3f(0.0f, (float)(-constraintStick.getRestLength() * 0.8), 0.3f));
        this.mspComp.put(disk, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "bikeFrame";
        Node node = null;
        try {
            node = (Node)BinaryImporter.getInstance().load(BikeGameObject.class.getClassLoader().getResource("models/bikeframe_shadow.jme"));
            this.mspComp.put(node, transformationCoupler);
        }
        catch (IOException iOException) {
            try {
                logger.severe("Could not load shadow for " + string);
                this.mspComp.put(node, transformationCoupler);
            }
            catch (Throwable throwable) {
                this.mspComp.put(node, transformationCoupler);
                node.setLocalScale(new Vector3f(0.041f, 0.045f, 0.0f));
                Quaternion quaternion = new Quaternion();
                quaternion.fromAngleNormalAxis(-1.7907078f, new Vector3f(0.0f, 0.0f, 1.0f));
                node.setLocalRotation(quaternion);
                node.setLocalTranslation(quaternion.mult(new Vector3f(0.5f, 0.4f, -0.1f)));
                throw throwable;
            }
            node.setLocalScale(new Vector3f(0.041f, 0.045f, 0.0f));
            savable = new Quaternion();
            savable.fromAngleNormalAxis(-1.7907078f, new Vector3f(0.0f, 0.0f, 1.0f));
            node.setLocalRotation((Quaternion)savable);
            node.setLocalTranslation(savable.mult(new Vector3f(0.5f, 0.4f, -0.1f)));
        }
        node.setLocalScale(new Vector3f(0.041f, 0.045f, 0.0f));
        savable = new Quaternion();
        savable.fromAngleNormalAxis(-1.7907078f, new Vector3f(0.0f, 0.0f, 1.0f));
        node.setLocalRotation((Quaternion)savable);
        node.setLocalTranslation(savable.mult(new Vector3f(0.5f, 0.4f, -0.1f)));
        transformationCoupler = new TransformationCoupler();
        string = "frontWheel";
        savable = new BikeWheelShadowMesh(string + "ShadowOccluder", 3, 9, 0.195f, 0.59999996f, 0.84f, 2.2f);
        this.mspComp.put((Spatial)savable, transformationCoupler);
        transformationCoupler = new TransformationCoupler();
        string = "rearWheel";
        savable = new BikeWheelShadowMesh(string + "ShadowOccluder", 3, 9, 0.195f, 0.59999996f, 0.84f, 2.2f);
        this.mspComp.put((Spatial)savable, transformationCoupler);
        this.providers = this.mspComp.getProviderList();
    }
}

