/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.system.DisplaySystem;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gui.Label;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.sound.SFX;
import com.turborilla.utils.Font;
import com.turborilla.utils.Scheduling;
import com.turborilla.utils.controllers.AbstractSpatialController;
import com.turborilla.utils.controllers.IControllerListener;
import com.turborilla.utils.controllers.SpatialFadeController;
import java.io.IOException;

public class ChallengesAchievedGameObject
extends GameObject {
    private Font font;
    private String text;
    private Node node;
    private static ColorRGBA hideColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f);
    private static ColorRGBA showColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private SpatialFadeController fader;
    private Label label;
    private SFX showSFX;
    private SFX collectedSFX;
    private Scheduling taskManager;

    public ChallengesAchievedGameObject(String string, String string2, Font font) {
        super(string);
        this.text = string2;
        this.font = font;
        this.node = new Node(this.getName() + ":node");
        this.label = new Label(font, string2.length());
        this.label.setText(string2);
        this.fader = new SpatialFadeController(this.label);
        this.fader.initRenderStates();
        this.fader.setColor(hideColor);
        try {
            this.showSFX = (SFX)ResourceManager.getInstance().load("sfx", "show_reward", null);
            this.collectedSFX = (SFX)ResourceManager.getInstance().load("sfx", "collect_reward", null);
            this.showSFX.setVolumeCategory("GameSFXVolume");
            this.collectedSFX.setVolumeCategory("GameSFXVolume");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.taskManager = new Scheduling();
    }

    public void reset() {
        this.taskManager.clearSchedule();
        this.fader.clearFadeQueue();
        this.fader.clearListeners();
        this.fader.setColor(hideColor);
        this.node.detachChild(this.label);
    }

    private void show() {
        this.label.setLocalTranslation(DisplaySystem.getDisplaySystem().getWidth() / 2, (float)DisplaySystem.getDisplaySystem().getHeight() * 0.75f, 0.0f);
        this.fader.clearFadeQueue();
        this.fader.clearListeners();
        this.node.attachChild(this.label);
        this.showSFX.play();
        this.fader.fadeTo(showColor, 0.3f);
        this.taskManager.add(new Runnable(){

            public void run() {
                ChallengesAchievedGameObject.this.collectedSFX.play();
            }
        }, 1.0f);
    }

    private void hide() {
        this.taskManager.clearSchedule();
        this.fader.clearFadeQueue();
        this.fader.clearListeners();
        this.fader.fadeTo(hideColor, 0.7f);
        this.fader.add(new IControllerListener(){

            public void controllerTaskFinished(AbstractSpatialController abstractSpatialController) {
                ChallengesAchievedGameObject.this.node.detachChild(abstractSpatialController.getSpatial());
            }
        });
    }

    public Node getNode() {
        return this.node;
    }

    public void onDetach() {
        if (this.node.getParent() != null) {
            this.node.getParent().detachChild(this.getNode());
        }
        super.onDetach();
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (receivedEvent.is("AllChallengesAchieved")) {
            this.show();
        }
        if (receivedEvent.is("PassedFinishline")) {
            this.taskManager.add(new Runnable(){

                public void run() {
                    ChallengesAchievedGameObject.this.hide();
                }
            }, 4.0f);
        }
    }

    public void update(float f) {
        super.update(f);
        this.taskManager.update(f);
    }

    public void registerForEvents(EventManager eventManager) {
        eventManager.registerListener("AllChallengesAchieved", this);
        eventManager.registerListener("PassedFinishline", this);
    }
}

