/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.system.GameSettings;
import com.turborilla.event.typesafe.EventManager;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.gameobjects.RaceController;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.utils.Utils;
import java.io.IOException;

public class CareerRaceController
extends RaceController {
    private String finishedFirst = null;
    private int numberOfFinished = 0;
    private int currentRace = 0;
    private String[] tracks = new String[]{"track1", "track2", "track3", "track4", "track5"};

    public CareerRaceController(String string, GameSettings gameSettings, GameState gameState) {
        super(string, gameSettings, gameState);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        super.handleEvent(receivedEvent);
        if ("PassedFinishline".equals(receivedEvent.getName())) {
            String string = receivedEvent.getArgumentValue("gameObject");
            float f = Float.parseFloat(receivedEvent.getArgumentValue("time", "0"));
            this.passedFinishLine(string, f);
        } else if ("RaceStarted".equals(receivedEvent.getName())) {
            this.reset();
        }
    }

    private void passedFinishLine(String string, float f) {
        if (this.numberOfFinished == 0) {
            this.finishedFirst = string;
        }
        ++this.numberOfFinished;
        if (this.numberOfFinished >= 1) {
            if (this.finishedFirst.indexOf("human") >= 0) {
                EventManager eventManager = this.getGlobalEventManager();
                if (eventManager != null) {
                    eventManager.fireEvent("ActivateState", new String[][]{{"stateName"}, {"MenuState"}});
                    eventManager.fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"YouWon", "true"}});
                }
                this.reset();
            } else if (this.numberOfFinished >= 2) {
                EventManager eventManager = this.getGlobalEventManager();
                if (eventManager != null) {
                    eventManager.fireEvent("ActivateState", new String[][]{{"stateName"}, {"MenuState"}});
                    eventManager.fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"YouLost", "true"}});
                }
                this.reset();
            }
        }
    }

    protected void nextRace() {
        ++this.currentRace;
        if (this.currentRace >= this.tracks.length) {
            if (this.getGlobalEventManager() != null) {
                this.reset();
                this.currentRace = 0;
                this.getGlobalEventManager().fireEvent("ActivateState", new String[][]{{"stateName"}, {"MenuState"}});
                this.getGlobalEventManager().fireEvent("SwitchMenu", new String[][]{{"menu", "noTransition"}, {"CompletedGame", "true"}});
            }
        } else {
            try {
                this.gameState.prepareNewRace(Utils.getProperties(new String[][]{{"track", "controlMode"}, {this.tracks[this.currentRace], Profile.getCurrentProfile(this.getSettings()).getDifficulty().getName()}}));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void registerForEvents(EventManager eventManager) {
        super.registerForEvents(eventManager);
        eventManager.registerListener("PassedFinishline", this);
        eventManager.registerListener("StartCountdown", this);
        eventManager.registerListener("RaceStarted", this);
    }

    public void reset() {
        this.finishedFirst = null;
        this.numberOfFinished = 0;
    }
}

