/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.gameobjects;

import com.jme.input.InputHandler;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Disk;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.turborilla.NodeFollowingTransformationProvider;
import com.turborilla.TransformationProvider;
import com.turborilla.WeakSpatialTransformationProvider;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.gameobject.GameObject;
import com.turborilla.gameobject.IComponent;
import com.turborilla.msm.components.BikeControlComponent;
import com.turborilla.msm.components.BoneBreakSoundComponent;
import com.turborilla.msm.components.BoostComponent;
import com.turborilla.msm.components.BoostComponentWithFX;
import com.turborilla.msm.components.ChallengeMonitorComponent;
import com.turborilla.msm.components.EngineSoundComponent;
import com.turborilla.msm.components.GlideComponent;
import com.turborilla.msm.components.GyroComponent;
import com.turborilla.msm.components.HumanBikeControlComponent;
import com.turborilla.msm.components.JetpackComponent;
import com.turborilla.msm.components.JumpComponent;
import com.turborilla.msm.components.ManySpatialsComponent;
import com.turborilla.msm.components.NNBikeControlComponent;
import com.turborilla.msm.components.NeuralNetZipRecorderComponent;
import com.turborilla.msm.components.NitroComponent;
import com.turborilla.msm.components.ParticleSystemComponent;
import com.turborilla.msm.components.ReplayComponent;
import com.turborilla.msm.components.ReplayControlComponent;
import com.turborilla.msm.components.RiderSoundComponent;
import com.turborilla.msm.components.SlowMotionComponent;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.components.TurboEngineSoundComponent;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.models.BikeWheelShadowMesh;
import com.turborilla.msm.physics.EngineTorqueFunction;
import com.turborilla.msm.physics.TurboEngineTorqueFunction;
import com.turborilla.msm.physics.collision.ParticleObjectEffectCollisionSpray;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.Profile;
import com.turborilla.msm.replay.ReplayDataCollisionSpray;
import com.turborilla.msm.replay.ReplayDataCompositeSFX;
import com.turborilla.msm.replay.ReplayDataEngineSound;
import com.turborilla.msm.replay.ReplayDataParticleObject;
import com.turborilla.msm.replay.ReplayDataSpecialAbility;
import com.turborilla.msm.replay.ReplayParticipant;
import com.turborilla.msm.replay.ReplayableCompositeSFX;
import com.turborilla.msm.rewards.RewardComponent;
import com.turborilla.msm.skin.Skin;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.physics.collision.CollisionStructure;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.physics.particle.ParticleEffectsSystem;
import com.turborilla.physics.particle.ParticleObject;
import com.turborilla.replay.nioreplay.NioReplay;
import com.turborilla.sound.CompositeSFX;
import com.turborilla.sound.SFX;
import com.turborilla.utils.Scheduling;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Properties;

public class BikeGameObject
extends GameObject {
    private Bike bikeParticleSystem;
    private ParticleEffectsSystem particleEffects;
    private Node parentNode;
    private BikeControlComponent control;
    private EngineTorqueFunction torqueFunction;
    private boolean isPlayer = false;
    private Profile profile;
    private boolean recordAIData = false;
    private GameState gameState;
    private Node effectsNode;
    private Node debugNode;
    private Node shadowOccluders;
    private boolean replay;
    private ReplayParticipant replayParticipant;
    private boolean turbo;
    private Difficulty difficulty;
    private Node gyroDebug = null;
    private GyroComponent gyro = null;
    private Line bikeUp;
    private Line wantedUp;
    private Vector3d tempVecd = new Vector3d();
    private Vector3f tempVecf1 = new Vector3f();
    private Vector3f tempVecf2 = new Vector3f();
    private NeuralNetZipRecorderComponent aiRecordComponent;
    private RewardComponent statComponent;
    private Node frameFollower;
    private Node riderFollower;
    private Node mspCompOccluderNode;
    private ChallengeMonitorComponent challengeMonitorComponent;
    private FXGameObject specialAbilityFX;
    private ReplayComponent replayComponent;
    private Scheduling taskManager = new Scheduling();
    private EngineSoundComponent engineSoundComponent;

    public BikeGameObject(String string) {
        super(string);
    }

    public void init(float f, CollisionStructure collisionStructure, Node node, Node node2, Node node3, Node node4, InputHandler inputHandler, GameState gameState, Profile profile, String string) throws IOException {
        this.init(f, collisionStructure, node, node2, node3, node4, inputHandler, gameState, profile.getDifficulty(), profile, string, null, false, null, false, null);
    }

    public void init(float f, CollisionStructure collisionStructure, Node node, Node node2, Node node3, Node node4, InputHandler inputHandler, GameState gameState, Difficulty difficulty, Profile profile, String string, NioReplay nioReplay, boolean bl, ReplayParticipant replayParticipant, boolean bl2, Integer n) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        AbstractComponent abstractComponent;
        this.parentNode = node;
        this.gameState = gameState;
        this.replayParticipant = replayParticipant;
        this.isPlayer = inputHandler != null;
        this.replay = bl;
        this.difficulty = difficulty;
        this.profile = profile;
        if (node3 != null) {
            this.particleEffects = new ParticleEffectsSystem(this.getName() + ":particleEffects");
            this.effectsNode = node3;
            this.effectsNode.attachChild(this.particleEffects.getNode());
        }
        this.setTurbo(bl2);
        Vector3d vector3d = new Vector3d(10.0, 0.0, 0.0);
        if (bl) {
            vector3d.x = -100.0;
        }
        this.bikeParticleSystem = new Bike(null, vector3d, 0.03f, 0.03f, 0.03f, collisionStructure, 0, this.particleEffects, this);
        this.bikeParticleSystem.setLockedZvalue(f);
        this.bikeParticleSystem.setMaximumTimeStep(0.001);
        this.bikeParticleSystem.setGravity(new Vector3d(0.0, -25.0, 0.0));
        this.bikeParticleSystem.getFrame().multiplyConstraintStiffness(1.2);
        this.bikeParticleSystem.getFrame().multiplyConstraintDamping(2.0);
        this.bikeParticleSystem.getRider().multiplyConstraintStiffness(2.1);
        this.bikeParticleSystem.getRider().multiplyConstraintDamping(1.5);
        if (difficulty == Difficulty.Arcade) {
            this.bikeParticleSystem.getRearWheel().setChaindrive(false);
        }
        ParticleSystemComponent particleSystemComponent = new ParticleSystemComponent(this.getName() + ":particleEffectsSystemComp", this.particleEffects);
        this.addComponent(particleSystemComponent);
        ParticleSystemComponent particleSystemComponent2 = new ParticleSystemComponent(this.getName() + ":bikeParticleSystemComp", this.bikeParticleSystem);
        particleSystemComponent2.setReplaying(this.isReplay());
        this.addComponent(particleSystemComponent2);
        ManySpatialsComponent manySpatialsComponent = new ManySpatialsComponent("BikeSkinSpatialComponent");
        this.addComponent(manySpatialsComponent);
        node.attachChild(manySpatialsComponent.getNode());
        Properties properties = new Properties();
        properties.setProperty("lookInCache", "false");
        int n2 = (int)Math.round(Math.random() * 3.0) + 2;
        if (this.isPlayer) {
            n2 = 1;
        } else if (n != null) {
            n2 = n;
        }
        int n3 = n2;
        Skin skin = (Skin)ResourceManager.getInstance().load("skin", "bikes/bike" + n2, properties);
        skin.apply(this.bikeParticleSystem, manySpatialsComponent);
        ManySpatialsComponent manySpatialsComponent2 = new ManySpatialsComponent("RiderSkinSpatialComponent");
        this.addComponent(manySpatialsComponent2);
        node.attachChild(manySpatialsComponent2.getNode());
        skin = (Skin)ResourceManager.getInstance().load("skin", "riders/rider" + n3, properties);
        skin.apply(this.bikeParticleSystem, manySpatialsComponent2);
        float f2 = 0.4f;
        this.shadowOccluders = node2;
        if (node2 != null) {
            abstractComponent = new ManySpatialsComponent("BikeShadowOccluderSpatialComponent");
            this.addComponent(abstractComponent);
            this.mspCompOccluderNode = ((ManySpatialsComponent)abstractComponent).getNode();
            node2.attachChild(this.mspCompOccluderNode);
            f2 = 0.4f;
            float f3 = 0.5f;
            String string2 = "leftThigh";
            ConstraintStick constraintStick = this.bikeParticleSystem.getRider().getLeftThigh();
            Quad quad = new Quad(string2 + "ShadowOccluderQuad", 0.5f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, -0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "rightThigh";
            constraintStick = this.bikeParticleSystem.getRider().getRightThigh();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.5f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, 0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "leftCalf";
            constraintStick = this.bikeParticleSystem.getRider().getLeftCalf();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, -0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "rightCalf";
            constraintStick = this.bikeParticleSystem.getRider().getRightCalf();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, 0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "torso";
            constraintStick = this.bikeParticleSystem.getRider().getTorso();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.55f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, 0.0f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "leftUpperArm";
            constraintStick = this.bikeParticleSystem.getRider().getLeftUpperArm();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, -0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "rightUpperArm";
            constraintStick = this.bikeParticleSystem.getRider().getRightUpperArm();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.35f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, 0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "leftLowerArm";
            constraintStick = this.bikeParticleSystem.getRider().getLeftLowerArm();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.3f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, -0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "rightLowerArm";
            constraintStick = this.bikeParticleSystem.getRider().getRightLowerArm();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.3f, (float)constraintStick.getRestLength() + f2);
            quad.setLocalTranslation(new Vector3f(f3, 0.0f, 0.3f));
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "head";
            constraintStick = this.bikeParticleSystem.getRider().getTorso();
            object6 = new Disk(string2 + "ShadowOccluderDisc", 2, 7, 0.5f);
            ((Spatial)object6).setLocalTranslation(new Vector3f(f3, (float)(constraintStick.getRestLength() * 0.8), 0.3f));
            ((ManySpatialsComponent)abstractComponent).put((Spatial)object6, constraintStick);
            string2 = "rearSuspensionArm";
            constraintStick = this.bikeParticleSystem.getFrame().getRearSuspensionArm();
            quad = new Quad(string2 + "ShadowOccluderQuad", 0.4f, (float)constraintStick.getRestLength() + f2);
            ((ManySpatialsComponent)abstractComponent).put(quad, constraintStick);
            string2 = "bikeFrame";
            object5 = null;
            object5 = (Node)BinaryImporter.getInstance().load(BikeGameObject.class.getClassLoader().getResource("models/bikeframe_shadow.jme"));
            ((SceneElement)object5).clearRenderState(9);
            ((SceneElement)object5).setName("ShadowOccluderBikeFrame");
            object4 = (TriMesh)((Node)object5).getChild(0);
            object3 = ((Geometry)object4).getVertexBuffer(0);
            for (int i = 0; i < ((Buffer)object3).capacity(); ++i) {
                ((FloatBuffer)object3).put(i, ((FloatBuffer)object3).get(i) * 0.043f);
            }
            ((ManySpatialsComponent)abstractComponent).put((Spatial)object5, this.bikeParticleSystem.getFrame());
            Quaternion quaternion = new Quaternion();
            quaternion.fromAngleNormalAxis(-1.7907078f, new Vector3f(0.0f, 0.0f, 1.0f));
            ((Spatial)object5).setLocalRotation(quaternion);
            ((Spatial)object5).setLocalTranslation(quaternion.mult(new Vector3f(0.5f, 0.4f, 0.0f)));
            string2 = "frontWheel";
            BikeWheelShadowMesh bikeWheelShadowMesh = new BikeWheelShadowMesh(string2 + "ShadowOccluder", 3, 9, 0.195f, 0.59999996f, 0.84f, 1.5f);
            ((ManySpatialsComponent)abstractComponent).put(bikeWheelShadowMesh, this.bikeParticleSystem.getFrontWheel());
            string2 = "rearWheel";
            bikeWheelShadowMesh = new BikeWheelShadowMesh(string2 + "ShadowOccluder", 3, 9, 0.195f, 0.59999996f, 0.84f, 1.5f);
            ((ManySpatialsComponent)abstractComponent).put(bikeWheelShadowMesh, this.bikeParticleSystem.getRearWheel());
            object2 = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
            ((CullState)object2).setCullMode(1);
            ((ManySpatialsComponent)abstractComponent).getNode().setRenderState((RenderState)object2);
            object = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
            ((ZBufferState)object).setFunction(7);
            ((ManySpatialsComponent)abstractComponent).getNode().setRenderState((RenderState)object);
            ((ManySpatialsComponent)abstractComponent).getNode().updateRenderState();
        }
        this.frameFollower = new NodeFollowingTransformationProvider(this.bikeParticleSystem.getFrame());
        this.riderFollower = new NodeFollowingTransformationProvider(this.bikeParticleSystem.getRider());
        abstractComponent = this.constructSpecialAbility(string, gameState.getSettings());
        if (this.isPlayer) {
            this.control = new HumanBikeControlComponent("humanBikeControlComponent", this, inputHandler, difficulty, profile.getData().getInputData(), (SpecialAbilityComponent)abstractComponent);
            this.addComponent(this.control);
            this.gyro = this.control.getGyroComponent();
        } else if (!bl) {
            this.control = new NNBikeControlComponent("NNAIBikeControlComponent", gameState.getTrack(), this, (SpecialAbilityComponent)abstractComponent);
            this.addComponent(this.control);
        } else {
            this.control = new ReplayControlComponent("ReplayControlComponent", this, difficulty, (SpecialAbilityComponent)abstractComponent);
            this.addComponent(this.control);
        }
        if (this.isPlayer) {
            this.statComponent = new RewardComponent("bikeWatcherComponent", this.bikeParticleSystem);
            this.addComponent(this.statComponent);
        }
        if (this.isPlayer) {
            this.challengeMonitorComponent = new ChallengeMonitorComponent(this, gameState);
            this.addComponent(this.challengeMonitorComponent);
        }
        Properties properties2 = new Properties();
        properties2.setProperty("lookInCache", "false");
        properties2.setProperty("putInCache", "false");
        object6 = null;
        object5 = (CompositeSFX)ResourceManager.getInstance().load("compositesfx", "argh", properties2);
        object6 = new ReplayableCompositeSFX((CompositeSFX)object5);
        ((SFX)object6).setVolumeCategory("GameSFXVolume");
        ((SFX)object6).setSpatialToTrack(this.riderFollower);
        if (!this.isReplay()) {
            object4 = new RiderSoundComponent(this.getName() + ":riderSoundComponent", this.bikeParticleSystem.getRiderCollision(), this.bikeParticleSystem.getRider(), (CompositeSFX)object6);
            this.addComponent((IComponent)object4);
        }
        object4 = null;
        object5 = (CompositeSFX)ResourceManager.getInstance().load("compositesfx", "crack", properties2);
        object4 = new ReplayableCompositeSFX((CompositeSFX)object5);
        ((SFX)object4).setVolumeCategory("GameSFXVolume");
        ((SFX)object4).setSpatialToTrack(this.riderFollower);
        if (!this.isReplay()) {
            object3 = new BoneBreakSoundComponent(this.getName() + ":riderBoneBreakSoundComponent", (CompositeSFX)object4, this.bikeParticleSystem, 0.4, 0.5f);
            this.addComponent((IComponent)object3);
            for (int i = 0; i < this.bikeParticleSystem.getRider().getBoneBreakTriggers().size(); ++i) {
                ((BoneBreakSoundComponent)object3).addTrigger(this.bikeParticleSystem.getRider().getBoneBreakTriggers().get(i));
            }
        }
        this.engineSoundComponent = null;
        object3 = (SFX)ResourceManager.getInstance().load("SFX", "engine_22k", properties2);
        SFX sFX = (SFX)ResourceManager.getInstance().load("SFX", "turbo", properties2);
        object = null;
        if (this.isPlayer) {
            object2 = "GamePlayerEngineVolume";
            object = new WeakSpatialTransformationProvider(this.riderFollower);
        } else {
            object2 = "GameOpponentEngineVolume";
            object = new WeakSpatialTransformationProvider(this.frameFollower);
        }
        ((SFX)object3).setVolumeCategory((String)object2);
        ((SFX)object3).setProviderToTrack((TransformationProvider)object);
        sFX.setVolumeCategory((String)object2);
        sFX.setProviderToTrack((TransformationProvider)object);
        this.engineSoundComponent = bl2 ? new TurboEngineSoundComponent(this.getName() + ":engineSoundComp", this.bikeParticleSystem.getRearWheel(), this.control.getThrottleComponent(), (SFX)object3, sFX) : new EngineSoundComponent(this.getName() + ":engineSoundComp", this.bikeParticleSystem.getRearWheel(), this.control.getThrottleComponent(), (SFX)object3);
        this.addComponent(this.engineSoundComponent);
        if (this.isReplay()) {
            this.engineSoundComponent.setReplaying(true);
        }
        this.debugNode = node4;
        if (node4 != null) {
            node4.attachChild(this.bikeParticleSystem.getDebugNode());
            if (this.gyro != null) {
                this.gyroDebug = new Node("gyroDebugNode");
                this.gyroDebug.setLightCombineMode(0);
                node4.attachChild(this.gyroDebug);
            }
        }
        if (this.recordAIData && this.isPlayer() && !bl) {
            this.aiRecordComponent = new NeuralNetZipRecorderComponent("nnrec", gameState, this, this.getControl().getFrontBrakeComponent(), this.getControl().getThrottleComponent(), this.getControl().getLeaningComponent());
            this.addComponent(this.aiRecordComponent);
        }
        if (bl) {
            this.replayComponent = new ReplayComponent(this.getName() + ":replayComp");
            this.replayComponent.setReplay(nioReplay);
        }
        if (this.isPlayer && !bl) {
            this.replayComponent = new ReplayComponent(this.getName() + ":replayComp");
            nioReplay = this.replayComponent.getReplay();
        }
        if (nioReplay != null) {
            nioReplay.clearReplayElements();
            ArrayList<ParticleObject> arrayList = this.bikeParticleSystem.getParticleObjects();
            for (int i = 0; i < arrayList.size(); ++i) {
                ParticleObject particleObject = arrayList.get(i);
                ReplayDataParticleObject replayDataParticleObject = new ReplayDataParticleObject(particleObject);
                replayDataParticleObject.setZPos(f);
                nioReplay.addReplayElement(replayDataParticleObject);
            }
            ReplayDataCollisionSpray replayDataCollisionSpray = new ReplayDataCollisionSpray(f);
            replayDataCollisionSpray.addCollisionSpray((ParticleObjectEffectCollisionSpray)this.bikeParticleSystem.getRiderCollision().getCollisionSpray());
            nioReplay.addReplayElement(replayDataCollisionSpray);
            nioReplay.addReplayElement(new ReplayDataSpecialAbility((SpecialAbilityComponent)abstractComponent));
            nioReplay.addReplayElement(new ReplayDataCompositeSFX((ReplayableCompositeSFX)object6));
            nioReplay.addReplayElement(new ReplayDataCompositeSFX((ReplayableCompositeSFX)object4));
            nioReplay.addReplayElement(new ReplayDataEngineSound(this.engineSoundComponent));
            this.addComponent(this.replayComponent);
        }
    }

    private SpecialAbilityComponent constructSpecialAbility(String string, GameSettings gameSettings) throws IOException {
        SpecialAbilityComponent specialAbilityComponent = null;
        Properties properties = new Properties();
        properties.setProperty("putInCache", "false");
        properties.setProperty("lookInCache", "false");
        if (string != null) {
            if (string.equals("jumper")) {
                try {
                    Properties properties2 = (Properties)ResourceManager.getInstance().load("properties", "jumper", null);
                    if (properties2 != null) {
                        specialAbilityComponent = new JumpComponent(this.getName() + ":JumpComponent", Float.parseFloat(properties2.getProperty("duration", "0.1")), Float.parseFloat(properties2.getProperty("force", "3000")), this.bikeParticleSystem);
                    }
                }
                catch (IOException iOException) {
                    specialAbilityComponent = new JumpComponent(this.getName() + ":JumpComponent", 0.1f, 3000.0f, this.bikeParticleSystem);
                }
                if (specialAbilityComponent != null) {
                    specialAbilityComponent.setSfx((SFX)ResourceManager.getInstance().load("sfx", "jumper", properties));
                    specialAbilityComponent.getSfx().setSpatialToTrack(this.getFrameFollower());
                }
            } else if (string.equals("glider")) {
                specialAbilityComponent = new GlideComponent(this.getName() + ":GlideComponent", this.bikeParticleSystem);
            } else if (string.equals("nitro")) {
                try {
                    Properties properties3 = (Properties)ResourceManager.getInstance().load("properties", "nitro", null);
                    if (properties3 != null) {
                        specialAbilityComponent = new NitroComponent(this.getName() + ":BoostComponent", Float.parseFloat(properties3.getProperty("duration", "5")), Float.parseFloat(properties3.getProperty("force", "120")), this.bikeParticleSystem, gameSettings);
                    }
                }
                catch (IOException iOException) {
                    specialAbilityComponent = new BoostComponentWithFX(this.getName() + ":BoostComponent", 5.0f, 120.0f, this.bikeParticleSystem);
                }
                if (specialAbilityComponent != null) {
                    ((BoostComponent)specialAbilityComponent).setInitialExplosion(true, 42.0f);
                    specialAbilityComponent.setSfx((SFX)ResourceManager.getInstance().load("sfx", "nitro", properties));
                    specialAbilityComponent.getSfx().setSpatialToTrack(this.getFrameFollower());
                }
            } else if (string.equals("jetpack")) {
                try {
                    Properties properties4 = (Properties)ResourceManager.getInstance().load("properties", "jetpack", null);
                    if (properties4 != null) {
                        specialAbilityComponent = new JetpackComponent(this.getName() + ":JetpackComponent", Float.parseFloat(properties4.getProperty("duration", "5")), Float.parseFloat(properties4.getProperty("force", "80")), this.bikeParticleSystem);
                    }
                }
                catch (IOException iOException) {
                    specialAbilityComponent = new JetpackComponent(this.getName() + ":JetpackComponent", 5.0f, 80.0f, this.bikeParticleSystem);
                }
                if (specialAbilityComponent != null) {
                    specialAbilityComponent.setSfx((SFX)ResourceManager.getInstance().load("sfx", "jetshoes", properties));
                    specialAbilityComponent.getSfx().setSpatialToTrack(this.getRiderFollower());
                }
            } else if (string.equals("slowmo")) {
                specialAbilityComponent = new SlowMotionComponent(this.getName() + ":slowMotionComponent", 0.5f, 4.3f);
            }
        }
        if (specialAbilityComponent != null) {
            this.specialAbilityFX = specialAbilityComponent.getFX();
            if (specialAbilityComponent.getSfx() != null && !(specialAbilityComponent instanceof NitroComponent)) {
                specialAbilityComponent.getSfx().setVolumeCategory("GameSFXVolume");
            }
        }
        return specialAbilityComponent;
    }

    public void update(float f) {
        super.update(f);
        if (this.taskManager != null) {
            this.taskManager.update(f);
        }
        if (this.frameFollower != null) {
            this.frameFollower.updateGeometricState(f, true);
        }
        if (this.riderFollower != null) {
            this.riderFollower.updateGeometricState(f, true);
        }
        if (this.gyroDebug != null && this.gyro != null) {
            if (this.bikeUp == null) {
                this.bikeUp = new Line("bikeupLine", BufferUtils.createVector3Buffer(2), null, null, null);
                this.wantedUp = new Line("wantedupLine", BufferUtils.createVector3Buffer(2), null, null, null);
                this.bikeUp.setDefaultColor(ColorRGBA.cyan);
                this.bikeUp.setLineWidth(5.0f);
                this.wantedUp.setDefaultColor(ColorRGBA.orange);
                this.wantedUp.setLineWidth(5.0f);
                this.gyroDebug.attachChild(this.bikeUp);
                this.gyroDebug.attachChild(this.wantedUp);
            }
            this.bikeParticleSystem.getCenterOfMass(this.tempVecd);
            this.tempVecd.toVector3f(this.tempVecf1);
            this.tempVecf2.set(FastMath.sin((float)this.gyro.getBikeAngle()), FastMath.cos((float)this.gyro.getBikeAngle()), 0.0f);
            this.tempVecf2.multLocal(5.0f);
            this.tempVecf1.add(this.tempVecf2, this.tempVecf2);
            FloatBuffer floatBuffer = this.bikeUp.getVertexBuffer(0);
            floatBuffer.clear();
            floatBuffer.put(this.tempVecf1.x).put(this.tempVecf1.y).put(this.tempVecf1.z);
            floatBuffer.put(this.tempVecf2.x).put(this.tempVecf2.y).put(this.tempVecf2.z);
            floatBuffer.flip();
            this.tempVecd.toVector3f(this.tempVecf1);
            this.tempVecf2.set(FastMath.sin((float)this.gyro.getAngle()), FastMath.cos((float)this.gyro.getAngle()), 0.0f);
            this.tempVecf2.multLocal(5.0f);
            this.tempVecf1.add(this.tempVecf2, this.tempVecf2);
            floatBuffer = this.wantedUp.getVertexBuffer(0);
            floatBuffer.clear();
            floatBuffer.put(this.tempVecf1.x).put(this.tempVecf1.y).put(this.tempVecf1.z);
            floatBuffer.put(this.tempVecf2.x).put(this.tempVecf2.y).put(this.tempVecf2.z);
            floatBuffer.flip();
        }
    }

    public void startReplayComponent() {
        this.startReplayComponent(0.0f);
    }

    public void startReplayComponent(float f) {
        if (this.replayComponent == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (BikeGameObject.this.replay) {
                    BikeGameObject.this.replayComponent.startReplaying();
                } else {
                    BikeGameObject.this.replayComponent.startRecording();
                }
            }
        };
        if (f <= 0.001f) {
            runnable.run();
        } else {
            this.taskManager.add(runnable, f);
        }
    }

    public void stopReplayComponent() {
        if (this.replayComponent == null) {
            return;
        }
        if (this.replay) {
            this.replayComponent.stopReplaying();
        } else {
            this.replayComponent.stopRecording();
        }
    }

    public void resetReplayComponent() {
        if (this.replayComponent == null) {
            return;
        }
        this.replayComponent.reset();
    }

    public void onDetach() {
        if (this.debugNode != null) {
            this.debugNode.detachChild(this.bikeParticleSystem.getDebugNode());
            if (this.gyroDebug != null) {
                this.debugNode.detachChild(this.gyroDebug);
            }
        }
        if (this.effectsNode != null) {
            this.effectsNode.detachChild(this.particleEffects.getNode());
        }
        if (this.shadowOccluders != null && this.mspCompOccluderNode != null) {
            this.shadowOccluders.detachChild(this.mspCompOccluderNode);
        }
        if (this.frameFollower != null && this.getParentGameState() != null) {
            this.getParentGameState().getRootNode().detachChild(this.frameFollower);
        }
        if (this.riderFollower != null && this.getParentGameState() != null) {
            this.getParentGameState().getRootNode().detachChild(this.riderFollower);
        }
        if (this.specialAbilityFX != null) {
            if (this.specialAbilityFX.getNode().getParent() != null) {
                this.specialAbilityFX.getNode().getParent().detachChild(this.specialAbilityFX.getNode());
            }
            if (this.getParentGameState() != null) {
                this.getParentGameState().removeGameObject(this.specialAbilityFX);
            }
        }
        if (this.taskManager != null) {
            this.taskManager.clearSchedule();
        }
        super.onDetach();
    }

    public Bike getBikeParticleSystem() {
        return this.bikeParticleSystem;
    }

    public ParticleEffectsSystem getParticleEffects() {
        return this.particleEffects;
    }

    public BikeControlComponent getControl() {
        return this.control;
    }

    public EngineTorqueFunction getTorqueFunction() {
        return this.torqueFunction;
    }

    public void setTorqueFunction(EngineTorqueFunction engineTorqueFunction) {
        this.torqueFunction = engineTorqueFunction;
        if (this.getControl() != null && this.getControl().getThrottleComponent() != null) {
            this.getControl().getThrottleComponent().setTorqueFunction(engineTorqueFunction);
        }
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public NeuralNetZipRecorderComponent getAiRecordComponent() {
        return this.aiRecordComponent;
    }

    public RewardComponent getStatComponent() {
        return this.statComponent;
    }

    public ChallengeMonitorComponent getChallengeMonitorComponent() {
        return this.challengeMonitorComponent;
    }

    public FXGameObject getSpecialAbilityFX() {
        return this.specialAbilityFX;
    }

    public void changeSpecialAbility(String string) throws IOException {
        SpecialAbilityComponent specialAbilityComponent = this.constructSpecialAbility(string, this.gameState.getSettings());
        if (this.getControl() != null && specialAbilityComponent != null) {
            this.getControl().changeSpecialAbility(specialAbilityComponent);
        }
    }

    public ReplayComponent getReplayComponent() {
        return this.replayComponent;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public ReplayParticipant getReplayParticipant() {
        return this.replayParticipant;
    }

    public Node getFrameFollower() {
        return this.frameFollower;
    }

    public Node getRiderFollower() {
        return this.riderFollower;
    }

    public void setTurbo(boolean bl) {
        this.turbo = bl;
        EngineTorqueFunction engineTorqueFunction = null;
        if (bl) {
            engineTorqueFunction = new TurboEngineTorqueFunction();
            engineTorqueFunction.setMinTorque(50.0);
            if (this.difficulty == Difficulty.Arcade) {
                ((TurboEngineTorqueFunction)engineTorqueFunction).setTurboChargeTorque(70.0);
                ((TurboEngineTorqueFunction)engineTorqueFunction).setTurboChargeVelocity(30.0);
                engineTorqueFunction.setPeakTorque(250.0);
                engineTorqueFunction.setPeakVelocity(90.0);
            } else {
                engineTorqueFunction.setPeakTorque(112.0);
                engineTorqueFunction.setPeakVelocity(73.0);
            }
            engineTorqueFunction.setMaxVelocity(150.0);
        } else {
            engineTorqueFunction = new EngineTorqueFunction();
            engineTorqueFunction.setMinTorque(50.0);
            if (this.difficulty == Difficulty.Arcade) {
                engineTorqueFunction.setPeakTorque(100.0);
                engineTorqueFunction.setPeakVelocity(70.0);
            } else {
                engineTorqueFunction.setPeakTorque(112.0);
                engineTorqueFunction.setPeakVelocity(73.0);
            }
            engineTorqueFunction.setMaxVelocity(100.0);
        }
        this.setTorqueFunction(engineTorqueFunction);
        Bike bike = this.getBikeParticleSystem();
        if (bike != null) {
            if (bl) {
                bike.getRearWheelCollision().setFriction(450.0);
            } else {
                bike.getRearWheelCollision().setFriction(45.0);
            }
            if (bl) {
                bike.getFrontWheelCollision().setFriction(25.0);
            } else {
                bike.getFrontWheelCollision().setFriction(45.0);
            }
        }
    }

    public boolean isTurbo() {
        return this.turbo;
    }

    public void stopEngine() {
        if (this.engineSoundComponent != null) {
            this.engineSoundComponent.stopEngine();
        }
    }
}

