/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.EngineTorqueFunction;
import com.turborilla.msm.physics.objects.BikeWheel;

public class ThrottleComponent
extends AbstractComponent {
    private double throttleValue = 0.0;
    private boolean isThrottling = false;
    private boolean wasThrottling = false;
    private BikeWheel bikeWheel;
    private EngineTorqueFunction torqueFunction;

    public ThrottleComponent(String string, BikeWheel bikeWheel, EngineTorqueFunction engineTorqueFunction) {
        super(string);
        this.bikeWheel = bikeWheel;
        this.torqueFunction = engineTorqueFunction;
        this.setPriority(100);
    }

    public void throttling(float f) {
        if (this.isPaused()) {
            return;
        }
        this.isThrottling = true;
    }

    protected void handleMessages(float f) {
    }

    protected void componentUpdate(float f) {
        this.wasThrottling = false;
        if (this.isThrottling) {
            this.wasThrottling = true;
            this.throttleValue = this.torqueFunction.getTorque(this.bikeWheel.getAngularVelocity(f));
            this.bikeWheel.setThrottleAmount(-this.throttleValue);
        } else {
            this.throttleValue = 0.0;
        }
        this.isThrottling = false;
    }

    public BikeWheel getBikeWheel() {
        return this.bikeWheel;
    }

    public void setBikeWheel(BikeWheel bikeWheel) {
        this.bikeWheel = bikeWheel;
    }

    public boolean isThrottling() {
        return (this.isThrottling || this.wasThrottling) && !this.isPaused();
    }

    public EngineTorqueFunction getTorqueFunction() {
        return this.torqueFunction;
    }

    public void setTorqueFunction(EngineTorqueFunction engineTorqueFunction) {
        this.torqueFunction = engineTorqueFunction;
    }
}

