/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.msm.components.BrakeComponent;
import com.turborilla.msm.components.LeaningComponent;
import com.turborilla.msm.components.NeuralNetRecorderComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.replay.AIRecordData;
import com.turborilla.msm.states.game.BikeResult;
import com.turborilla.msm.states.game.GameState;
import com.turborilla.msm.states.game.RaceResults;
import com.turborilla.utils.folders.SystemFolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NeuralNetZipRecorderComponent
extends NeuralNetRecorderComponent {
    private String filename;
    private boolean append;
    private AIRecordData data;
    private boolean inCountdown;
    private GameState gameState;
    private Object lock = new Object();

    public NeuralNetZipRecorderComponent(String string, GameState gameState, BikeGameObject bikeGameObject, BrakeComponent brakeComponent, ThrottleComponent throttleComponent, LeaningComponent leaningComponent) {
        super(string, gameState.getTrack(), bikeGameObject, brakeComponent, throttleComponent, leaningComponent);
        this.gameState = gameState;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(new FileInputStream(new File(SystemFolder.getUserCreatedContentFolder("AIRecording"), "AIrecording1218552640186.gz"))));
            AIRecordData aIRecordData = (AIRecordData)objectInputStream.readObject();
            objectInputStream.close();
            File file = new File(SystemFolder.getUserCreatedContentFolder("AIRecording"), "test.txt");
            file.createNewFile();
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.print(aIRecordData);
            printWriter.flush();
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void init() {
    }

    protected void record(float f) {
        if (!this.fillArray(f)) {
            return;
        }
        if (this.inCountdown) {
            this.data.countdownData.add(this.arr.clone());
        } else {
            this.data.raceData.add(this.arr.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording(String string, boolean bl) {
        if (this.gameState == null) {
            return;
        }
        this.track = this.gameState.getTrack();
        Object object = this.lock;
        synchronized (object) {
            this.totalTimeRecording = 0.0;
            this.recording = true;
            this.filename = string;
            this.append = bl;
            this.data = new AIRecordData();
            this.data.trackName = this.track.getName();
            this.data.trackLength = this.track.getActualLength();
            this.data.trackHash = this.hash(this.track.getOriginalHeightMap().getHeightMap());
            this.inCountdown = true;
        }
    }

    public void countdownFinished() {
        this.inCountdown = false;
    }

    public void raceFinished(RaceResults raceResults) {
        BikeResult bikeResult = raceResults.getBikeResult(this.bike.getName());
        this.data.profileName = bikeResult.getProfile().getName();
        this.data.mode = bikeResult.getProfile().getDifficulty().getName();
        this.data.numberOfCrashes = bikeResult.getNumberOfCrashes();
        this.data.passedFinishlineAt = bikeResult.getPassedFinishlineAtTime();
        this.data.passedStartlineAt = bikeResult.getPassedStartlineAtTime();
        this.data.trim();
        new Thread(new Runnable(){

            public void run() {
                NeuralNetZipRecorderComponent.this.stopRecording();
            }
        }).start();
    }

    protected OutputStream getOutput(String string, boolean bl) {
        String string2 = SystemFolder.getUserCreatedContentFolder("AIRecording");
        File file = new File(string2, string);
        if (!bl) {
            file.delete();
        }
        GZIPOutputStream gZIPOutputStream = null;
        try {
            file.createNewFile();
            gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(file, bl));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return gZIPOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        Object object = this.lock;
        synchronized (object) {
            this.recording = false;
            AIRecordData aIRecordData = this.data;
            this.data = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(this.getOutput(this.filename, this.append));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (objectOutputStream == null) {
                return;
            }
            try {
                objectOutputStream.writeObject(aIRecordData);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public long hash(int[] nArray) {
        int n = 378551;
        int n2 = 63689;
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l = l * (long)n2 + (long)nArray[i];
            n2 *= n;
        }
        return l;
    }
}

