/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector2f;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.components.BrakeComponent;
import com.turborilla.msm.components.LeaningComponent;
import com.turborilla.msm.components.ManySpatialsComponent;
import com.turborilla.msm.components.ThrottleComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.track.Track1D;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;

public class NeuralNetRecorderComponent
extends AbstractComponent {
    protected Track1D track;
    protected BikeGameObject bike;
    protected BrakeComponent brakeComp;
    protected ThrottleComponent throttleComp;
    protected LeaningComponent leaningComp;
    protected boolean recording = false;
    protected PrintWriter writer = null;
    protected int numberOfTrackHeightsToRecord = 20;
    protected double trackHeightStep = 2.0;
    protected double timeBetweenRecording = 0.2;
    protected double[] arr;
    private Vector2f leanRange;
    private Vector2f leanMin;
    protected double timeSinceLastRecording = 0.0;
    protected double totalTimeRecording = 0.0;
    protected boolean raceStarted = false;
    protected boolean passedFinishline = false;
    protected boolean crashing = false;
    private double[] max = new double[]{0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 5.522353124, 5.518338944, 5.51406172, 5.523613872, 5.521829244, 5.521691857, 5.518888738, 5.524361599, 5.524855735, 5.523236632, 9.506864636, 5.489831432, 1.73373867, 115.0705493, 0.999975276, 119.9998964, 0.5, 0.19999999, 1.5499988, 1.0, 1.0, 1.0, 0.4};
    private double[] min = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.40157122, -0.626011646, -2.122977018, -117.4406088, -0.999990391, -119.9520127, -0.5, -0.19999999, 0.0, -1.0, -1.0, -1.0, -0.4};
    private Vector3d yAxis = new Vector3d();
    private Vector3d yAxisPrev = new Vector3d();
    private Vector3d dir = new Vector3d();
    private Vector3d tempAngularVelocity = new Vector3d();
    private static final String raceStartedEvent = "RaceStarted";
    private static final String finishedEvent = "PassedFinishline";
    private static final String crashedEvent = "Crashed";
    private static final String backOnBikeEvent = "BackOnBike";

    public NeuralNetRecorderComponent(String string, Track1D track1D, BikeGameObject bikeGameObject, BrakeComponent brakeComponent, ThrottleComponent throttleComponent, LeaningComponent leaningComponent) {
        super(string);
        this.bike = bikeGameObject;
        this.track = track1D;
        this.brakeComp = brakeComponent;
        this.throttleComp = throttleComponent;
        this.leaningComp = leaningComponent;
        this.leanMin = leaningComponent.getLeanMin();
        this.leanRange = leaningComponent.getLeanMax().subtract(leaningComponent.getLeanMin());
        this.arr = new double[this.numberOfTrackHeightsToRecord + 11 + 4];
    }

    public void init() {
        this.eventManager.registerListener(raceStartedEvent, this);
        this.eventManager.registerListener(finishedEvent, this);
        this.eventManager.registerListener(crashedEvent, this);
        this.eventManager.registerListener(backOnBikeEvent, this);
    }

    public void startRecording(String string, boolean bl) {
        this.writer = this.getPrintWriter(string, bl);
        if (this.writer != null) {
            this.totalTimeRecording = 0.0;
            this.recording = true;
        }
    }

    protected PrintWriter getPrintWriter(String string, boolean bl) {
        String string2 = "NNrecordings/";
        File file = null;
        try {
            file = new File(ManySpatialsComponent.class.getClassLoader().getResource(string2).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        File file2 = new File(file, string);
        if (!bl) {
            file2.delete();
        }
        PrintWriter printWriter = null;
        try {
            file2.createNewFile();
            printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file2, bl)), true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return printWriter;
    }

    protected void componentUpdate(float f) {
        if (!this.recording) {
            return;
        }
        if (this.totalTimeRecording > 300.0) {
            return;
        }
        this.timeSinceLastRecording += (double)f;
        this.totalTimeRecording += (double)f;
        if (this.timeSinceLastRecording < this.timeBetweenRecording) {
            return;
        }
        this.timeSinceLastRecording = 0.0;
        this.record(f);
    }

    protected void record(float f) {
        if (!this.fillArray(f)) {
            return;
        }
        for (int i = 0; i < this.arr.length; ++i) {
            this.writer.print(this.arr[i]);
            if (i >= this.arr.length - 1) continue;
            this.writer.print(";");
        }
        this.writer.println();
        this.writer.flush();
    }

    protected boolean fillArray(float f) {
        if (!this.recordInputs(this.arr, f)) {
            return false;
        }
        this.recordOutputs(this.arr, this.arr.length - 4, f);
        return true;
    }

    private void recordOutputs(double[] dArray, int n, double d) {
        dArray[n++] = this.throttleComp.isThrottling() ? 1.0 : 0.0;
        dArray[n++] = this.brakeComp.isBraking() ? 1.0 : 0.0;
        dArray[n++] = (this.leaningComp.getLean().x - this.leanMin.x) / this.leanRange.x;
        dArray[n++] = (this.leaningComp.getLean().y - this.leanMin.y) / this.leanRange.y;
    }

    private boolean recordInputs(double[] dArray, double d) {
        int n = 0;
        Vector3d vector3d = this.bike.getBikeParticleSystem().getRearWheel().getWheelCenter().getPosition();
        double d2 = vector3d.x;
        double d3 = this.track.getInterpolatedHeightAt(d2);
        d2 += this.trackHeightStep;
        for (int i = 0; i < this.numberOfTrackHeightsToRecord; ++i) {
            double d4 = this.track.getInterpolatedHeightAt(d2);
            d2 += this.trackHeightStep;
            dArray[n++] = d4 - d3;
            d3 = d4;
        }
        dArray[n++] = vector3d.y;
        Vector3d vector3d2 = this.bike.getBikeParticleSystem().getRearWheel().getWheelCenter().getOldPosition();
        dArray[n++] = 100.0 * (vector3d.x - vector3d2.x);
        dArray[n++] = 100.0 * (vector3d.y - vector3d2.y);
        dArray[n++] = this.bike.getBikeParticleSystem().getRearWheel().getAngularVelocity(d);
        Matrix4d matrix4d = this.bike.getBikeParticleSystem().getFrame().getCoordinateFrame();
        Vector3d vector3d3 = new Vector3d(matrix4d.m10, matrix4d.m11, 0.0);
        vector3d3.normalizeLocal();
        double d5 = vector3d3.dot(Vector3d.UNIT_Y);
        dArray[n++] = d5;
        dArray[n++] = 1.0 / d * this.getAngularVelocity(matrix4d, this.bike.getBikeParticleSystem().getFrame().getPreviousCoordinateFrame());
        dArray[n++] = this.leaningComp.getActualLean().x;
        dArray[n++] = this.leaningComp.getActualLean().y;
        dArray[n++] = this.bike.getBikeParticleSystem().getAirborneForTime();
        dArray[n++] = this.totalTimeRecording;
        dArray[n++] = this.bike.getBikeParticleSystem().isCrashing() ? 1.0 : 0.0;
        return true;
    }

    private void normalize(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i >= 20 ? i + 10 : i;
            if (n >= dArray3.length) {
                return;
            }
            double d = dArray3[n] - dArray2[n];
            dArray[i] = (dArray[i] - dArray2[n]) / d;
            if (dArray[i] < 0.0) {
                dArray[i] = 0.0;
            }
            if (!(dArray[i] > 1.0)) continue;
            dArray[i] = 1.0;
        }
    }

    public double getAngularVelocity(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.yAxis.set(matrix4d.m10, matrix4d.m11, 0.0);
        this.yAxisPrev.set(matrix4d2.m10, matrix4d2.m11, 0.0);
        this.yAxis.subtract(this.yAxisPrev, this.tempAngularVelocity);
        this.yAxis.cross(this.yAxisPrev, this.dir);
        return Math.signum(this.dir.z) * this.tempAngularVelocity.length();
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (raceStartedEvent.equals(receivedEvent.getName())) {
            this.raceStarted = true;
            this.passedFinishline = false;
        } else if (finishedEvent.equals(receivedEvent.getName())) {
            if (this.gameObject.getName().equals(receivedEvent.getArgumentValue("gameObject"))) {
                this.passedFinishline = true;
            }
        } else if (crashedEvent.equals(receivedEvent.getName())) {
            if (this.gameObject.getName().equals(receivedEvent.getArgumentValue("gameObject"))) {
                this.crashing = true;
            }
        } else if (backOnBikeEvent.equals(receivedEvent.getName()) && this.gameObject.getName().equals(receivedEvent.getArgumentValue("gameObject"))) {
            this.crashing = false;
        }
        super.handleEvent(receivedEvent);
    }
}

