/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector2f;
import com.turborilla.event.typesafe.ReceivedEvent;
import com.turborilla.msm.components.BikeControlComponent;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.loaders.ResourceManager;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.states.MsmGameStateException;
import com.turborilla.msm.track.Track1D;
import com.turborilla.utils.math.Matrix4d;
import com.turborilla.utils.math.Vector3d;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.joone.engine.DirectSynapse;
import org.joone.engine.Layer;
import org.joone.engine.Pattern;
import org.joone.net.NeuralNet;

public class NNBikeControlComponent
extends BikeControlComponent {
    private static Logger logger = Logger.getLogger(NNBikeControlComponent.class.getCanonicalName());
    protected Track1D track;
    protected NeuralNet net;
    protected Pattern iPattern;
    protected Pattern oPattern;
    protected double[] iArr;
    protected double[] oArr;
    protected DirectSynapse netIn;
    protected DirectSynapse netOut;
    protected int numberOfTrackHeightsToRecord = 20;
    protected double trackHeightStep = 2.0;
    protected boolean stoppedAI = false;
    private double[] max = new double[]{0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 5.522353124, 5.518338944, 5.51406172, 5.523613872, 5.521829244, 5.521691857, 5.518888738, 5.524361599, 5.524855735, 5.523236632, 9.506864636, 5.489831432, 1.73373867, 115.0705493, 0.999975276, 119.9998964, 0.5, 0.19999999, 1.5499988, 1.0, 1.0, 1.0, 0.4};
    private double[] min = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.40157122, -0.626011646, -2.122977018, -117.4406088, -0.999990391, -119.9520127, -0.5, -0.19999999, 0.0, -1.0, -1.0, -1.0, -0.4};
    private Vector2f leanVector = new Vector2f();
    private Vector2f speedVector = new Vector2f();
    protected String raceStartedEvent = "RaceStarted";
    protected String finishedEvent = "PassedFinishline";
    protected String stopEvent = "StopAI";
    protected String startEvent = "StartAI";
    private Vector3d yAxis = new Vector3d();
    private Vector3d yAxisPrev = new Vector3d();
    private Vector3d dir = new Vector3d();
    private Vector3d tempAngularVelocity = new Vector3d();
    private Vector3d frameForward = new Vector3d();

    public NNBikeControlComponent(String string, Track1D track1D, BikeGameObject bikeGameObject, SpecialAbilityComponent specialAbilityComponent) {
        super(string, bikeGameObject, Difficulty.Simulation, specialAbilityComponent);
        this.track = track1D;
        this.iArr = new double[this.numberOfTrackHeightsToRecord + 9];
        this.oArr = new double[4];
        this.iPattern = new Pattern();
        this.oPattern = new Pattern();
        this.net = null;
        URL uRL = ResourceManager.findUrl("trained5", new String[]{"neuralNets"}, new String[]{"snet"});
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            this.net = (NeuralNet)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            throw new MsmGameStateException("Could not load NN due to " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MsmGameStateException("Could not load NN due to " + classNotFoundException);
        }
        this.net.getMonitor().setLearning(false);
        this.net.getTeacher().setEnabled(false);
        Layer layer = this.net.getInputLayer();
        layer.removeAllInputs();
        this.netIn = new DirectSynapse();
        layer.addInputSynapse(this.netIn);
        Layer layer2 = this.net.getOutputLayer();
        layer2.removeAllOutputs();
        this.netOut = new DirectSynapse();
        layer2.addOutputSynapse(this.netOut);
        this.net.getMonitor().setSingleThreadMode(true);
    }

    protected void processAI(double d) {
        int n = 0;
        if (!this.stoppedAI && this.net != null) {
            Vector3d vector3d = this.bike.getBikeParticleSystem().getRearWheel().getWheelCenter().getPosition();
            double d2 = vector3d.x;
            if (d2 + (double)this.numberOfTrackHeightsToRecord * this.trackHeightStep + this.trackHeightStep >= (double)this.track.getActualLength()) {
                return;
            }
            double d3 = this.track.getInterpolatedHeightAt(d2);
            d2 += this.trackHeightStep;
            for (int i = 0; i < this.numberOfTrackHeightsToRecord; ++i) {
                double d4 = this.track.getInterpolatedHeightAt(d2);
                d2 += this.trackHeightStep;
                this.iArr[n++] = d4 - d3;
                d3 = d4;
            }
            this.iArr[n++] = vector3d.y;
            Vector3d vector3d2 = this.bike.getBikeParticleSystem().getRearWheel().getWheelCenter().getOldPosition();
            this.iArr[n++] = 100.0 * (vector3d.x - vector3d2.x);
            this.iArr[n++] = 100.0 * (vector3d.y - vector3d2.y);
            this.iArr[n++] = this.bike.getBikeParticleSystem().getRearWheel().getAngularVelocity(d);
            Matrix4d matrix4d = this.bike.getBikeParticleSystem().getFrame().getCoordinateFrame();
            this.frameForward.set(matrix4d.m10, matrix4d.m11, 0.0);
            this.frameForward.normalizeLocal();
            double d5 = this.frameForward.dot(Vector3d.UNIT_Y);
            this.iArr[n++] = d5;
            this.iArr[n++] = 1.0 / d * this.getAngularVelocity(matrix4d, this.bike.getBikeParticleSystem().getFrame().getPreviousCoordinateFrame());
            this.iArr[n++] = 0.0;
            this.iArr[n++] = 0.0;
            this.iArr[n++] = this.bike.getBikeParticleSystem().getAirborneForTime();
            if (n != 29) {
                System.out.println("Index is only " + n + " in NNBikeControlComponent");
            }
            this.normalize(this.iArr, this.min, this.max);
            this.iPattern.setArray(this.iArr);
            this.iPattern.setCount(1);
            this.netIn.fwdPut(this.iPattern);
            this.net.singleStepForward(null);
            this.oPattern = this.netOut.fwdGet();
            this.oArr = this.oPattern.getArray();
            if (this.oArr[0] > 0.7) {
                this.oArr[0] = 0.7;
            }
            this.getThrottleComponent().throttling((float)this.oArr[0]);
            this.getFrontBrakeComponent().braking((float)this.oArr[1]);
            this.getRearBrakeComponent().braking((float)this.oArr[1]);
            this.leanVector.set((float)this.oArr[2] - 0.5f, (float)this.oArr[3] * 0.4f - 0.2f);
            this.leanVector.set(this.leanVector.x, -0.5f);
            this.getLeaningComponent().setLean(this.leanVector);
        }
    }

    private void normalize(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            int n = i >= 20 ? i + 10 : i;
            double d = dArray3[n] - dArray2[n];
            dArray[i] = (dArray[i] - dArray2[n]) / d;
            if (dArray[i] < 0.0) {
                dArray[i] = 0.0;
            }
            if (!(dArray[i] > 1.0)) continue;
            dArray[i] = 1.0;
        }
    }

    protected void attachComponents() {
        super.attachComponents();
        this.eventManager.registerListener(this.raceStartedEvent, this);
        this.eventManager.registerListener(this.finishedEvent, this);
        this.eventManager.registerListener(this.stopEvent, this);
        this.eventManager.registerListener(this.startEvent, this);
    }

    public void onDetach() {
        super.onDetach();
    }

    protected void componentUpdate(float f) {
        this.processAI(f);
        super.componentUpdate(f);
    }

    public void handleEvent(ReceivedEvent receivedEvent) {
        if (this.stopEvent.equals(receivedEvent.getName())) {
            this.stoppedAI = true;
        } else if (this.startEvent.equals(receivedEvent.getName())) {
            this.stoppedAI = false;
        }
        super.handleEvent(receivedEvent);
    }

    public double getAngularVelocity(Matrix4d matrix4d, Matrix4d matrix4d2) {
        this.yAxis.set(matrix4d.m10, matrix4d.m11, 0.0);
        this.yAxisPrev.set(matrix4d2.m10, matrix4d2.m11, 0.0);
        this.yAxis.subtract(this.yAxisPrev, this.tempAngularVelocity);
        this.yAxis.cross(this.yAxisPrev, this.dir);
        return Math.signum(this.dir.z) * this.tempAngularVelocity.length();
    }

    public boolean isStoppedAI() {
        return this.stoppedAI;
    }

    public void setStoppedAI(boolean bl) {
        this.stoppedAI = bl;
    }
}

