/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.bounding.BoundingBox;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.turborilla.TransformationCoupler;
import com.turborilla.TransformationProvider;
import com.turborilla.gameobject.AbstractComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManySpatialsComponent
extends AbstractComponent {
    private static final Logger logger = Logger.getLogger(ManySpatialsComponent.class.getName());
    private ArrayList<Entry> spatialMap = new ArrayList();
    private Node node = new Node(this.getName() + ":node");

    public ManySpatialsComponent(String string) {
        super(string);
        this.node.setModelBound(new BoundingBox());
        this.node.updateModelBound();
    }

    @Override
    protected void handleMessages(float f) {
    }

    @Override
    protected void componentUpdate(float f) {
        for (int i = 0; i < this.spatialMap.size(); ++i) {
            Entry entry = this.spatialMap.get(i);
            Node node = entry.node;
            TransformationProvider transformationProvider = entry.transformationProvider;
            transformationProvider.getLocalTranslation().toVector3f(node.getLocalTranslation());
            transformationProvider.getLocalRotation().toFloatQuaternion(node.getLocalRotation());
            transformationProvider.getLocalScale().toVector3f(node.getLocalScale());
        }
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isEmpty() {
        return this.spatialMap.isEmpty();
    }

    public void put(Spatial spatial, TransformationProvider transformationProvider) {
        if (spatial == null || transformationProvider == null) {
            logger.warning("Tried to add Spatial or TransformationProvider that was NULL");
            return;
        }
        Entry entry = new Entry();
        entry.node = new Node(spatial.getName() + ":node");
        this.node.attachChild(entry.node);
        entry.node.attachChild(spatial);
        entry.transformationProvider = transformationProvider;
        this.spatialMap.add(entry);
    }

    public boolean remove(Spatial spatial) {
        Iterator<Entry> iterator = this.spatialMap.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.node.getChild(0) != spatial) continue;
            this.node.detachChild(entry.node);
            iterator.remove();
            return true;
        }
        return false;
    }

    public void removeAll() {
        for (int i = 0; i < this.spatialMap.size(); ++i) {
            Entry entry = this.spatialMap.get(i);
            entry.node.detachAllChildren();
            this.node.detachChild(entry.node);
        }
        this.spatialMap.clear();
    }

    public int size() {
        return this.spatialMap.size();
    }

    public ArrayList<TransformationProvider> getProviderList() {
        ArrayList<TransformationProvider> arrayList = new ArrayList<TransformationProvider>();
        for (int i = 0; i < this.spatialMap.size(); ++i) {
            arrayList.add(this.spatialMap.get((int)i).transformationProvider);
        }
        return arrayList;
    }

    private class Entry {
        Node node;
        TransformationProvider transformationProvider;
        TransformationCoupler transformationCoupler;

        private Entry() {
        }
    }
}

