/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector2f;
import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.physics.objects.BikeRider;

public class LeaningComponent
extends AbstractComponent {
    private Vector2f leanCenter = new Vector2f(0.0f, 0.0f);
    private Vector2f leanMin = new Vector2f(-0.5f, -0.2f);
    private Vector2f leanMax = new Vector2f(0.5f, 0.2f);
    private Vector2f lean = new Vector2f(this.leanCenter);
    private Vector2f actualLean = new Vector2f(this.lean);
    private Vector2f speed = new Vector2f(0.08f, 0.08f);
    private BikeRider rider;
    private Vector2f diff = new Vector2f();
    private boolean overrideXLean = false;
    private float overridingXLean = 0.0f;
    private boolean overrideYLean = false;
    private float overridingYLean = 0.0f;

    public BikeRider getRider() {
        return this.rider;
    }

    public void setRider(BikeRider bikeRider) {
        this.rider = bikeRider;
    }

    public LeaningComponent(String string, BikeRider bikeRider) {
        super(string);
        this.rider = bikeRider;
    }

    protected void handleMessages(float f) {
    }

    protected void componentUpdate(float f) {
        this.clampLean(this.diff.set(this.lean)).subtractLocal(this.actualLean);
        this.diff.multLocal(this.speed).multLocal(f * 100.0f);
        this.actualLean.addLocal(this.diff);
        this.clampLean(this.actualLean);
        double[] dArray = new double[]{this.actualLean.x, this.actualLean.y};
        if (this.overrideXLean) {
            this.overrideXLean = false;
            if (this.overridingXLean > this.leanMax.x) {
                this.overridingXLean = this.leanMax.x;
            }
            if (this.overridingXLean < this.leanMin.x) {
                this.overridingXLean = this.leanMin.x;
            }
            dArray[0] = this.overridingXLean;
        }
        if (this.overrideYLean) {
            this.overrideYLean = false;
            if (this.overridingYLean > this.leanMax.y) {
                this.overridingYLean = this.leanMax.y;
            }
            if (this.overridingYLean < this.leanMin.y) {
                this.overridingYLean = this.leanMin.y;
            }
            dArray[1] = this.overridingYLean;
        }
        this.rider.lean(dArray);
    }

    public void setOverridingHorisontalLean(float f) {
        this.overrideXLean = true;
        this.overridingXLean = f;
    }

    public void setOverridingVerticalLean(float f) {
        this.overrideYLean = true;
        this.overridingYLean = f;
    }

    public Vector2f getLean() {
        return this.lean;
    }

    public void setLean(Vector2f vector2f) {
        this.lean = vector2f;
        this.clampLean(this.lean);
    }

    public void setLeanX(float f) {
        this.lean.x = f > 0.0f ? f * this.leanMax.x : -f * this.leanMin.x;
        this.clampLean(this.lean);
    }

    public void setLeanY(float f) {
        this.lean.y = f > 0.0f ? f * this.leanMax.y : -f * this.leanMin.y;
        this.clampLean(this.lean);
    }

    public void addLean(Vector2f vector2f) {
        if (this.isPaused()) {
            return;
        }
        this.lean.addLocal(vector2f);
    }

    public void addLean(float f, float f2) {
        if (this.isPaused()) {
            return;
        }
        this.lean.addLocal(f, f2);
    }

    private Vector2f clampLean(Vector2f vector2f) {
        if (vector2f.x > this.leanMax.x) {
            vector2f.x = this.leanMax.x;
        }
        if (vector2f.y > this.leanMax.y) {
            vector2f.y = this.leanMax.y;
        }
        if (vector2f.x < this.leanMin.x) {
            vector2f.x = this.leanMin.x;
        }
        if (vector2f.y < this.leanMin.y) {
            vector2f.y = this.leanMin.y;
        }
        return vector2f;
    }

    public Vector2f getLeanCenter() {
        return this.leanCenter;
    }

    public void setLeanCenter(Vector2f vector2f) {
        this.leanCenter = vector2f;
    }

    public Vector2f getLeanMax() {
        return this.leanMax;
    }

    public void setLeanMax(Vector2f vector2f) {
        this.leanMax = vector2f;
        this.clampLean(this.lean);
    }

    public Vector2f getLeanMin() {
        return this.leanMin;
    }

    public void setLeanMin(Vector2f vector2f) {
        this.leanMin = vector2f;
        this.clampLean(this.lean);
    }

    public Vector2f getSpeed() {
        return this.speed;
    }

    public void setSpeed(Vector2f vector2f) {
        this.speed = vector2f;
        vector2f.x = vector2f.x > 1.0f ? 1.0f : vector2f.x;
        vector2f.y = vector2f.y > 1.0f ? 1.0f : vector2f.y;
        vector2f.x = vector2f.x < 0.0f ? 0.0f : vector2f.x;
        vector2f.y = vector2f.y < 0.0f ? 0.0f : vector2f.y;
    }

    public Vector2f getActualLean() {
        return this.actualLean;
    }
}

