/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.turborilla.msm.components.BoostComponentWithFX;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.gameobjects.ParticleFXGameObject;
import com.turborilla.msm.physics.objects.Bike;
import java.io.IOException;
import org.softmed.jops.fileloading.DataFormatException;

public class JetpackComponent
extends BoostComponentWithFX {
    private float reloadTime;
    private float timeSinceLastReload;
    private Vector3f foot;
    private Vector3f knee;
    private Vector3f xVec;
    private Vector3f yVec;

    public JetpackComponent(String string, float f, float f2, Bike bike) {
        super(string, f, f2, bike);
        this.timeSinceLastReload = this.reloadTime = 5.0f;
        this.foot = new Vector3f();
        this.knee = new Vector3f();
        this.xVec = new Vector3f();
        this.yVec = new Vector3f();
        this.setInitialExplosion(true);
    }

    public FXGameObject getFX() {
        if (this.particleFXGameObject != null) {
            return this.particleFXGameObject;
        }
        this.particleFXGameObject = new ParticleFXGameObject("jetpackFX", 2);
        try {
            this.particleFXGameObject.load("jetpack");
        }
        catch (IOException iOException) {
            this.particleFXGameObject = null;
        }
        catch (DataFormatException dataFormatException) {
            this.particleFXGameObject = null;
        }
        if (this.particleFXGameObject != null) {
            this.particleFXGameObject.setParticlesWorldOriented(false);
            this.particleFXGameObject.setRepeat(false);
            this.particleFXGameObject.getParticleSystem(0).setLimited(false);
            this.particleFXGameObject.getNode(0).setLocalScale(3.5f);
            this.particleFXGameObject.getParticleSystem(1).setLimited(false);
            this.particleFXGameObject.getNode(1).setLocalScale(3.5f);
        }
        return this.particleFXGameObject;
    }

    public void triggerSpecialAbility() {
        if (this.timeSinceLastReload < this.reloadTime) {
            return;
        }
        this.bike.getRider().crash(0.9999f);
        this.amountLeft = this.initialAmount;
        super.triggerSpecialAbility();
        this.timeSinceLastReload = 0.0f;
    }

    protected void componentUpdate(float f) {
        this.timeSinceLastReload += f;
        super.componentUpdate(f);
    }

    protected void setMagnitude(float f) {
        this.bike.setJetpackMagnitude(f);
    }

    protected void alignNodeWithBike() {
        if (this.bike != null && this.particleFXGameObject != null) {
            for (int i = 0; i < 2; ++i) {
                Node node = this.particleFXGameObject.getNode(i);
                if (i == 0) {
                    this.bike.getRider().getLeftFoot().getPosition().toVector3f(this.foot);
                    this.bike.getRider().getLeftKnee().getPosition().toVector3f(this.knee);
                } else {
                    this.bike.getRider().getRightFoot().getPosition().toVector3f(this.foot);
                    this.bike.getRider().getRightKnee().getPosition().toVector3f(this.knee);
                }
                this.foot.subtract(this.knee, this.xVec);
                this.xVec.normalizeLocal();
                Vector3f.UNIT_Z.cross(this.xVec, this.yVec);
                this.floatQuat.fromAxes(this.xVec, this.yVec, Vector3f.UNIT_Z);
                node.getLocalRotation().set(this.floatQuat);
                node.getLocalTranslation().set(this.foot);
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

