/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.input.InputHandler;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.util.TwoButtonAxis;
import com.turborilla.msm.components.BikeControlComponent;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.gameobjects.BikeGameObject;
import com.turborilla.msm.input.BailAction;
import com.turborilla.msm.input.BrakeAction;
import com.turborilla.msm.input.JoystickAxis;
import com.turborilla.msm.input.JoystickButton;
import com.turborilla.msm.input.LeaningAction;
import com.turborilla.msm.input.SpecialAbilityAction;
import com.turborilla.msm.input.ThrottleAction;
import com.turborilla.msm.profile.Difficulty;
import com.turborilla.msm.profile.InputData;
import com.turborilla.msm.profile.KeyboardData;
import com.turborilla.msm.profile.MouseData;

public class HumanBikeControlComponent
extends BikeControlComponent
implements InputData.IInputDataChangedListener {
    private InputHandler input;
    private JoystickAxis joystickAxisX;
    private JoystickAxis joystickAxisY;
    private JoystickButton joystickButton0;
    private JoystickButton joystickButton1;
    private JoystickButton joystickButton2;
    private SpecialAbilityAction specialAbilityAction;
    private InputData inputData;
    private LeaningAction leaningAction;
    private ThrottleAction throttleAction;
    private BrakeAction rearBrakeAction;
    private BrakeAction frontBrakeAction;
    private BailAction bailAction;
    private TwoButtonAxis leanLeftRight;

    public HumanBikeControlComponent(String string, BikeGameObject bikeGameObject, InputHandler inputHandler, InputData inputData) {
        this(string, bikeGameObject, inputHandler, Difficulty.Arcade, inputData, null);
    }

    public HumanBikeControlComponent(String string, BikeGameObject bikeGameObject, InputHandler inputHandler, Difficulty difficulty, InputData inputData, SpecialAbilityComponent specialAbilityComponent) {
        super(string, bikeGameObject, difficulty, specialAbilityComponent);
        this.input = inputHandler;
        this.inputData = inputData;
        inputData.addChangeListener(this);
    }

    public void update(float f) {
        super.update(f);
        if (this.joystickAxisX != null) {
            this.joystickAxisX.update(f);
            this.joystickAxisY.update(f);
            this.joystickButton0.update(f);
            this.joystickButton1.update(f);
            this.joystickButton2.update(f);
        }
    }

    protected void attachComponents() {
        super.attachComponents();
        this.inputDataChanged(this.inputData);
    }

    private void setupInputActions() {
        float f = 4.0f;
        this.input.removeAction(this.leaningAction);
        this.input.removeAction(this.throttleAction);
        this.input.removeAction(this.rearBrakeAction);
        this.input.removeAction(this.frontBrakeAction);
        this.input.removeAction(this.specialAbilityAction);
        this.input.removeAction(this.bailAction);
        if (this.leanLeftRight != null) {
            this.input.removeAction(this.leanLeftRight.getDecreaseAction());
            this.input.removeAction(this.leanLeftRight.getIncreaseAction());
        }
        this.leaningAction = new LeaningAction(this.leaningComponent);
        this.throttleAction = new ThrottleAction(this.throttleComponent);
        this.rearBrakeAction = new BrakeAction(this.rearBrakeComponent);
        this.frontBrakeAction = new BrakeAction(this.frontBrakeComponent);
        this.specialAbilityAction = new SpecialAbilityAction(this.specialAbilityComponent);
        this.bailAction = new BailAction(this.bailComponent);
        if (this.inputData.getDevice() == InputData.Device.Gamepad && this.joystickAxisX == null) {
            this.inputData.setDevice(InputData.Device.Keyboard);
        }
        if (this.inputData.getDevice() == InputData.Device.Gamepad) {
            this.input.addAction(this.leaningAction, this.joystickAxisX.getDeviceName(), -1, this.joystickAxisX.getIndex(), false);
            this.input.addAction(this.leaningAction, this.joystickAxisY.getDeviceName(), -1, this.joystickAxisY.getIndex(), false);
            this.leaningAction.setXAxisIndex(this.joystickAxisX.getIndex());
            this.leaningAction.setYAxisIndex(this.joystickAxisY.getIndex());
            this.input.addAction(this.throttleAction, this.joystickButton0.getDeviceName(), this.joystickButton0.getIndex(), -1, true);
            this.input.addAction(this.rearBrakeAction, this.joystickButton1.getDeviceName(), this.joystickButton1.getIndex(), -1, true);
            this.input.addAction(this.frontBrakeAction, this.joystickButton1.getDeviceName(), this.joystickButton1.getIndex(), -1, true);
            this.input.addAction(this.specialAbilityAction, this.joystickButton2.getDeviceName(), this.joystickButton2.getIndex(), -1, false);
        } else if (this.inputData.getDevice() == InputData.Device.Keyboard) {
            KeyboardData keyboardData = this.inputData.getKeyboardData();
            this.leanLeftRight = new TwoButtonAxis("left_right");
            this.input.addAction(this.leanLeftRight.getDecreaseAction(), "keyboard", keyboardData.getLeft(), -1, true);
            this.input.addAction(this.leanLeftRight.getIncreaseAction(), "keyboard", keyboardData.getRight(), -1, true);
            this.leanLeftRight.getDecreaseAction().setSpeed(f);
            this.leanLeftRight.getIncreaseAction().setSpeed(f);
            this.leaningAction.setXAxisIndex(this.leanLeftRight.getIndex());
            this.input.addAction(this.leaningAction, this.leanLeftRight.getDeviceName(), -1, this.leanLeftRight.getIndex(), false);
            this.input.addAction(this.throttleAction, "keyboard", keyboardData.getThrottle(), -1, true);
            this.input.addAction(this.rearBrakeAction, "keyboard", keyboardData.getBrake(), -1, true);
            this.input.addAction(this.frontBrakeAction, "keyboard", keyboardData.getBrake(), -1, true);
            this.input.addAction(this.specialAbilityAction, "keyboard", keyboardData.getSpecial(), -1, false);
        } else if (this.inputData.getDevice() == InputData.Device.Mouse) {
            MouseData mouseData = this.inputData.getMouseData();
            float f2 = mouseData.getSensitivity();
            this.leaningAction.setLeanInputRanges(0.45f * f2, 0.45f * f2, 1.0f - 0.45f * f2, 1.0f - 0.45f * f2);
            this.leaningAction.setRelative(true);
            if (this.difficulty == Difficulty.Arcade) {
                this.leaningAction.setAccumulative(true);
            }
            this.input.addAction(this.leaningAction, "mouse", -1, Integer.MIN_VALUE, false);
            this.input.addAction(this.throttleAction, "mouse", mouseData.getThrottleMouse(), -1, true);
            this.input.addAction(this.rearBrakeAction, "mouse", mouseData.getBrakeMouse(), -1, true);
            this.input.addAction(this.frontBrakeAction, "mouse", mouseData.getBrakeMouse(), -1, true);
            this.input.addAction(this.specialAbilityAction, "mouse", mouseData.getSpecialMouse(), -1, false);
            this.input.addAction(this.throttleAction, "keyboard", mouseData.getThrottleKey(), -1, true);
            this.input.addAction(this.rearBrakeAction, "keyboard", mouseData.getBrakeKey(), -1, true);
            this.input.addAction(this.frontBrakeAction, "keyboard", mouseData.getBrakeKey(), -1, true);
            this.input.addAction(this.specialAbilityAction, "keyboard", mouseData.getSpecialKey(), -1, false);
        }
        this.input.addAction(this.bailAction, "keyboard", 48, -1, true);
        this.leaningAction.setGyroComponent(this.gyroComponent);
    }

    public void changeSpecialAbility(SpecialAbilityComponent specialAbilityComponent) {
        super.changeSpecialAbility(specialAbilityComponent);
        if (this.specialAbilityAction != null) {
            this.input.removeAction(this.specialAbilityAction);
        }
        this.specialAbilityComponent = specialAbilityComponent;
        this.setupInputActions();
    }

    public void inputDataChanged(InputData inputData) {
        this.inputData = inputData;
        this.setupJoystickAxes(inputData);
        this.setupInputActions();
    }

    private void setupJoystickAxes(InputData inputData) {
        int n = inputData.getJoystickData().getJoystickIndex();
        this.joystickAxisX = null;
        if (n < JoystickInput.get().getJoystickCount() && inputData.getDevice() == InputData.Device.Gamepad) {
            Joystick joystick = JoystickInput.get().getJoystick(n);
            this.joystickAxisX = new JoystickAxis("joyX", joystick, inputData.getJoystickData().getXAxisIndex());
            this.joystickAxisY = new JoystickAxis("joyY", joystick, inputData.getJoystickData().getYAxisIndex());
            this.joystickButton0 = new JoystickButton("joyThrottle", joystick, inputData.getJoystickData().getThrottleButtonIndex());
            this.joystickButton1 = new JoystickButton("joyBrake", joystick, inputData.getJoystickData().getBrakeButtonIndex());
            this.joystickButton2 = new JoystickButton("joySpecial", joystick, inputData.getJoystickData().getSpecialButtonIndex());
            this.joystickAxisX.setMaximum(inputData.getJoystickData().getXAxisMaximumValue());
            this.joystickAxisX.setMinimum(inputData.getJoystickData().getXAxisMinimumValue());
            this.joystickAxisY.setMaximum(inputData.getJoystickData().getYAxisMaximumValue());
            this.joystickAxisY.setMinimum(inputData.getJoystickData().getYAxisMinimumValue());
            this.joystickAxisX.setInverted(inputData.getJoystickData().isXAxisInverted());
            this.joystickAxisY.setInverted(inputData.getJoystickData().isYAxisInverted());
            if (this.difficulty == Difficulty.Arcade) {
                this.joystickAxisX.setArcade(true);
                this.joystickAxisY.setArcade(true);
                this.joystickAxisX.setFactor(4.0f);
                this.joystickAxisY.setFactor(4.0f);
            } else {
                this.joystickAxisX.setArcade(false);
                this.joystickAxisY.setArcade(false);
                this.joystickAxisX.setFactor(1.0f);
                this.joystickAxisY.setFactor(1.0f);
            }
        } else {
            this.joystickAxisX = null;
            if (inputData.getDevice() == InputData.Device.Gamepad) {
                inputData.setDevice(InputData.Device.Keyboard);
            }
        }
    }
}

