/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.msm.components.LeaningComponent;
import com.turborilla.msm.physics.objects.Bike;
import com.turborilla.msm.physics.objects.BikeFrame;
import com.turborilla.physics.particle.Force;
import com.turborilla.physics.particle.Particle;
import com.turborilla.utils.math.Vector3d;

public class GyroComponent
extends AbstractComponent {
    private BikeFrame frame;
    private Bike bike;
    private double angle = 0.0;
    private double bikeAngle = 0.0;
    private double maxTilt = 250.0;
    private double minTilt = -250.0;
    private Force rearForce;
    private Force frontForce;
    private Particle rearTarget;
    private Particle frontTarget;
    private Particle rearTowards;
    private Particle frontTowards;
    private LeaningComponent leaningComponent;
    private static Vector3d tempVec = new Vector3d();
    private static Vector3d rearToFrontWheel = new Vector3d();
    private static Vector3d bikeUp = new Vector3d();
    private static Vector3d tempVec2 = new Vector3d();
    private double prevBikeAngle = 0.0;
    private double prevDiff = 0.0;
    private int steps = 30;
    private double[] diffs = new double[this.steps];
    private int currentStep = 0;
    private double invMaxDiff = 0.7957747154594768;
    private double permanentAdderAmount = 0.0;
    private double HALF_PI = 1.5707963267948966;
    private double PI = Math.PI;
    private double INV_PI = 0.3183098861837907;
    private double TWO_PI = Math.PI * 2;
    private double INV_TWO_PI = 1.0 / this.TWO_PI;
    private double bikeChange;
    private static final double MAX_FORCE = 350.0;

    public GyroComponent(Bike bike, LeaningComponent leaningComponent) {
        super("GyroComponent");
        this.frame = bike.getFrame();
        this.bike = bike;
        this.leaningComponent = leaningComponent;
        this.rearTarget = this.frame.getRearDamperAttachment();
        this.frontTarget = this.frame.getFork();
        this.rearTowards = this.frame.getRearDamperAnchor();
        this.frontTowards = this.frame.getFork();
        this.rearForce = new Force(this.rearTarget, new Vector3d(), 0.0);
        this.frontForce = new Force(this.frontTarget, new Vector3d(), 0.0);
        this.frame.addForce(this.rearForce);
        this.frame.addForce(this.frontForce);
    }

    protected void componentUpdate(float f) {
        if (!this.bike.isCrashing()) {
            this.addTilt(this.permanentAdderAmount);
            this.clampTilt();
            this.bikeAngle = this.getVectorUpAngle(this.getBikeUp(bikeUp));
            this.bikeChange = this.getAngleDiff(this.bikeAngle, this.prevBikeAngle);
            if (this.bike.isAirborne()) {
                this.angle += this.bikeChange;
            }
            double d = this.getAngleDiff(this.angle, this.bikeAngle);
            double d2 = this.angle - this.bikeAngle * 0.5;
            this.prevBikeAngle = this.bikeAngle;
            this.angle -= d * (double)f * 2.0;
            double d3 = 0.0;
            double d4 = (d - this.prevDiff) / (double)f;
            double d5 = d;
            double d6 = d4;
            double d7 = 0.0;
            this.diffs[this.currentStep] = d * (double)f;
            ++this.currentStep;
            if (this.currentStep >= this.steps) {
                this.currentStep = 0;
            }
            for (double d8 : this.diffs) {
                d7 += d8;
            }
            d3 = d5 + (d7 /= (double)this.steps * (double)f) + d6;
            d3 *= 60.0;
            this.prevDiff = d;
            this.leaningComponent.setOverridingHorisontalLean((float)(d * this.invMaxDiff));
            this.leaningComponent.setOverridingVerticalLean(-0.4f);
            if (d3 > 0.0) {
                this.rearForce.getDirection().set(bikeUp);
                this.frontForce.getDirection().set(bikeUp).multLocal(-1.0);
            } else {
                d3 = -d3;
                this.rearForce.getDirection().set(bikeUp).multLocal(-1.0);
                this.frontForce.getDirection().set(bikeUp);
            }
            if (d3 > 350.0) {
                d3 = 350.0;
            }
            this.rearForce.setMagnitude(d3);
            this.frontForce.setMagnitude(d3);
        } else {
            this.rearForce.setMagnitude(0.0);
            this.frontForce.setMagnitude(0.0);
        }
    }

    private double getAngleDiff(double d, double d2) {
        double d3 = d - d2;
        if (d3 < -3.7699111843077517) {
            d3 += this.TWO_PI;
        } else if (d3 > 3.7699111843077517) {
            d3 -= this.TWO_PI;
        }
        return d3;
    }

    public void addPermanentTilt(double d) {
        this.permanentAdderAmount = d;
    }

    public void addTilt(double d) {
        if (this.isPaused()) {
            return;
        }
        double d2 = this.getAngleDiff(this.angle, this.bikeAngle);
        if (d2 < 0.0 && d > 0.0) {
            this.angle = this.bikeAngle;
        }
        if (d2 > 0.0 && d < 0.0) {
            this.angle = this.bikeAngle;
        }
        this.angle += d * 0.5;
        if (this.bike.isAirborne()) {
            if (this.bikeChange < -0.05235987755982988 && d <= 0.0) {
                this.angle -= d2 * (double)0.7f * (0.05235987755982988 - this.bikeChange);
            } else if (this.bikeChange > 0.05235987755982988 && d >= 0.0) {
                this.angle += d2 * (double)0.7f * (0.05235987755982988 - this.bikeChange);
            }
        }
        if (this.bikeChange < 0.0 && d > 0.0) {
            this.angle -= d * (this.bikeChange * this.INV_PI * 120.0);
        } else if (this.bikeChange > 0.0 && d < 0.0) {
            this.angle += d * (this.bikeChange * this.INV_PI * 120.0);
        }
    }

    protected void clampTilt() {
        double d = this.angle * this.INV_TWO_PI;
        this.angle -= (double)((int)d) * this.TWO_PI;
        if (this.angle > this.PI) {
            this.angle = -(this.TWO_PI - this.angle);
        } else if (this.angle < -this.PI) {
            this.angle = this.TWO_PI + this.angle;
        }
    }

    protected double getVectorUpAngle(Vector3d vector3d) {
        double d = 0.0;
        d = Math.acos(vector3d.y);
        if (vector3d.x < 0.0) {
            d = -d;
        }
        return d;
    }

    protected Vector3d getBikeUp(Vector3d vector3d) {
        this.bike.getFrontWheel().getCenterOfMass(rearToFrontWheel);
        this.bike.getRearWheel().getCenterOfMass(vector3d);
        rearToFrontWheel.subtractLocal(vector3d);
        rearToFrontWheel.normalizeLocal();
        Vector3d.UNIT_Z.cross(rearToFrontWheel, vector3d);
        return vector3d;
    }

    public void onDetach() {
        this.frame.removeForce(this.rearForce);
        this.frame.removeForce(this.frontForce);
        super.onDetach();
    }

    public void setPaused(boolean bl) {
        super.setPaused(bl);
        if (bl) {
            this.rearForce.setMagnitude(0.0);
            this.frontForce.setMagnitude(0.0);
            this.angle = 0.0;
        }
    }

    public double getMaxTilt() {
        return this.maxTilt;
    }

    public void setMaxTilt(double d) {
        this.maxTilt = d;
    }

    public double getMinTilt() {
        return this.minTilt;
    }

    public void setMinTilt(double d) {
        this.minTilt = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getBikeAngle() {
        return this.bikeAngle;
    }
}

