/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.turborilla.msm.components.SpecialAbilityComponent;
import com.turborilla.msm.gameobjects.FXGameObject;
import com.turborilla.msm.gameobjects.GlideFXGameObject;
import com.turborilla.msm.physics.objects.Bike;
import java.io.IOException;

public class GlideComponent
extends SpecialAbilityComponent {
    private boolean gliding = false;
    private GlideFXGameObject glideFX;
    private Bike bike;
    protected Vector3f tempVec = new Vector3f();
    protected Quaternion floatQuat = new Quaternion();
    protected Quaternion angle = new Quaternion(new float[]{0.0f, 0.0f, -1.5f});

    public GlideComponent(String string, Bike bike) {
        super(string);
        this.bike = bike;
    }

    public void reset() {
        this.setGliding(false);
    }

    public void triggerSpecialAbility() {
        if (!this.isGliding()) {
            this.setGliding(true);
        } else {
            this.setGliding(false);
        }
        if (this.getTriggerListener() != null) {
            this.getTriggerListener().triggered(this);
        }
    }

    protected void componentUpdate(float f) {
        if (this.isGliding()) {
            this.bike.setGliding(true);
        }
        if (this.isGliding() || this.glideFX.getScaling()) {
            this.alignWithBike();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.setGliding(false);
        }
    }

    public FXGameObject getFX() {
        if (this.glideFX == null) {
            this.glideFX = new GlideFXGameObject();
            try {
                this.glideFX.init();
            }
            catch (IOException iOException) {
                this.glideFX = null;
            }
        }
        return this.glideFX;
    }

    protected void alignWithBike() {
        if (this.bike != null) {
            Node node = this.getFX().getNode();
            this.bike.getFrame().getFootrest().getPosition().toVector3f(this.tempVec);
            this.bike.getFrame().getLocalRotation().toFloatQuaternion(this.floatQuat);
            this.floatQuat.multLocal(this.angle);
            node.getLocalRotation().set(this.floatQuat);
            node.getLocalTranslation().set(this.tempVec);
        }
    }

    public boolean isGliding() {
        return this.gliding;
    }

    public void setGliding(boolean bl) {
        if (!this.isGliding() && bl) {
            this.glideFX.scaleYTo(1.0f, 0.7f);
        } else if (this.isGliding() && !bl) {
            this.glideFX.scaleYTo(0.0f, 0.7f);
        }
        this.gliding = bl;
    }
}

