/*
 * Decompiled with CFR 0.152.
 */
package com.turborilla.msm.components;

import com.turborilla.gameobject.AbstractComponent;
import com.turborilla.physics.particle.ConstraintStick;
import com.turborilla.sound.SFX;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DamperSoundComponent
extends AbstractComponent {
    private ArrayList<ConstraintStick> bottomOutDampers;
    private boolean[] playedBottomedOut;
    private double[] maxBottomedOut;
    private ArrayList<ConstraintStick> dampers;
    private double[] damperPreviousLength;
    private int[] damperPlaying;
    private SFX bottomOutSound;
    private SFX damperSoundCompress;
    private SFX damperSoundDeflate;
    private double bottomOutThreshold = 0.03;
    private double bottomOutMinVolume = 0.02;
    private double bottomOutMaxVolume = 0.1;
    private double bottomOutDeltaVolume = 10.0;
    private double damperSpeedThreshold = 0.01;
    private double damperMinVolume = 1.0E-4;
    private double damperMaxVolume = 1.0E-4;
    private double damperDeltaVolume = 0.01;
    private double damperMinPitch = 0.5;
    private double damperMaxPitch = 2.0;
    private double damperDeltaPitch = 10.0;
    private double pitchRandomizer = 0.5;

    public DamperSoundComponent(String string, SFX sFX, SFX sFX2, SFX sFX3) {
        super(string);
        this.damperSoundCompress = sFX2;
        this.damperSoundDeflate = sFX3;
        this.bottomOutSound = sFX;
        this.bottomOutDampers = new ArrayList();
        this.dampers = new ArrayList();
    }

    @Override
    protected void componentUpdate(float f) {
        double d;
        double d2;
        ConstraintStick constraintStick;
        int n;
        if (this.bottomOutSound != null) {
            for (n = 0; n < this.bottomOutDampers.size(); ++n) {
                constraintStick = this.bottomOutDampers.get(n);
                d2 = constraintStick.getRestLength() - (constraintStick.getCurrentLength() + this.bottomOutThreshold);
                if (d2 > 0.0) {
                    if (this.playedBottomedOut[n]) continue;
                    if (d2 > this.maxBottomedOut[n]) {
                        this.maxBottomedOut[n] = d2;
                        continue;
                    }
                    this.playedBottomedOut[n] = true;
                    d = this.bottomOutMinVolume + this.bottomOutDeltaVolume * d2;
                    d = Math.min(this.bottomOutMaxVolume, d);
                    this.bottomOutSound.play();
                    this.bottomOutSound.setVolume((float)d);
                    this.bottomOutSound.setTargetPitch(1.0f + (float)(Math.random() * this.pitchRandomizer));
                    continue;
                }
                this.playedBottomedOut[n] = false;
                this.maxBottomedOut[n] = 0.0;
            }
        }
        if (this.damperSoundCompress != null && this.damperSoundDeflate != null) {
            for (n = 0; n < this.dampers.size(); ++n) {
                constraintStick = this.dampers.get(n);
                d2 = constraintStick.getCurrentLength();
                d = d2 - this.damperPreviousLength[n];
                if (d > this.damperSpeedThreshold && this.damperPlaying[n] != 1) {
                    this.damperPlaying[n] = 1;
                } else if (d < -this.damperSpeedThreshold && this.damperPlaying[n] != -1) {
                    this.damperPlaying[n] = -1;
                    d = -d - this.damperSpeedThreshold;
                    double d3 = this.damperMinVolume + this.damperDeltaVolume * d;
                    d3 = Math.min(this.damperMaxVolume, d3);
                    this.damperSoundCompress.play();
                    this.damperSoundCompress.setVolume((float)d3);
                    this.damperSoundCompress.setPitch(1.0f + (float)(Math.random() * this.pitchRandomizer));
                } else {
                    this.damperPlaying[n] = 0;
                }
                this.damperPreviousLength[n] = d2;
            }
        }
    }

    private void newArrays() {
        int n;
        if (this.bottomOutDampers.size() > 0) {
            this.playedBottomedOut = new boolean[this.bottomOutDampers.size()];
            this.maxBottomedOut = new double[this.bottomOutDampers.size()];
            for (n = 0; n < this.bottomOutDampers.size(); ++n) {
                this.playedBottomedOut[n] = false;
                this.maxBottomedOut[n] = 0.0;
            }
        }
        if (this.dampers.size() > 0) {
            this.damperPlaying = new int[this.dampers.size()];
            this.damperPreviousLength = new double[this.dampers.size()];
            for (n = 0; n < this.dampers.size(); ++n) {
                this.damperPreviousLength[n] = this.dampers.get(n).getCurrentLength();
                this.damperPlaying[n] = 0;
            }
        }
    }

    public void addBottomOutConstraints(ConstraintStick constraintStick) {
        this.bottomOutDampers.add(constraintStick);
        this.newArrays();
    }

    public void addAllBottomOutConstraints(Collection<? extends ConstraintStick> collection) {
        this.bottomOutDampers.addAll(collection);
        this.newArrays();
    }

    public void removeAllBottomOutConstraints() {
        this.bottomOutDampers.clear();
        this.newArrays();
    }

    public void addDamperConstraints(ConstraintStick constraintStick) {
        this.dampers.add(constraintStick);
        this.newArrays();
    }

    public void addAllDamperConstraints(Collection<? extends ConstraintStick> collection) {
        this.dampers.addAll(collection);
        this.newArrays();
    }

    public void removeAllDamperConstraints() {
        this.dampers.clear();
        this.newArrays();
    }
}

